/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus1.MoleculeHandler;
import org.openscience.smsd.helper.BinaryTree;
import org.openscience.smsd.tools.Utility;

public class McGregor
extends Utility {
    private List<String> c_tab1_copy;
    private List<String> c_tab2_copy;
    private BinaryTree last;
    private BinaryTree first;
    protected int best_clique_size;
    final List<Integer> comp_graph_nodes;
    final List<Integer> comp_graph_nodes_C_zero;
    protected final List<IAtom> atomstr1;
    protected final List<IAtom> atomstr2;
    private int nNum_globalA;
    private int nNum_globalB;
    private final List<Integer> i_globalA;
    private final List<Integer> i_globalB;
    private final List<String> c_globalA;
    private final List<String> c_globalB;
    private List<Integer> MARCS;
    private List<Integer> FIXARCS;
    private final Stack<List<Integer>> BESTARCS;
    private int bestarcsleft;
    protected int atom_number1;
    protected int atom_number2;
    protected int atom_num_H_1;
    protected int atom_num_H_2;
    protected int bond_number1;
    protected int bond_number2;
    protected List<Integer> i_tab1;
    protected List<Integer> i_tab2;
    protected List<String> c_tab1;
    protected List<String> c_tab2;
    private boolean new_matrix;
    protected int best_MAPPING_size;
    protected Stack<List<Integer>> max_Cliques_Set;
    private final List<List<Integer>> final_MAPPINGS;
    private final List<String> SignROW;
    protected final IAtomContainer ac1;
    protected final IAtomContainer ac2;
    protected final Map<String, Integer> SYMBOL_VALUE;
    final AtomMatcher atomMatcher;
    final BondMatcher bondMatcher;

    public McGregor(IAtomContainer f1, IAtomContainer f2, AtomMatcher am, BondMatcher bm) {
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.SYMBOL_VALUE = new TreeMap<String, Integer>();
        MoleculeHandler file1 = new MoleculeHandler(f1, false);
        MoleculeHandler file2 = new MoleculeHandler(f2, false);
        this.atom_number1 = file1.indexOf();
        this.atom_number2 = file2.indexOf();
        this.atom_num_H_1 = file1.getStartHatom_num();
        this.atom_num_H_2 = file2.getStartHatom_num();
        this.bond_number1 = file1.getBondNumber();
        this.bond_number2 = file2.getBondNumber();
        this.atomstr1 = file1.getAtomString();
        this.atomstr2 = file2.getAtomString();
        this.i_tab1 = file1.intTable;
        this.i_tab2 = file2.intTable;
        this.c_tab1 = file1.charTable;
        this.c_tab2 = file2.charTable;
        this.ac1 = file1.getAtomContainer();
        this.ac2 = file2.getAtomContainer();
        this.comp_graph_nodes = new ArrayList<Integer>();
        this.comp_graph_nodes_C_zero = new ArrayList<Integer>();
        this.c_tab1_copy = new ArrayList<String>();
        this.c_tab2_copy = new ArrayList<String>();
        this.nNum_globalA = 0;
        this.nNum_globalB = 0;
        this.i_globalA = new ArrayList<Integer>();
        this.i_globalB = new ArrayList<Integer>();
        this.c_globalA = new ArrayList<String>();
        this.c_globalB = new ArrayList<String>();
        this.MARCS = new ArrayList<Integer>();
        this.FIXARCS = new ArrayList<Integer>();
        this.BESTARCS = new Stack();
        this.final_MAPPINGS = new ArrayList<List<Integer>>();
        this.max_Cliques_Set = new Stack();
        String[] characters = new String[]{"D", "G", "J", "T", "V", "W", "Y", "Z", "$", "%", "&", "*", "#", "?", "!", "~", "^", "<", ">", "=", "(", ")", "[", "]"};
        this.SignROW = Arrays.asList(characters);
    }

    protected List<Integer> find_mcgregor_MAPPING(List<Integer> MARCS_vector, int mapped_atoms_num, List<Integer> current_MAPPING, int bondnum_A, List<Integer> i_bonds_A, int bondnum_B, List<Integer> i_bonds_B) {
        ArrayList<Integer> additional_mapping = new ArrayList<Integer>();
        additional_mapping.clear();
        boolean pos = false;
        boolean number_of_ones = false;
        for (int x = 0; x < bondnum_A; ++x) {
            for (int z = 0; z < bondnum_B; ++z) {
                if (MARCS_vector.get(x * bondnum_B + z) != 1) continue;
                int cur_pos = x * this.nNum_globalB + z;
                int Atom1_moleculeA = i_bonds_A.get(x * 3 + 0);
                int Atom2_moleculeA = i_bonds_A.get(x * 3 + 1);
                int Atom1_moleculeB = i_bonds_B.get(z * 3 + 0);
                int Atom2_moleculeB = i_bonds_B.get(z * 3 + 1);
                for (int a = 0; a < mapped_atoms_num; ++a) {
                    if (current_MAPPING.get(a * 2 + 0) == Atom1_moleculeA && current_MAPPING.get(a * 2 + 1) == Atom1_moleculeB) {
                        additional_mapping.add(Atom2_moleculeA);
                        additional_mapping.add(Atom2_moleculeB);
                    }
                    if (current_MAPPING.get(a * 2 + 0) == Atom1_moleculeA && current_MAPPING.get(a * 2 + 1) == Atom2_moleculeB) {
                        additional_mapping.add(Atom2_moleculeA);
                        additional_mapping.add(Atom1_moleculeB);
                    }
                    if (current_MAPPING.get(a * 2 + 0) == Atom2_moleculeA && current_MAPPING.get(a * 2 + 1) == Atom1_moleculeB) {
                        additional_mapping.add(Atom1_moleculeA);
                        additional_mapping.add(Atom2_moleculeB);
                    }
                    if (current_MAPPING.get(a * 2 + 0) != Atom2_moleculeA || current_MAPPING.get(a * 2 + 1) != Atom2_moleculeB) continue;
                    additional_mapping.add(Atom1_moleculeA);
                    additional_mapping.add(Atom1_moleculeB);
                }
            }
        }
        int additional_mapping_size = additional_mapping.size();
        for (int a = 0; a < additional_mapping_size; a += 2) {
            current_MAPPING.add((Integer)additional_mapping.get(a));
            current_MAPPING.add((Integer)additional_mapping.get(a + 1));
        }
        List<Integer> unique_MAPPING = this.remove_recurring_mappings(current_MAPPING);
        return unique_MAPPING;
    }

    protected int McGregor_IterationStart(List<Integer> clique_vector) {
        int b;
        int a;
        this.c_tab1_copy.clear();
        this.generate_c_tab1_copy();
        this.c_tab2_copy.clear();
        this.generate_c_tab2_copy();
        ArrayList<Integer> mapped_atoms = new ArrayList<Integer>();
        int mapped_atoms_number = 0;
        int neighbor_bondnum_A = 0;
        int set_bondnum_A = 0;
        int neighbor_bondnum_B = 0;
        int set_bondnum_B = 0;
        ArrayList<Integer> i_bond_neighborsA = new ArrayList<Integer>();
        ArrayList<Integer> i_bond_setA = new ArrayList<Integer>();
        List<String> c_bond_neighborsA = new ArrayList<String>();
        ArrayList<String> c_bond_setA = new ArrayList<String>();
        ArrayList<Integer> i_bond_neighborsB = new ArrayList<Integer>();
        ArrayList<Integer> i_bond_setB = new ArrayList<Integer>();
        ArrayList<String> c_bond_neighborsB = new ArrayList<String>();
        ArrayList<String> c_bond_setB = new ArrayList<String>();
        i_bond_neighborsA.clear();
        i_bond_setA.clear();
        c_bond_neighborsA.clear();
        c_bond_setA.clear();
        i_bond_neighborsB.clear();
        i_bond_setB.clear();
        c_bond_neighborsB.clear();
        c_bond_setB.clear();
        mapped_atoms.clear();
        int clique_siz = clique_vector.size();
        int vec_size = this.comp_graph_nodes.size();
        for (int a2 = 0; a2 < clique_siz; ++a2) {
            for (int b2 = 0; b2 < vec_size; b2 += 3) {
                if (clique_vector.get(a2).intValue() != this.comp_graph_nodes.get(b2 + 2).intValue()) continue;
                mapped_atoms.add(this.comp_graph_nodes.get(b2));
                mapped_atoms.add(this.comp_graph_nodes.get(b2 + 1));
                ++mapped_atoms_number;
            }
        }
        ArrayList<Integer> unmapped_atoms_molA = new ArrayList<Integer>();
        int unmapped_numA = 0;
        boolean atomA_is_unmapped = true;
        for (int a3 = 1; a3 <= this.atom_num_H_1; ++a3) {
            for (int b3 = 0; b3 < clique_siz; ++b3) {
                if (a3 != (Integer)mapped_atoms.get(b3 * 2)) continue;
                atomA_is_unmapped = false;
            }
            if (atomA_is_unmapped) {
                unmapped_atoms_molA.add(a3);
                ++unmapped_numA;
            }
            atomA_is_unmapped = true;
        }
        int SR_count = 0;
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int a4 = 0; a4 < this.bond_number1; ++a4) {
            for (int b4 = 0; b4 < unmapped_numA; ++b4) {
                int cor_atom;
                int c;
                if (((Integer)unmapped_atoms_molA.get(b4)).intValue() == this.i_tab1.get(a4 * 3 + 0).intValue()) {
                    for (c = 0; c < clique_siz; ++c) {
                        if (((Integer)mapped_atoms.get(c * 2)).intValue() != this.i_tab1.get(a4 * 3 + 1).intValue()) continue;
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 0));
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 1));
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 2));
                        if (this.c_tab1_copy.get(a4 * 4 + 3).equals("X")) {
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 0));
                            c_bond_neighborsA.add(this.SignROW.get(SR_count));
                            c_bond_neighborsA.add("X");
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 1));
                            this.c_tab1_copy = this.change_char_bonds(this.i_tab1.get(a4 * 3 + 1), this.SignROW.get(SR_count), this.bond_number1, this.i_tab1, this.c_tab1_copy);
                            cor_atom = this.search_corresponding_atom(clique_siz, this.i_tab1.get(a4 * 3 + 1), 1, mapped_atoms);
                            this.c_tab2_copy = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), this.bond_number2, this.i_tab2, this.c_tab2_copy);
                            ++SR_count;
                        } else {
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 0));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 1));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 2));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 3));
                        }
                        normal_bond = false;
                        ++neighbor_bondnum_A;
                    }
                    if (normal_bond) {
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 0));
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 1));
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 2));
                        c_bond_setA.add(this.c_tab1_copy.get(a4 * 4 + 0));
                        c_bond_setA.add(this.c_tab1_copy.get(a4 * 4 + 1));
                        c_bond_setA.add("X");
                        c_bond_setA.add("X");
                        ++set_bondnum_A;
                    }
                    normal_bond = true;
                    bond_considered = true;
                }
                if (((Integer)unmapped_atoms_molA.get(b4)).intValue() == this.i_tab1.get(a4 * 3 + 1).intValue()) {
                    for (c = 0; c < clique_siz; ++c) {
                        if (!((Integer)mapped_atoms.get(c * 2 + 0)).equals(this.i_tab1.get(a4 * 3 + 0))) continue;
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 0));
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 1));
                        i_bond_neighborsA.add(this.i_tab1.get(a4 * 3 + 2));
                        if (this.c_tab1_copy.get(a4 * 4 + 2).equals("X")) {
                            c_bond_neighborsA.add(this.SignROW.get(SR_count));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 1));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 0));
                            c_bond_neighborsA.add("X");
                            this.c_tab1_copy = this.change_char_bonds(this.i_tab1.get(a4 * 3 + 0), this.SignROW.get(SR_count), this.bond_number1, this.i_tab1, this.c_tab1_copy);
                            cor_atom = this.search_corresponding_atom(clique_siz, this.i_tab1.get(a4 * 3 + 0), 1, mapped_atoms);
                            this.c_tab2_copy = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), this.bond_number2, this.i_tab2, this.c_tab2_copy);
                            ++SR_count;
                        } else {
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 0));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 1));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 2));
                            c_bond_neighborsA.add(this.c_tab1_copy.get(a4 * 4 + 3));
                        }
                        normal_bond = false;
                        ++neighbor_bondnum_A;
                    }
                    if (normal_bond) {
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 0));
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 1));
                        i_bond_setA.add(this.i_tab1.get(a4 * 3 + 2));
                        c_bond_setA.add(this.c_tab1.get(a4 * 2 + 0));
                        c_bond_setA.add(this.c_tab1.get(a4 * 2 + 1));
                        c_bond_setA.add("X");
                        c_bond_setA.add("X");
                        ++set_bondnum_A;
                    }
                    normal_bond = true;
                    bond_considered = true;
                }
                if (bond_considered) break;
            }
            bond_considered = false;
        }
        ArrayList<Integer> unmapped_atoms_molB = new ArrayList<Integer>();
        int unmapped_numB = 0;
        boolean atomB_is_unmapped = true;
        for (a = 1; a <= this.atom_num_H_2; ++a) {
            for (b = 0; b < clique_siz; ++b) {
                if (a != (Integer)mapped_atoms.get(b * 2 + 1)) continue;
                atomB_is_unmapped = false;
            }
            if (atomB_is_unmapped) {
                unmapped_atoms_molB.add(a);
                ++unmapped_numB;
            }
            atomB_is_unmapped = true;
        }
        bond_considered = false;
        normal_bond = true;
        for (a = 0; a < this.bond_number2; ++a) {
            for (b = 0; b < unmapped_numB; ++b) {
                int cor_atom;
                int c;
                if (((Integer)unmapped_atoms_molB.get(b)).intValue() == this.i_tab2.get(a * 3 + 0).intValue()) {
                    for (c = 0; c < clique_siz; ++c) {
                        if (((Integer)mapped_atoms.get(c * 2 + 1)).intValue() != this.i_tab2.get(a * 3 + 1).intValue()) continue;
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 0));
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 1));
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 2));
                        if (this.c_tab2_copy.get(a * 4 + 3).equals("X")) {
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 0));
                            c_bond_neighborsB.add(this.SignROW.get(SR_count));
                            c_bond_neighborsB.add("X");
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 1));
                            this.c_tab2_copy = this.change_char_bonds(this.i_tab2.get(a * 3 + 1), this.SignROW.get(SR_count), this.bond_number2, this.i_tab2, this.c_tab2_copy);
                            cor_atom = this.search_corresponding_atom(clique_siz, this.i_tab2.get(a * 3 + 1), 2, mapped_atoms);
                            c_bond_neighborsA = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), neighbor_bondnum_A, i_bond_neighborsA, c_bond_neighborsA);
                            ++SR_count;
                        } else {
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 0));
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 1));
                            c_bond_neighborsB.add("X");
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 3));
                        }
                        normal_bond = false;
                        ++neighbor_bondnum_B;
                    }
                    if (normal_bond) {
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 0));
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 1));
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 2));
                        c_bond_setB.add(this.c_tab2_copy.get(a * 4 + 0));
                        c_bond_setB.add(this.c_tab2_copy.get(a * 4 + 1));
                        c_bond_setB.add("X");
                        c_bond_setB.add("X");
                        ++set_bondnum_B;
                    }
                    normal_bond = true;
                    bond_considered = true;
                }
                if (((Integer)unmapped_atoms_molB.get(b)).intValue() == this.i_tab2.get(a * 3 + 1).intValue()) {
                    for (c = 0; c < clique_siz; ++c) {
                        if (((Integer)mapped_atoms.get(c * 2 + 1)).intValue() != this.i_tab2.get(a * 3 + 0).intValue()) continue;
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 0));
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 1));
                        i_bond_neighborsB.add(this.i_tab2.get(a * 3 + 2));
                        if (this.c_tab2_copy.get(a * 4 + 2).equals("X")) {
                            c_bond_neighborsB.add(this.SignROW.get(SR_count));
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 1));
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 0));
                            c_bond_neighborsB.add("X");
                            this.c_tab2_copy = this.change_char_bonds(this.i_tab2.get(a * 3 + 0), this.SignROW.get(SR_count), this.bond_number2, this.i_tab2, this.c_tab2_copy);
                            cor_atom = this.search_corresponding_atom(clique_siz, this.i_tab2.get(a * 3 + 0), 2, mapped_atoms);
                            c_bond_neighborsA = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), neighbor_bondnum_A, i_bond_neighborsA, c_bond_neighborsA);
                            ++SR_count;
                        } else {
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 0));
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 1));
                            c_bond_neighborsB.add(this.c_tab2_copy.get(a * 4 + 2));
                            c_bond_neighborsB.add("X");
                        }
                        normal_bond = false;
                        ++neighbor_bondnum_B;
                    }
                    if (normal_bond) {
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 0));
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 1));
                        i_bond_setB.add(this.i_tab2.get(a * 3 + 2));
                        c_bond_setB.add(this.c_tab2_copy.get(a * 4 + 0));
                        c_bond_setB.add(this.c_tab2_copy.get(a * 4 + 1));
                        c_bond_setB.add("X");
                        c_bond_setB.add("X");
                        ++set_bondnum_B;
                    }
                    normal_bond = true;
                    bond_considered = true;
                }
                if (bond_considered) break;
            }
            bond_considered = false;
        }
        boolean dummy = false;
        this.Iterator(dummy, mapped_atoms_number, mapped_atoms, neighbor_bondnum_A, neighbor_bondnum_B, i_bond_neighborsA, i_bond_neighborsB, c_bond_neighborsA, c_bond_neighborsB, set_bondnum_A, set_bondnum_B, i_bond_setA, i_bond_setB, c_bond_setA, c_bond_setB);
        return 0;
    }

    private int generate_c_tab1_copy() {
        for (int a = 0; a < this.bond_number1; ++a) {
            this.c_tab1_copy.add(this.c_tab1.get(a * 2 + 0));
            this.c_tab1_copy.add(this.c_tab1.get(a * 2 + 1));
            this.c_tab1_copy.add("X");
            this.c_tab1_copy.add("X");
        }
        return 0;
    }

    private int generate_c_tab2_copy() {
        for (int a = 0; a < this.bond_number2; ++a) {
            this.c_tab2_copy.add(this.c_tab2.get(a * 2 + 0));
            this.c_tab2_copy.add(this.c_tab2.get(a * 2 + 1));
            this.c_tab2_copy.add("X");
            this.c_tab2_copy.add("X");
        }
        return 0;
    }

    private List<Integer> remove_recurring_mappings(List<Integer> atom_mapping) {
        boolean exist = true;
        ArrayList<Integer> temp_map = new ArrayList<Integer>();
        int temp_counter = 0;
        int atom_mapping_size = atom_mapping.size();
        for (int x = 0; x < atom_mapping_size; x += 2) {
            int atom = atom_mapping.get(x);
            for (int y = x + 2; y < atom_mapping_size; y += 2) {
                if (atom != atom_mapping.get(y)) continue;
                exist = false;
            }
            if (exist) {
                temp_map.add(atom_mapping.get(x));
                temp_map.add(atom_mapping.get(x + 1));
                temp_counter += 2;
            }
            exist = true;
        }
        return temp_map;
    }

    private List<String> change_char_bonds(int corresponding_atom, String new_symbol, int neighbor_bondnum, List<Integer> i_bond_neighbors, List<String> c_bond_neighbors) {
        ArrayList<String> c_bond_neighbors_Local = new ArrayList<String>(c_bond_neighbors);
        for (int a = 0; a < neighbor_bondnum; ++a) {
            if (i_bond_neighbors.get(a * 3 + 0).equals(corresponding_atom) && ((String)c_bond_neighbors_Local.get(a * 4 + 2)).equals("X")) {
                c_bond_neighbors_Local.set(a * 4 + 2, (String)c_bond_neighbors_Local.get(a * 4 + 0));
                c_bond_neighbors_Local.set(a * 4 + 0, new_symbol);
            }
            if (!i_bond_neighbors.get(a * 3 + 1).equals(corresponding_atom) || !((String)c_bond_neighbors_Local.get(a * 4 + 3)).equals("X")) continue;
            c_bond_neighbors_Local.set(a * 4 + 3, (String)c_bond_neighbors_Local.get(a * 4 + 1));
            c_bond_neighbors_Local.set(a * 4 + 1, new_symbol);
        }
        return c_bond_neighbors_Local;
    }

    private int search_corresponding_atom(int mapped_atoms_size, int atom_from_other_molecule, int molecule, List<Integer> mapped_atoms) {
        int corresponding_atom = 0;
        for (int a = 0; a < mapped_atoms_size; ++a) {
            if (molecule == 1 && mapped_atoms.get(a * 2 + 0) == atom_from_other_molecule) {
                corresponding_atom = mapped_atoms.get(a * 2 + 1);
            }
            if (molecule != 2 || mapped_atoms.get(a * 2 + 1) != atom_from_other_molecule) continue;
            corresponding_atom = mapped_atoms.get(a * 2 + 0);
        }
        return corresponding_atom;
    }

    private int Iterator(boolean MAPPING_check, int mapped_atoms_num, List<Integer> mapped_atoms, int neighbor_bondnum_A, int neighbor_bondnum_B, List<Integer> i_bond_neighborsA, List<Integer> i_bond_neighborsB, List<String> c_bond_neighborsA, List<String> c_bond_neighborsB, int set_num_A, int set_num_B, List<Integer> i_bond_setA, List<Integer> i_bond_setB, List<String> c_bond_setA, List<String> c_bond_setB) {
        int row;
        boolean no_Map = true;
        for (row = 0; row < neighbor_bondnum_A; ++row) {
            String G1A = c_bond_neighborsA.get(row * 4 + 0);
            String G2A = c_bond_neighborsA.get(row * 4 + 1);
            IAtom a1 = this.ac1.getAtom(i_bond_neighborsA.get(row * 3 + 0) - 1);
            IAtom a2 = this.ac1.getAtom(i_bond_neighborsA.get(row * 3 + 1) - 1);
            IBond bond1 = this.ac1.getBond(a1, a2);
            for (int column = 0; column < neighbor_bondnum_B; ++column) {
                String G1B = c_bond_neighborsB.get(column * 4 + 0);
                String G2B = c_bond_neighborsB.get(column * 4 + 1);
                IAtom b1 = this.ac2.getAtom(i_bond_neighborsB.get(column * 3 + 0) - 1);
                IAtom b2 = this.ac2.getAtom(i_bond_neighborsB.get(column * 3 + 1) - 1);
                IBond bond2 = this.ac2.getBond(b1, b2);
                boolean flag = AtomBondMatcher.matchAtomAndBond(bond1, bond2, this.atomMatcher, this.bondMatcher, true);
                if (G1A.equals(G1B) && G2A.equals(G2B) && flag) {
                    no_Map = false;
                    break;
                }
                if (!G1A.equals(G2B) || !G2A.equals(G1B) || !flag) continue;
                no_Map = false;
                break;
            }
            if (!no_Map) break;
        }
        if (neighbor_bondnum_A == 0 || neighbor_bondnum_B == 0 || MAPPING_check || no_Map) {
            if (mapped_atoms_num >= this.best_MAPPING_size) {
                if (mapped_atoms_num > this.best_MAPPING_size) {
                    this.getFinalMappings().clear();
                    this.best_MAPPING_size = mapped_atoms_num;
                }
                this.getFinalMappings().add(mapped_atoms);
            }
            return 0;
        }
        this.i_globalA.clear();
        this.i_globalB.clear();
        this.c_globalA.clear();
        this.c_globalB.clear();
        this.nNum_globalA = neighbor_bondnum_A;
        this.nNum_globalB = neighbor_bondnum_B;
        this.i_globalA.addAll(i_bond_neighborsA);
        this.i_globalB.addAll(i_bond_neighborsB);
        this.c_globalA.addAll(c_bond_neighborsA);
        this.c_globalB.addAll(c_bond_neighborsB);
        this.MARCS.clear();
        this.MARCS = new ArrayList<Integer>(neighbor_bondnum_A * neighbor_bondnum_B);
        for (int i = 0; i < neighbor_bondnum_A * neighbor_bondnum_B; ++i) {
            this.MARCS.add(i, 0);
        }
        for (row = 0; row < neighbor_bondnum_A; ++row) {
            for (int column = 0; column < neighbor_bondnum_B; ++column) {
                String G1A = c_bond_neighborsA.get(row * 4 + 0);
                String G2A = c_bond_neighborsA.get(row * 4 + 1);
                String G1B = c_bond_neighborsB.get(column * 4 + 0);
                String G2B = c_bond_neighborsB.get(column * 4 + 1);
                if ((!G1A.equals(G1B) || !G2A.equals(G2B)) && (!G1A.equals(G2B) || !G2A.equals(G1B))) continue;
                this.MARCS.set(row * neighbor_bondnum_B + column, 1);
            }
        }
        this.first = this.last = new BinaryTree(-1);
        this.bestarcsleft = 0;
        this.startsearch();
        Stack BESTARCS_copy = (Stack)this.BESTARCS.clone();
        while (!this.BESTARCS.empty()) {
            this.BESTARCS.pop();
        }
        while (!BESTARCS_copy.empty()) {
            int b;
            int a;
            List MARCS_vector = (List)BESTARCS_copy.peek();
            List<Integer> new_MAPPING = this.find_mcgregor_MAPPING(MARCS_vector, mapped_atoms_num, mapped_atoms, neighbor_bondnum_A, i_bond_neighborsA, neighbor_bondnum_B, i_bond_neighborsB);
            int new_MAPPING_size = new_MAPPING.size();
            boolean no_further_MAPPINGS = false;
            if (mapped_atoms_num == new_MAPPING_size / 2) {
                no_further_MAPPINGS = true;
            }
            int new_neighbor_numA = 0;
            int new_neighbor_numB = 0;
            ArrayList<Integer> new_i_neighborsA = new ArrayList<Integer>();
            ArrayList<Integer> new_i_neighborsB = new ArrayList<Integer>();
            List<String> new_c_neighborsA = new ArrayList<String>();
            ArrayList<String> new_c_neighborsB = new ArrayList<String>();
            new_i_neighborsA.clear();
            new_i_neighborsB.clear();
            new_c_neighborsA.clear();
            new_c_neighborsB.clear();
            int set_bondnum_A = 0;
            int set_bondnum_B = 0;
            ArrayList<Integer> new_i_bond_setA = new ArrayList<Integer>();
            ArrayList<Integer> new_i_bond_setB = new ArrayList<Integer>();
            ArrayList<String> new_c_bond_setA = new ArrayList<String>();
            ArrayList<String> new_c_bond_setB = new ArrayList<String>();
            new_i_bond_setA.clear();
            new_i_bond_setB.clear();
            new_c_bond_setA.clear();
            new_c_bond_setB.clear();
            List<String> c_setB_copy = this.generate_c_setB_copy(set_num_B, c_bond_setB);
            List<String> c_setA_copy = new ArrayList<String>(c_bond_setA);
            ArrayList<Integer> unmapped_atoms_molA = new ArrayList<Integer>();
            unmapped_atoms_molA.clear();
            int unmapped_numA = 0;
            boolean atomA_is_unmapped = true;
            for (int a2 = 1; a2 <= this.atom_num_H_1; ++a2) {
                for (int b2 = 0; b2 < new_MAPPING_size / 2; ++b2) {
                    if (a2 != new_MAPPING.get(b2 * 2 + 0)) continue;
                    atomA_is_unmapped = false;
                }
                if (atomA_is_unmapped) {
                    unmapped_atoms_molA.add(a2);
                    ++unmapped_numA;
                }
                atomA_is_unmapped = true;
            }
            int SR_count = 0;
            boolean bond_considered = false;
            boolean normal_bond = true;
            for (int a3 = 0; a3 < set_num_A; ++a3) {
                for (int b3 = 0; b3 < unmapped_numA; ++b3) {
                    int cor_atom;
                    int c;
                    if (((Integer)unmapped_atoms_molA.get(b3)).intValue() == i_bond_setA.get(a3 * 3 + 0).intValue()) {
                        for (c = 0; c < new_MAPPING_size / 2; ++c) {
                            if (new_MAPPING.get(c * 2 + 0).intValue() != i_bond_setA.get(a3 * 3 + 1).intValue()) continue;
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 0));
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 1));
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 2));
                            new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 0));
                            if (((String)c_setA_copy.get(a3 * 4 + 3)).equals("X")) {
                                new_c_neighborsA.add(this.SignROW.get(SR_count));
                                new_c_neighborsA.add("X");
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 1));
                                c_setA_copy = this.change_char_bonds(i_bond_setA.get(a3 * 3 + 1), this.SignROW.get(SR_count), set_num_A, i_bond_setA, c_setA_copy);
                                cor_atom = this.search_corresponding_atom(new_MAPPING_size / 2, i_bond_setA.get(a3 * 3 + 1), 1, new_MAPPING);
                                c_setB_copy = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), set_num_B, i_bond_setB, c_setB_copy);
                                ++SR_count;
                            } else {
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 1));
                                new_c_neighborsA.add("X");
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 3));
                            }
                            normal_bond = false;
                            ++new_neighbor_numA;
                        }
                        if (normal_bond) {
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 0));
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 1));
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 2));
                            new_c_bond_setA.add((String)c_setA_copy.get(a3 * 4 + 0));
                            new_c_bond_setA.add((String)c_setA_copy.get(a3 * 4 + 1));
                            new_c_bond_setA.add("X");
                            new_c_bond_setA.add("X");
                            ++set_bondnum_A;
                        }
                        normal_bond = true;
                        bond_considered = true;
                    }
                    if (((Integer)unmapped_atoms_molA.get(b3)).intValue() == i_bond_setA.get(a3 * 3 + 1).intValue()) {
                        for (c = 0; c < new_MAPPING_size / 2; ++c) {
                            if (new_MAPPING.get(c * 2 + 0).intValue() != i_bond_setA.get(a3 * 3 + 0).intValue()) continue;
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 0));
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 1));
                            new_i_neighborsA.add(i_bond_setA.get(a3 * 3 + 2));
                            if (((String)c_setA_copy.get(a3 * 4 + 2)).equals("X")) {
                                new_c_neighborsA.add(this.SignROW.get(SR_count));
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 1));
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 0));
                                new_c_neighborsA.add("X");
                                c_setA_copy = this.change_char_bonds(i_bond_setA.get(a3 * 3 + 0), this.SignROW.get(SR_count), set_num_A, i_bond_setA, c_setA_copy);
                                cor_atom = this.search_corresponding_atom(new_MAPPING_size / 2, i_bond_setA.get(a3 * 3 + 0), 1, new_MAPPING);
                                c_setB_copy = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), set_num_B, i_bond_setB, c_setB_copy);
                                ++SR_count;
                            } else {
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 0));
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 1));
                                new_c_neighborsA.add((String)c_setA_copy.get(a3 * 4 + 2));
                                new_c_neighborsA.add("X");
                            }
                            normal_bond = false;
                            ++new_neighbor_numA;
                        }
                        if (normal_bond) {
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 0));
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 1));
                            new_i_bond_setA.add(i_bond_setA.get(a3 * 3 + 2));
                            new_c_bond_setA.add((String)c_setA_copy.get(a3 * 4 + 0));
                            new_c_bond_setA.add((String)c_setA_copy.get(a3 * 4 + 1));
                            new_c_bond_setA.add("X");
                            new_c_bond_setA.add("X");
                            ++set_bondnum_A;
                        }
                        normal_bond = true;
                        bond_considered = true;
                    }
                    if (bond_considered) break;
                }
                bond_considered = false;
            }
            ArrayList<Integer> unmapped_atoms_molB = new ArrayList<Integer>();
            unmapped_atoms_molB.clear();
            int unmapped_numB = 0;
            boolean atomB_is_unmapped = true;
            for (a = 1; a <= this.atom_num_H_2; ++a) {
                for (b = 0; b < new_MAPPING_size / 2; ++b) {
                    if (a != new_MAPPING.get(b * 2 + 1)) continue;
                    atomB_is_unmapped = false;
                }
                if (atomB_is_unmapped) {
                    unmapped_atoms_molB.add(a);
                    ++unmapped_numB;
                }
                atomB_is_unmapped = true;
            }
            bond_considered = false;
            normal_bond = true;
            for (a = 0; a < set_num_B; ++a) {
                for (b = 0; b < unmapped_numB; ++b) {
                    int cor_atom;
                    int c;
                    if (((Integer)unmapped_atoms_molB.get(b)).intValue() == i_bond_setB.get(a * 3 + 0).intValue()) {
                        for (c = 0; c < new_MAPPING_size / 2; ++c) {
                            if (new_MAPPING.get(c * 2 + 1).intValue() != i_bond_setB.get(a * 3 + 1).intValue()) continue;
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 0));
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 1));
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 2));
                            if (c_setB_copy.get(a * 4 + 3).equals("X")) {
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 0));
                                new_c_neighborsB.add(this.SignROW.get(SR_count));
                                new_c_neighborsB.add("X");
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 1));
                                c_setB_copy = this.change_char_bonds(i_bond_setB.get(a * 3 + 1), this.SignROW.get(SR_count), set_num_B, i_bond_setB, c_setB_copy);
                                cor_atom = this.search_corresponding_atom(new_MAPPING_size / 2, i_bond_setB.get(a * 3 + 1), 2, new_MAPPING);
                                new_c_neighborsA = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), new_neighbor_numA, new_i_neighborsA, new_c_neighborsA);
                                ++SR_count;
                            } else {
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 0));
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 1));
                                new_c_neighborsB.add("X");
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 3));
                            }
                            normal_bond = false;
                            ++new_neighbor_numB;
                        }
                        if (normal_bond) {
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 0));
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 1));
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 2));
                            new_c_bond_setB.add(c_setB_copy.get(a * 4 + 0));
                            new_c_bond_setB.add(c_setB_copy.get(a * 4 + 1));
                            new_c_bond_setB.add("X");
                            new_c_bond_setB.add("X");
                            ++set_bondnum_B;
                        }
                        normal_bond = true;
                        bond_considered = true;
                    }
                    if (((Integer)unmapped_atoms_molB.get(b)).intValue() == i_bond_setB.get(a * 3 + 1).intValue()) {
                        for (c = 0; c < new_MAPPING_size / 2; ++c) {
                            if (!new_MAPPING.get(c * 2 + 1).equals(i_bond_setB.get(a * 3 + 0))) continue;
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 0));
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 1));
                            new_i_neighborsB.add(i_bond_setB.get(a * 3 + 2));
                            if (c_setB_copy.get(a * 4 + 2).equals("X")) {
                                new_c_neighborsB.add(this.SignROW.get(SR_count));
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 1));
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 0));
                                new_c_neighborsB.add("X");
                                c_setB_copy = this.change_char_bonds(i_bond_setB.get(a * 3 + 0), this.SignROW.get(SR_count), set_num_B, i_bond_setB, c_setB_copy);
                                cor_atom = this.search_corresponding_atom(new_MAPPING_size / 2, i_bond_setB.get(a * 3 + 0), 2, new_MAPPING);
                                new_c_neighborsA = this.change_char_bonds(cor_atom, this.SignROW.get(SR_count), new_neighbor_numA, new_i_neighborsA, new_c_neighborsA);
                                ++SR_count;
                            } else {
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 0));
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 1));
                                new_c_neighborsB.add(c_setB_copy.get(a * 4 + 2));
                                new_c_neighborsB.add("X");
                            }
                            normal_bond = false;
                            ++new_neighbor_numB;
                        }
                        if (normal_bond) {
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 0));
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 1));
                            new_i_bond_setB.add(i_bond_setB.get(a * 3 + 2));
                            new_c_bond_setB.add(c_setB_copy.get(a * 4 + 0));
                            new_c_bond_setB.add(c_setB_copy.get(a * 4 + 1));
                            new_c_bond_setB.add("X");
                            new_c_bond_setB.add("X");
                            ++set_bondnum_B;
                        }
                        normal_bond = true;
                        bond_considered = true;
                    }
                    if (bond_considered) break;
                }
                bond_considered = false;
            }
            this.Iterator(no_further_MAPPINGS, new_MAPPING_size / 2, new_MAPPING, new_neighbor_numA, new_neighbor_numB, new_i_neighborsA, new_i_neighborsB, new_c_neighborsA, new_c_neighborsB, set_bondnum_A, set_bondnum_B, new_i_bond_setA, new_i_bond_setB, new_c_bond_setA, new_c_bond_setB);
            if (BESTARCS_copy.isEmpty()) continue;
            BESTARCS_copy.pop();
        }
        return 0;
    }

    private void startsearch() {
        this.FIXARCS = new ArrayList<Integer>(this.nNum_globalA * this.nNum_globalB);
        for (int i = 0; i < this.nNum_globalA * this.nNum_globalB; ++i) {
            this.FIXARCS.add(i, 0);
        }
        int x = 0;
        int y = 0;
        while (x < this.nNum_globalA && this.MARCS.get(x * this.nNum_globalB + y) != 1) {
            if (++y != this.nNum_globalB) continue;
            y = 0;
            ++x;
        }
        if (x == this.nNum_globalA) {
            y = this.nNum_globalB - 1;
            --x;
        }
        if (this.MARCS.get(x * this.nNum_globalB + y) == 0) {
            this.partsearch(x, y, this.MARCS);
        }
        if (this.MARCS.get(x * this.nNum_globalB + y) != 0) {
            this.partsearch(x, y, this.MARCS);
            this.MARCS.set(x * this.nNum_globalB + y, 0);
            this.partsearch(x, y, this.MARCS);
        }
    }

    private void partsearch(int xstart, int ystart, List<Integer> TEMPMARCS) {
        int x = xstart;
        int y = ystart;
        if (TEMPMARCS.get(xstart * this.nNum_globalB + ystart) == 1) {
            TEMPMARCS = this.remove_redundant_arcs(xstart, ystart, TEMPMARCS);
            int arcsleft = 0;
            for (int a = 0; a < this.nNum_globalA; ++a) {
                for (int b = 0; b < this.nNum_globalB; ++b) {
                    if (TEMPMARCS.get(a * this.nNum_globalB + b) != 1) continue;
                    ++arcsleft;
                }
            }
            if (arcsleft >= this.bestarcsleft) {
                do {
                    if (++y != this.nNum_globalB) continue;
                    y = 0;
                    ++x;
                } while (x < this.nNum_globalA && TEMPMARCS.get(x * this.nNum_globalB + y) != 1);
                if (x < this.nNum_globalA) {
                    this.partsearch(x, y, TEMPMARCS);
                    TEMPMARCS.set(x * this.nNum_globalB + y, 0);
                    this.partsearch(x, y, TEMPMARCS);
                } else {
                    if (arcsleft > this.bestarcsleft) {
                        BinaryTree.remove_tree_structure(this.first);
                        this.first = this.last = new BinaryTree();
                        while (!this.BESTARCS.empty()) {
                            this.BESTARCS.pop();
                        }
                    }
                    this.bestarcsleft = arcsleft;
                    if (this.check_MARCS(TEMPMARCS)) {
                        this.BESTARCS.push(TEMPMARCS);
                    }
                }
            }
        } else {
            do {
                if (++y != this.nNum_globalB) continue;
                y = 0;
                ++x;
            } while (x < this.nNum_globalA && TEMPMARCS.get(x * this.nNum_globalB + y) != 1);
            if (x < this.nNum_globalA) {
                this.partsearch(x, y, TEMPMARCS);
                TEMPMARCS.set(x * this.nNum_globalB + y, 0);
                this.partsearch(x, y, TEMPMARCS);
            } else {
                int arcsleft = 0;
                for (int a = 0; a < this.nNum_globalA; ++a) {
                    for (int b = 0; b < this.nNum_globalB; ++b) {
                        if (TEMPMARCS.get(a * this.nNum_globalB + b) != 1) continue;
                        ++arcsleft;
                    }
                }
                if (arcsleft >= this.bestarcsleft) {
                    if (arcsleft > this.bestarcsleft) {
                        BinaryTree.remove_tree_structure(this.first);
                        this.first = this.last = new BinaryTree();
                        while (!this.BESTARCS.empty()) {
                            this.BESTARCS.pop();
                        }
                    }
                    this.bestarcsleft = arcsleft;
                    if (this.check_MARCS(TEMPMARCS)) {
                        this.BESTARCS.push(TEMPMARCS);
                    }
                }
            }
        }
    }

    private List<String> generate_c_setB_copy(int bond_number, List<String> c_setB) {
        ArrayList<String> c_setB_copy = new ArrayList<String>();
        for (int a = 0; a < bond_number; ++a) {
            c_setB_copy.add(c_setB.get(a * 4 + 0));
            c_setB_copy.add(c_setB.get(a * 4 + 1));
            c_setB_copy.add("X");
            c_setB_copy.add("X");
        }
        return c_setB_copy;
    }

    private List<Integer> remove_redundant_arcs(int row, int column, List<Integer> MARCS) {
        ArrayList<Integer> MARCS_LOCAL = new ArrayList<Integer>(MARCS);
        int G1_atom = this.i_globalA.get(row * 3 + 0);
        int G2_atom = this.i_globalA.get(row * 3 + 1);
        int G3_atom = this.i_globalB.get(column * 3 + 0);
        int G4_atom = this.i_globalB.get(column * 3 + 1);
        for (int x = 0; x < this.nNum_globalA; ++x) {
            int row_atom1 = this.i_globalA.get(x * 3 + 0);
            int row_atom2 = this.i_globalA.get(x * 3 + 1);
            for (int y = 0; y < this.nNum_globalB; ++y) {
                int column_atom3 = this.i_globalB.get(y * 3 + 0);
                int column_atom4 = this.i_globalB.get(y * 3 + 1);
                if ((G1_atom == row_atom1 || G1_atom == row_atom2) && column_atom3 != G3_atom && column_atom4 != G3_atom && column_atom3 != G4_atom && column_atom4 != G4_atom) {
                    MARCS_LOCAL.set(x * this.nNum_globalB + y, 0);
                }
                if ((G2_atom == row_atom1 || G2_atom == row_atom2) && column_atom3 != G3_atom && column_atom4 != G3_atom && column_atom3 != G4_atom && column_atom4 != G4_atom) {
                    MARCS_LOCAL.set(x * this.nNum_globalB + y, 0);
                }
                if ((G3_atom == column_atom3 || G3_atom == column_atom4) && row_atom1 != G1_atom && row_atom2 != G1_atom && row_atom1 != G2_atom && row_atom2 != G2_atom) {
                    MARCS_LOCAL.set(x * this.nNum_globalB + y, 0);
                }
                if (G4_atom != column_atom3 && G4_atom != column_atom4 || row_atom1 == G1_atom || row_atom2 == G1_atom || row_atom1 == G2_atom || row_atom2 == G2_atom) continue;
                MARCS_LOCAL.set(x * this.nNum_globalB + y, 0);
            }
        }
        for (int v = 0; v < this.nNum_globalA; ++v) {
            MARCS_LOCAL.set(v * this.nNum_globalB + column, 0);
        }
        for (int w = 0; w < this.nNum_globalB; ++w) {
            MARCS_LOCAL.set(row * this.nNum_globalB + w, 0);
        }
        MARCS_LOCAL.set(row * this.nNum_globalB + column, 1);
        return MARCS_LOCAL;
    }

    private boolean check_MARCS(List<Integer> MARCS) {
        ArrayList<Integer> posnum_list = new ArrayList<Integer>(this.nNum_globalA * this.nNum_globalA);
        for (int i = 0; i < this.nNum_globalA * this.nNum_globalA; ++i) {
            posnum_list.add(i, 0);
        }
        int y = 0;
        int count_entries = 0;
        for (int x = 0; x < this.nNum_globalA * this.nNum_globalB; ++x) {
            if (MARCS.get(x) != 1) continue;
            posnum_list.set(y++, x);
            ++count_entries;
        }
        this.verify_nodes(posnum_list, this.first, 0, count_entries);
        return this.new_matrix;
    }

    private boolean verify_nodes(List<Integer> matrix, BinaryTree cur_struc, int x, int field_length) {
        if (matrix.get(x).equals(cur_struc.getValue()) && x < field_length && cur_struc.getEqual() != null) {
            this.new_matrix = false;
            this.verify_nodes(matrix, cur_struc.getEqual(), x + 1, field_length);
        }
        if (matrix.get(x).intValue() != cur_struc.getValue()) {
            if (cur_struc.getEqual() != null) {
                this.verify_nodes(matrix, cur_struc.getNotEqual(), x, field_length);
            }
            if (cur_struc.getNotEqual() == null) {
                BinaryTree binaryTree = new BinaryTree(matrix.get(x));
                cur_struc.setNotEqual(binaryTree);
                cur_struc.getNotEqual().setNotEqual(null);
                int y = 0;
                BinaryTree last_one = cur_struc.getNotEqual();
                while (y + x + 1 < field_length) {
                    BinaryTree binaryTree1 = new BinaryTree();
                    last_one.setEqual(binaryTree1);
                    last_one = last_one.getEqual();
                    last_one.setValue(matrix.get(y + x + 1));
                    last_one.setNotEqual(null);
                    ++y;
                }
                last_one.setEqual(null);
                this.new_matrix = true;
            }
        }
        return true;
    }

    public List<List<Integer>> getFinalMappings() {
        return this.final_MAPPINGS;
    }
}

