/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public final class MoleculeHandler {
    private final IAtomContainer atomContainer;
    int bondNumber = 0;
    int atomNumber = 0;
    int startHatom_num = 0;
    private List<IAtom> atomString;
    public List<Integer> intTable = new LinkedList<Integer>();
    public List<String> charTable = new LinkedList<String>();
    protected List<Integer> specified_int_tab = new LinkedList<Integer>();
    protected List<Integer> int_tab = new LinkedList<Integer>();
    protected List<String> char_tab = new LinkedList<String>();
    private boolean bm;

    public MoleculeHandler(IAtomContainer atomContainer, boolean bm) {
        this.atomContainer = atomContainer;
        this.bondNumber = atomContainer.getBondCount();
        this.atomNumber = atomContainer.getAtomCount();
        this.setAtomString();
        this.setIntConnectionTable();
        this.setCharConnectionTable();
        this.enumerate_startHatom_num();
        boolean no_H2 = true;
        if (this.atomNumber == 2 && this.bondNumber == 1 && this.atomString.get(0).getSymbol().equals("H") && this.atomString.get(1).getSymbol().equals("H")) {
            no_H2 = false;
        }
        this.discard_H_bonds(no_H2);
        this.int_tab_specifier(this.atomContainer.getAtomCount() * this.atomContainer.getBondCount());
    }

    public int getBondNumber() {
        return this.bondNumber;
    }

    public int indexOf() {
        return this.atomNumber;
    }

    public List<IAtom> getAtomString() {
        return this.atomString;
    }

    public int getStartHatom_num() {
        this.setHydrogenNumber();
        return this.startHatom_num;
    }

    private void setHydrogenNumber() {
        this.startHatom_num = this.getAtomContainer().getAtomCount();
        for (int atom = 0; atom < this.atomNumber; ++atom) {
            if (!this.getAtomContainer().getAtom(atom).getSymbol().equals("H")) continue;
            --this.startHatom_num;
        }
    }

    private void setAtomString() {
        ArrayList<IAtom> temp = new ArrayList<IAtom>();
        for (int atom = 0; atom < this.atomNumber; ++atom) {
            IAtom atomType = this.getAtomContainer().getAtom(atom);
            temp.add(atomType);
        }
        this.atomString = temp;
    }

    public void setIntConnectionTable() {
        IAtomContainer ac = this.getAtomContainer();
        for (int i = 0; i < this.bondNumber; ++i) {
            IBond bond = ac.getBond(i);
            this.intTable.add(ac.indexOf(bond.getAtom(0)) + 1);
            this.intTable.add(ac.indexOf(bond.getAtom(1)) + 1);
            if (this.bm) {
                this.intTable.add((int)bond.getOrder().numeric());
                continue;
            }
            this.intTable.add(1);
        }
    }

    public void setCharConnectionTable() {
        IAtomContainer ac = this.getAtomContainer();
        for (int i = 0; i < this.bondNumber; ++i) {
            IBond bond = ac.getBond(i);
            String atom1 = bond.getAtom(0).getSymbol();
            String atom2 = bond.getAtom(1).getSymbol();
            this.charTable.add(atom1);
            this.charTable.add(atom2);
        }
    }

    void enumerate_startHatom_num() {
        this.startHatom_num = this.atomNumber;
        for (int a = this.atomNumber - 1; a >= 0 && this.atomString.get(a).getSymbol().equals("H"); --a) {
            --this.startHatom_num;
        }
    }

    void discard_H_bonds(boolean is_no_H2) {
        int count_bonds = 0;
        if (is_no_H2) {
            for (int x = 0; x < this.bondNumber; ++x) {
                if (this.charTable.get(x * 2 + 0).equals("H") || this.charTable.get(x * 2 + 1).equals("H")) {
                    --this.atomNumber;
                }
                if (this.charTable.get(x * 2 + 0).equals("H") || this.charTable.get(x * 2 + 1).equals("H")) continue;
                this.char_tab.add(this.charTable.get(x * 2 + 0));
                this.char_tab.add(this.charTable.get(x * 2 + 1));
                this.int_tab.add(this.intTable.get(x * 3 + 0));
                this.int_tab.add(this.intTable.get(x * 3 + 1));
                this.int_tab.add(this.intTable.get(x * 3 + 2));
                ++count_bonds;
            }
        } else {
            for (int x = 0; x < this.bondNumber; ++x) {
                this.char_tab.add(this.charTable.get(x * 2 + 0));
                this.char_tab.add(this.charTable.get(x * 2 + 1));
                this.int_tab.add(this.intTable.get(x * 3 + 0));
                this.int_tab.add(this.intTable.get(x * 3 + 1));
                this.int_tab.add(this.intTable.get(x * 3 + 2));
                ++count_bonds;
            }
        }
        this.bondNumber = count_bonds;
    }

    void int_tab_specifier(int specifier_value) {
        for (int a = 0; a < this.bondNumber; ++a) {
            this.specified_int_tab.add(this.int_tab.get(a * 3 + 0) + specifier_value);
            this.specified_int_tab.add(this.int_tab.get(a * 3 + 1) + specifier_value);
            this.specified_int_tab.add(this.int_tab.get(a * 3 + 2));
        }
    }

    public IAtomContainer getAtomContainer() {
        return this.atomContainer;
    }
}

