/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.openscience.smsd.graph.Edge;

public final class BKKCKCF {
    private final Set<List<Integer>> max_Cliques_Set;
    private final List<Integer> T;
    private final List<Integer> C;
    private final List<Integer> S;
    private final Stack<Integer> P;
    private final Stack<Integer> D;
    private final Stack<Integer> V;
    private final List<Integer> C_edges;
    private final List<Integer> D_edges;
    private final List<Integer> comp_graph_nodes;
    private int best_clique_size;
    private List<Integer> C_copy;
    private Stack<Integer> P_copy;
    private Stack<Integer> D_copy;
    private List<Integer> S_copy;

    public BKKCKCF(List<Integer> compGraphNodes, List<Edge> cEdges, List<Edge> dEdges) {
        this.comp_graph_nodes = Collections.unmodifiableList(new ArrayList<Integer>(compGraphNodes));
        this.C_edges = new ArrayList<Integer>();
        cEdges.stream().map(e -> {
            this.C_edges.add(e.getSource());
            return e;
        }).forEachOrdered(e -> this.C_edges.add(e.getSink()));
        this.D_edges = new ArrayList<Integer>();
        dEdges.stream().map(e -> {
            this.D_edges.add(e.getSource());
            return e;
        }).forEachOrdered(e -> this.D_edges.add(e.getSink()));
        this.best_clique_size = 0;
        this.max_Cliques_Set = new HashSet<List<Integer>>();
        this.T = new ArrayList<Integer>();
        this.C = new ArrayList<Integer>();
        this.P = new Stack();
        this.D = new Stack();
        this.S = new ArrayList<Integer>();
        this.V = new Stack();
        this.process();
    }

    private void process() {
        int V_set_size = this.comp_graph_nodes.size() / 3;
        for (int a = 0; a < V_set_size; ++a) {
            this.V.add(this.comp_graph_nodes.get(a * 3 + 2));
        }
        this.V.add(0);
        int b = 0;
        this.T.clear();
        while ((Integer)this.V.get(b) != 0) {
            int central_node = (Integer)this.V.get(b);
            this.P.clear();
            this.D.clear();
            this.S.clear();
            this.C.clear();
            List<Integer> N = this.find_neighbors((Integer)this.V.get(b));
            for (int c = 0; c < N.size(); c += 2) {
                if (N.get(c + 1) == 1) {
                    if (this.T.contains(N.get(c))) {
                        this.S.add(N.get(c));
                    } else {
                        this.P.push(N.get(c));
                    }
                } else if (N.get(c + 1) == 2) {
                    this.D.add(N.get(c));
                }
                int neighbor_position = -1;
                int elementAtC = N.get(c);
                for (int d = 0; d < this.V.size(); ++d) {
                    if (elementAtC != (Integer)this.V.elementAt(d)) continue;
                    neighbor_position = d;
                }
                if (neighbor_position == -1) continue;
                for (int e = neighbor_position; e < this.V.size() - 1; ++e) {
                    this.V.set(e, (Integer)this.V.get(e + 1));
                }
                this.V.pop();
                if (neighbor_position >= b) continue;
                --b;
            }
            this.P.add(0);
            this.C.add(central_node);
            this.enumerate_Cliques(this.C, this.P, this.D, this.S);
            this.T.add((Integer)this.V.get(b));
            ++b;
        }
    }

    private int enumerate_Cliques(List<Integer> C2, Stack<Integer> P, Stack<Integer> D, List<Integer> S) {
        List<Object> N = new ArrayList();
        Stack<Integer> P_Prime = new Stack<Integer>();
        this.C_copy = new ArrayList<Integer>();
        this.P_copy = new Stack();
        this.D_copy = new Stack();
        this.S_copy = new ArrayList<Integer>();
        P.stream().forEach(I -> P_Prime.add((Integer)I));
        if (P.size() == 1 && S.isEmpty()) {
            int clique_size = C2.size();
            if (clique_size >= this.best_clique_size) {
                if (clique_size > this.best_clique_size) {
                    this.max_Cliques_Set.clear();
                    this.best_clique_size = clique_size;
                }
                if (clique_size == this.best_clique_size) {
                    this.max_Cliques_Set.add(C2);
                }
            }
            return 0;
        }
        int a = 0;
        while ((Integer)P_Prime.elementAt(a) != 0) {
            int counter;
            int ui = (Integer)P_Prime.get(a);
            int P_size = P.size();
            Integer ut_node_pos = 100000;
            for (counter = 0; counter < P_size - 1; ++counter) {
                if ((Integer)P.elementAt(counter) != ui) continue;
                ut_node_pos = counter;
            }
            if (ut_node_pos == 100000) {
                System.out.println("ut_node_pos = 100000");
            }
            for (counter = ut_node_pos.intValue(); counter < P_size - 1; ++counter) {
                P.set(counter, (Integer)P.get(counter + 1));
            }
            P.pop();
            this.C_copy.clear();
            this.P_copy.clear();
            this.D_copy.clear();
            this.S_copy.clear();
            N.clear();
            C2.stream().forEach(obj -> this.C_copy.add((Integer)obj));
            P.stream().forEach(obj -> this.P_copy.add((Integer)obj));
            D.stream().forEach(obj -> this.D_copy.add((Integer)obj));
            S.stream().forEach(obj -> this.S_copy.add((Integer)obj));
            this.P_copy.pop();
            N = this.find_neighbors((Integer)P_Prime.get(a));
            int N_size = N.size();
            for (int b = 0; b < N_size; b += 2) {
                int e;
                int D_set_size = D.size();
                int Nelement_at_b = (Integer)N.get(b);
                for (int c = 0; c < D_set_size; ++c) {
                    int e2;
                    if (Nelement_at_b != (Integer)D.elementAt(c) || (Integer)N.get(b + 1) != 1) continue;
                    if (this.T.contains(Nelement_at_b)) {
                        this.S_copy.add((Integer)N.get(b));
                    } else {
                        this.P_copy.push((Integer)N.get(b));
                    }
                    int D_copy_size = this.D_copy.size();
                    int Nb_position = 10000;
                    for (e2 = 0; e2 < D_copy_size; ++e2) {
                        if (Nelement_at_b != (Integer)this.D_copy.elementAt(e2)) continue;
                        Nb_position = e2;
                    }
                    for (e2 = Nb_position; e2 < D_copy_size - 1; ++e2) {
                        this.D_copy.set(e2, (Integer)this.D_copy.get(e2 + 1));
                    }
                    this.D_copy.pop();
                }
                int ut_set_size = P_Prime.size();
                int neighbor_position = -1;
                for (e = 0; e < ut_set_size; ++e) {
                    if (Nelement_at_b != (Integer)P_Prime.elementAt(e)) continue;
                    neighbor_position = e;
                }
                if (neighbor_position == -1) continue;
                for (e = neighbor_position; e < ut_set_size - 1; ++e) {
                    P_Prime.set(e, (Integer)P_Prime.get(e + 1));
                }
                P_Prime.pop();
                if (neighbor_position >= a) continue;
                --a;
            }
            Stack<Integer> P_copy_N_intersec = new Stack<Integer>();
            Stack<Integer> D_copy_N_intersec = new Stack<Integer>();
            ArrayList<Integer> S_copy_N_intersec = new ArrayList<Integer>();
            for (int sec = 0; sec < N_size; sec += 2) {
                int nElement = (Integer)N.get(sec);
                if (this.P_copy.contains(nElement)) {
                    P_copy_N_intersec.push(nElement);
                }
                if (this.D_copy.contains(nElement)) {
                    D_copy_N_intersec.add(nElement);
                }
                if (!this.S_copy.contains(nElement)) continue;
                S_copy_N_intersec.add(nElement);
            }
            P_copy_N_intersec.add(0);
            this.C_copy.add(ui);
            this.enumerate_Cliques(this.C_copy, P_copy_N_intersec, D_copy_N_intersec, S_copy_N_intersec);
            S.add(ui);
            ++a;
        }
        return 0;
    }

    private List<Integer> find_neighbors(int central_node) {
        ArrayList<Integer> neighbor_vec = new ArrayList<Integer>();
        int C_edge_number = this.C_edges.size() / 2;
        for (int a = 0; a < C_edge_number; ++a) {
            if (this.C_edges.get(a * 2 + 0) == central_node) {
                neighbor_vec.add(this.C_edges.get(a * 2 + 1));
                neighbor_vec.add(1);
            }
            if (this.C_edges.get(a * 2 + 1) != central_node) continue;
            neighbor_vec.add(this.C_edges.get(a * 2 + 0));
            neighbor_vec.add(1);
        }
        int D_edge_number = this.D_edges.size() / 2;
        for (int a = 0; a < D_edge_number; ++a) {
            if (this.D_edges.get(a * 2 + 0) == central_node) {
                neighbor_vec.add(this.D_edges.get(a * 2 + 1));
                neighbor_vec.add(2);
            }
            if (this.D_edges.get(a * 2 + 1) != central_node) continue;
            neighbor_vec.add(this.D_edges.get(a * 2 + 0));
            neighbor_vec.add(2);
        }
        return neighbor_vec;
    }

    public synchronized int getBestCliqueSize() {
        return this.best_clique_size;
    }

    public synchronized Collection<List<Integer>> getMaxCliqueSet() {
        return Collections.unmodifiableCollection(this.max_Cliques_Set);
    }
}

