/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus2;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RecursiveTask;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus2.Result;
import org.openscience.smsd.graph.Edge;
import org.openscience.smsd.helper.LabelContainer;

public class GenerateCompatibilityGraphFJ
extends RecursiveTask<List<Result>> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(GenerateCompatibilityGraphFJ.class);
    private static final boolean DEBUG = false;
    private static final int THRESHOLD = 20;
    private static final int COMPLEX_MAX_GRAPH_NODE_COUNT = 100;
    private final int startIndex;
    private final int endIndex;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    public GenerateCompatibilityGraphFJ(int startIndex, int endIndex, IAtomContainer source, IAtomContainer target, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        this.endIndex = endIndex;
        this.source = source;
        this.target = target;
        this.startIndex = startIndex;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
    }

    @Override
    protected List<Result> compute() {
        if (this.endIndex - this.startIndex < 20) {
            ArrayList<Result> arrayList = new ArrayList<Result>();
            arrayList.add(this.processing(this.startIndex, this.endIndex));
            return new ArrayList<Result>(new HashSet(arrayList));
        }
        ArrayList<GenerateCompatibilityGraphFJ> subtasks = new ArrayList<GenerateCompatibilityGraphFJ>();
        subtasks.addAll(this.createSubtasks());
        subtasks.forEach(subtask -> subtask.fork());
        ArrayList result = new ArrayList();
        subtasks.forEach(subtask -> result.addAll((Collection)subtask.join()));
        return new ArrayList<Result>(new HashSet(result));
    }

    private List<GenerateCompatibilityGraphFJ> createSubtasks() {
        ArrayList<GenerateCompatibilityGraphFJ> dividedTasks = new ArrayList<GenerateCompatibilityGraphFJ>();
        int middle = (this.endIndex + this.startIndex) / 2;
        GenerateCompatibilityGraphFJ partOne = new GenerateCompatibilityGraphFJ(this.startIndex, middle, this.source, this.target, this.atomMatcher, this.bondMatcher);
        GenerateCompatibilityGraphFJ partTwo = new GenerateCompatibilityGraphFJ(middle, this.endIndex, this.source, this.target, this.atomMatcher, this.bondMatcher);
        dividedTasks.add(partOne);
        dividedTasks.add(partTwo);
        return dividedTasks;
    }

    private Result processing(int startIndex, int endIndex) {
        Result result;
        if (this.source.getAtomCount() > 100 || this.target.getAtomCount() > 100) {
            result = new Result();
            ArrayList<Integer> compGraphNodesCZero = new ArrayList<Integer>();
            this.compatibilityGraphNodesIfCEdgeIsZero(startIndex, endIndex, result, compGraphNodesCZero);
            this.compatibilityGraphCEdgeZero(result, compGraphNodesCZero);
            compGraphNodesCZero.clear();
        } else {
            result = new Result();
            this.compatibilityGraphNodes(startIndex, endIndex, result);
            this.compatibilityGraph(result);
            if (result.cEdges.isEmpty()) {
                result = new Result();
                ArrayList<Integer> compGraphNodesCZero = new ArrayList<Integer>();
                this.compatibilityGraphNodesIfCEdgeIsZero(startIndex, endIndex, result, compGraphNodesCZero);
                this.compatibilityGraphCEdgeZero(result, compGraphNodesCZero);
                compGraphNodesCZero.clear();
            }
        }
        return result;
    }

    private Integer compatibilityGraphNodesIfCEdgeIsZero(int startIndex, int endIndex, Result result, List<Integer> compGraphNodesCZero) {
        int count_nodes = 1;
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        LabelContainer labelContainer = LabelContainer.getInstance();
        for (int i = startIndex; i < endIndex; ++i) {
            for (int j = 0; j < this.target.getAtomCount(); ++j) {
                IAtom atom1 = this.source.getAtom(i);
                IAtom atom2 = this.target.getAtom(j);
                if (atom1 instanceof IQueryAtom && ((IQueryAtom)atom1).matches(atom2) && !list.contains(i + "_" + j)) {
                    compGraphNodesCZero.add(i);
                    compGraphNodesCZero.add(j);
                    compGraphNodesCZero.add(labelContainer.getLabelID(atom2.getSymbol()));
                    compGraphNodesCZero.add(count_nodes);
                    result.compGraphNodes.add(i);
                    result.compGraphNodes.add(j);
                    result.compGraphNodes.add(count_nodes);
                    ++count_nodes;
                    list.add((CallSite)((Object)(i + "_" + j)));
                    continue;
                }
                if (!atom1.getSymbol().equalsIgnoreCase(atom2.getSymbol()) || list.contains(i + "_" + j)) continue;
                compGraphNodesCZero.add(i);
                compGraphNodesCZero.add(j);
                compGraphNodesCZero.add(labelContainer.getLabelID(atom1.getSymbol()));
                compGraphNodesCZero.add(count_nodes);
                result.compGraphNodes.add(i);
                result.compGraphNodes.add(j);
                result.compGraphNodes.add(count_nodes);
                ++count_nodes;
                list.add((CallSite)((Object)(i + "_" + j)));
            }
        }
        list.clear();
        return count_nodes;
    }

    private int compatibilityGraphCEdgeZero(Result result, List<Integer> compGraphNodesCZero) {
        int compGraphNodesCZeroListSize = compGraphNodesCZero.size();
        for (int a = 0; a < compGraphNodesCZeroListSize; a += 4) {
            int index_a = compGraphNodesCZero.get(a);
            int index_aPlus1 = compGraphNodesCZero.get(a + 1);
            for (int b = a + 4; b < compGraphNodesCZeroListSize; b += 4) {
                Edge edge;
                int index_b = compGraphNodesCZero.get(b);
                int index_bPlus1 = compGraphNodesCZero.get(b + 1);
                if (a == b || index_a == index_b || index_aPlus1 == index_bPlus1) continue;
                IBond reactantBond = this.source.getBond(this.source.getAtom(index_a), this.source.getAtom(index_b));
                IBond productBond = this.target.getBond(this.target.getAtom(index_aPlus1), this.target.getAtom(index_bPlus1));
                if (reactantBond != null && productBond != null) {
                    this.addZeroEdges(result.cEdges, result.dEdges, reactantBond, productBond, a, b);
                    continue;
                }
                if (reactantBond != null || productBond != null || result.dEdges.contains(edge = new Edge(a / 4 + 1, b / 4 + 1))) continue;
                result.dEdges.add(edge);
            }
        }
        return 0;
    }

    private void addZeroEdges(List<Edge> cEdges, List<Edge> dEdges, IBond reactantBond, IBond productBond, int indexI, int indexJ) {
        if (AtomBondMatcher.matchAtomAndBond(reactantBond, productBond, this.atomMatcher, this.bondMatcher, true)) {
            Edge edge = new Edge(indexI / 4 + 1, indexJ / 4 + 1);
            if (!cEdges.contains(edge)) {
                cEdges.add(edge);
            }
        } else {
            Edge edge = new Edge(indexI / 4 + 1, indexJ / 4 + 1);
            if (!dEdges.contains(edge)) {
                dEdges.add(edge);
            }
        }
    }

    private Map<IAtom, List<String>> labelAtomsBySymbol(int startIndex, int endIndex, IAtomContainer atomCont) {
        HashMap<IAtom, List<String>> label_list = new HashMap<IAtom, List<String>>();
        for (int i = startIndex; i < endIndex; ++i) {
            ArrayList<String> label = new ArrayList<String>(7);
            for (int a = 0; a < 7; ++a) {
                label.add(a, "Z9");
            }
            IAtom refAtom = atomCont.getAtom(i);
            if (refAtom == null) {
                return label_list;
            }
            String referenceAtom = refAtom instanceof IQueryAtom ? (((IQueryAtom)refAtom).getSymbol() == null ? "*" : ((IQueryAtom)refAtom).getSymbol()) : refAtom.getSymbol();
            label.set(0, referenceAtom);
            List<IAtom> connAtoms = atomCont.getConnectedAtomsList(refAtom);
            int counter = 1;
            for (IAtom negAtom : connAtoms) {
                String neighbouringAtom = refAtom instanceof IQueryAtom ? (((IQueryAtom)negAtom).getSymbol() == null ? "*" : ((IQueryAtom)negAtom).getSymbol()) : negAtom.getSymbol();
                label.set(counter, neighbouringAtom);
                ++counter;
            }
            this.bubbleSort(label);
            label_list.put(refAtom, label);
        }
        return label_list;
    }

    private void bubbleSort(List<String> num) {
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int j = 0; j < num.size() - 1; ++j) {
                if (num.get(j).compareTo(num.get(j + 1)) <= 0) continue;
                String temp = num.get(j);
                num.set(j, num.get(j + 1));
                num.set(j + 1, temp);
                flag = true;
            }
        }
    }

    private int compatibilityGraphNodes(int startIndex, int endIndex, Result result) {
        HashSet<Edge> edges = new HashSet<Edge>();
        int nodeCount = 1;
        Map<IAtom, List<String>> labelAtomsBySymbolA = this.labelAtomsBySymbol(startIndex, endIndex, this.source);
        Map<IAtom, List<String>> labelAtomsBySymbolB = this.labelAtomsBySymbol(0, this.target.getAtomCount(), this.target);
        for (Map.Entry<IAtom, List<String>> labelA : labelAtomsBySymbolA.entrySet()) {
            for (Map.Entry<IAtom, List<String>> labelB : labelAtomsBySymbolB.entrySet()) {
                IAtom atom = labelA.getKey();
                if ((!(atom instanceof IQueryAtom) || !((IQueryAtom)atom).matches(labelB.getKey())) && (atom instanceof IQueryAtom || !atom.getSymbol().equals(labelB.getKey().getSymbol()))) continue;
                int atomNumberI = this.source.indexOf(labelA.getKey());
                int atomNumberJ = this.target.indexOf(labelB.getKey());
                Edge e = new Edge(atomNumberI, atomNumberJ);
                if (edges.contains(e)) continue;
                edges.add(e);
                result.compGraphNodes.add(atomNumberI);
                result.compGraphNodes.add(atomNumberJ);
                result.compGraphNodes.add(nodeCount);
                ++nodeCount;
            }
        }
        return 0;
    }

    private int compatibilityGraph(Result result) {
        int comp_graph_nodes_List_size = result.compGraphNodes.size();
        for (int a = 0; a < comp_graph_nodes_List_size; a += 3) {
            for (int b = a; b < comp_graph_nodes_List_size; b += 3) {
                Edge edge;
                if (a == b || Objects.equals(result.compGraphNodes.get(a), result.compGraphNodes.get(b)) || Objects.equals(result.compGraphNodes.get(a + 1), result.compGraphNodes.get(b + 1))) continue;
                IBond reactantBond = this.source.getBond(this.source.getAtom(result.compGraphNodes.get(a)), this.source.getAtom(result.compGraphNodes.get(b)));
                IBond productBond = this.target.getBond(this.target.getAtom(result.compGraphNodes.get(a + 1)), this.target.getAtom(result.compGraphNodes.get(b + 1)));
                boolean connectedFlag = false;
                boolean disConnectedFlag = false;
                boolean matchBondFlag = false;
                if (reactantBond != null && productBond != null) {
                    connectedFlag = true;
                }
                if (reactantBond == null && productBond == null) {
                    disConnectedFlag = true;
                }
                if (connectedFlag && AtomBondMatcher.matchAtomAndBond(reactantBond, productBond, this.atomMatcher, this.bondMatcher, true)) {
                    matchBondFlag = true;
                }
                if (connectedFlag && matchBondFlag) {
                    edge = new Edge(a / 3 + 1, b / 3 + 1);
                    result.cEdges.add(edge);
                }
                if (!disConnectedFlag) continue;
                edge = new Edge(a / 3 + 1, b / 3 + 1);
                result.dEdges.add(edge);
            }
        }
        return 0;
    }
}

