/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.algorithm.mcsplus.MappingHandler;
import org.openscience.smsd.algorithm.mcsplus2.BKKCKCF;
import org.openscience.smsd.algorithm.mcsplus2.GenerateCompatibilityGraph;
import org.openscience.smsd.graph.Edge;
import org.openscience.smsd.tools.IterationManager;

public final class MCSPlus {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSPlus.class);
    private static final boolean DEBUG = false;
    private final IAtomContainer ac1;
    private final IAtomContainer ac2;
    private final List<List<Integer>> finalMapping;
    private boolean timeout = false;
    private IterationManager iterationManager = null;
    private final AtomMatcher am;
    private final BondMatcher bm;

    public synchronized boolean isTimeout() {
        return this.timeout;
    }

    private IterationManager getIterationManager() {
        return this.iterationManager;
    }

    private void setIterationManager(IterationManager iterationManager) {
        this.iterationManager = iterationManager;
    }

    public MCSPlus(IAtomContainer ac1, IAtomContainer ac2, AtomMatcher am, BondMatcher bm) {
        this.ac1 = ac1;
        this.ac2 = ac2;
        this.am = am;
        this.bm = bm;
        this.finalMapping = new ArrayList<List<Integer>>();
    }

    public MCSPlus(IQueryAtomContainer ac1, IAtomContainer ac2) {
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
        this.ac1 = ac1;
        this.ac2 = ac2;
        this.finalMapping = new ArrayList<List<Integer>>();
    }

    public int search_cliques() {
        List<List<Integer>> extendMappings = null;
        this.setIterationManager(new IterationManager(this.ac1.getAtomCount() + this.ac2.getAtomCount()));
        try {
            GenerateCompatibilityGraph gcg = new GenerateCompatibilityGraph(this.ac1, this.ac2, this.am, this.bm);
            List<Integer> comp_graph_nodes = gcg.getCompGraphNodes();
            List<Edge> cEdges = gcg.getCEdges();
            List<Edge> dEdges = gcg.getDEdges();
            BKKCKCF init = new BKKCKCF(comp_graph_nodes, cEdges, dEdges);
            Stack<List<Integer>> maxCliqueSet = new Stack<List<Integer>>();
            maxCliqueSet.addAll(init.getMaxCliqueSet());
            ArrayList<Map<Integer, Integer>> mappings = new ArrayList<Map<Integer, Integer>>();
            while (!maxCliqueSet.empty()) {
                Map<Integer, Integer> indexindexMapping = MappingHandler.getMapping(comp_graph_nodes, (Collection)maxCliqueSet.peek());
                if (indexindexMapping != null) {
                    mappings.add(indexindexMapping);
                }
                maxCliqueSet.pop();
            }
            gcg.clear();
            extendMappings = this.ac1 instanceof IQueryAtomContainer ? this.searchMcGregorMapping((IQueryAtomContainer)this.ac1, this.ac2, mappings) : this.searchMcGregorMapping(this.ac1, this.ac2, mappings);
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        this.finalMapping.addAll(extendMappings);
        return this.finalMapping.size();
    }

    private List<List<Integer>> searchMcGregorMapping(IAtomContainer ac1, IAtomContainer ac2, List<Map<Integer, Integer>> allMCSCopy) throws IOException {
        List<List<Integer>> cliques = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : allMCSCopy) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (ac1.getAtomCount() > ac2.getAtomCount()) {
                mgit = new McGregor(ac1, ac2, cliques, this.am, this.bm);
                mgit.startMcGregorIteration(ac1, mgit.getMCSSize(), extendMapping);
            } else {
                extendMapping.clear();
                ROPFlag = false;
                firstPassMappings.entrySet().stream().forEach(map -> extendMapping.put((Integer)map.getValue(), (Integer)map.getKey()));
                mgit = new McGregor(ac2, ac1, cliques, this.am, this.bm);
                mgit.startMcGregorIteration(ac2, mgit.getMCSSize(), extendMapping);
            }
            cliques = mgit.getMappings();
            if (!this.checkTimeout()) continue;
            break;
        }
        List<List<Integer>> finalMappings = this.setMcGregorMappings(ROPFlag, cliques);
        return finalMappings;
    }

    private List<List<Integer>> searchMcGregorMapping(IQueryAtomContainer ac1, IAtomContainer ac2, List<Map<Integer, Integer>> allMCSCopy) throws IOException {
        List<List<Integer>> cliques = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : allMCSCopy) {
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            McGregor mgit = new McGregor(ac1, ac2, cliques, this.am, this.bm);
            mgit.startMcGregorIteration(ac1, mgit.getMCSSize(), extendMapping);
            cliques = mgit.getMappings();
            if (!this.checkTimeout()) continue;
            break;
        }
        List<List<Integer>> finalMappings = this.setMcGregorMappings(ROPFlag, cliques);
        return finalMappings;
    }

    private List<List<Integer>> setMcGregorMappings(boolean RONP, List<List<Integer>> mappings) {
        int counter = 0;
        int mcsSize = 0;
        ArrayList<List<Integer>> finalMappings = new ArrayList<List<Integer>>();
        for (List<Integer> mapping : mappings) {
            ArrayList<Integer> indexindexMapping = new ArrayList<Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                Integer tIndex;
                Integer qIndex;
                if (RONP) {
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == null || tIndex == null) continue;
                indexindexMapping.add(qIndex);
                indexindexMapping.add(tIndex);
            }
            if (!indexindexMapping.isEmpty() && indexindexMapping.size() > mcsSize) {
                mcsSize = indexindexMapping.size();
                finalMappings.clear();
                counter = 0;
            }
            if (indexindexMapping.isEmpty() || finalMappings.contains(indexindexMapping) || indexindexMapping.size() != mcsSize) continue;
            finalMappings.add(counter, indexindexMapping);
            ++counter;
        }
        return finalMappings;
    }

    private boolean checkTimeout() {
        if (this.getIterationManager().isMaxIteration()) {
            this.timeout = true;
            return true;
        }
        this.getIterationManager().increment();
        return false;
    }

    public List<List<Integer>> getFinalMappings() {
        return Collections.unmodifiableList(this.finalMapping);
    }
}

