/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus2.MCSPlus;
import org.openscience.smsd.filters.PostFilter;
import org.openscience.smsd.interfaces.IResults;

public final class MCSPlusMapper
implements IResults {
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<Map<Integer, Integer>> allMCS;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean flagExchange = false;
    private final boolean timeout;
    private AtomMatcher am;
    private BondMatcher bm;

    public MCSPlusMapper(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        this.source = source;
        this.target = target;
        this.am = am;
        this.bm = bm;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    public MCSPlusMapper(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    private synchronized boolean searchMCS() {
        List<List<Integer>> mappings;
        if (this.source instanceof IQueryAtomContainer) {
            MCSPlus mcsplus = new MCSPlus((IQueryAtomContainer)this.source, this.target);
            mcsplus.search_cliques();
            mappings = Collections.synchronizedList(mcsplus.getFinalMappings());
        } else if (!(this.source instanceof IQueryAtomContainer) && this.source.getAtomCount() < this.target.getAtomCount()) {
            MCSPlus mcsplus = new MCSPlus(this.source, this.target, this.am, this.bm);
            mcsplus.search_cliques();
            mappings = Collections.synchronizedList(mcsplus.getFinalMappings());
        } else {
            this.flagExchange = true;
            MCSPlus mcsplus = new MCSPlus(this.target, this.source, this.am, this.bm);
            mcsplus.search_cliques();
            mappings = Collections.synchronizedList(mcsplus.getFinalMappings());
        }
        if (this.flagExchange) {
            mappings = this.reverseMappings(mappings);
        }
        List<Map<Integer, Integer>> solutions = PostFilter.filter(mappings);
        this.setAllMapping(solutions);
        this.setAllAtomMapping();
        return mappings.isEmpty();
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int counter = 0;
            int bestSolSize = 0;
            for (Map<Integer, Integer> solution : solutions) {
                SortedMap validSolution = Collections.synchronizedSortedMap(new TreeMap());
                solution.entrySet().stream().forEach(map -> validSolution.put((Integer)map.getKey(), (Integer)map.getValue()));
                if (validSolution.size() > bestSolSize) {
                    bestSolSize = validSolution.size();
                    counter = 0;
                    this.allMCS.clear();
                }
                if (validSolution.size() != bestSolSize) continue;
                this.allMCS.add(counter++, validSolution);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setAllAtomMapping() {
        try {
            int counter = 0;
            for (Map<Integer, Integer> solution : this.allMCS) {
                AtomAtomMapping atomMappings = new AtomAtomMapping(this.source, this.target);
                solution.entrySet().forEach(map -> {
                    int IIndex = (Integer)map.getKey();
                    int JIndex = (Integer)map.getValue();
                    IAtom sourceAtom = this.source.getAtom(IIndex);
                    IAtom targetAtom = this.target.getAtom(JIndex);
                    atomMappings.put(sourceAtom, targetAtom);
                });
                this.allAtomMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public synchronized boolean isTimeout() {
        return this.timeout;
    }

    private List<List<Integer>> reverseMappings(List<List<Integer>> mappings) {
        ArrayList<List<Integer>> reverse = new ArrayList<List<Integer>>();
        mappings.stream().map(mapping -> {
            Collections.reverse(mapping);
            return mapping;
        }).forEach(mapping -> reverse.add((List<Integer>)mapping));
        return reverse;
    }
}

