/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.rgraph.CDKRGraph;
import org.openscience.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.smsd.algorithm.rgraph.CDKRNode;
import org.openscience.smsd.tools.IterationManager;

public final class CDKMCS {
    protected static boolean timeout = false;
    protected static final int ID1 = 0;
    protected static final int ID2 = 1;
    private static IterationManager iterationManager = null;

    public static boolean isIsomorph(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() != g1.getAtomCount()) {
            return false;
        }
        if (g2.getAtomCount() == 1) {
            IAtom atom = g1.getAtom(0);
            IAtom atom2 = g2.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                return qAtom.matches(g2.getAtom(0));
            }
            if (atom2 instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom2;
                return qAtom.matches(g1.getAtom(0));
            }
            String atomSymbol = atom2.getSymbol();
            return g1.getAtom(0).getSymbol().equals(atomSymbol);
        }
        return CDKMCS.getIsomorphMap(g1, g2, am, bm) != null;
    }

    private static List<CDKRMap> getIsomorphMap(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<CDKRMap> result = null;
        List<List<CDKRMap>> rMapsList = CDKMCS.search(g1, g2, CDKMCS.getBitSet(g1), CDKMCS.getBitSet(g2), false, false, am, bm);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    private static List<CDKRMap> getIsomorphAtomsMap(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return CDKMCS.makeAtomsMapOfBondsMap(CDKMCS.getIsomorphMap(g1, g2, am, bm), g1, g2);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static List<List<CDKRMap>> getIsomorphMaps(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        return CDKMCS.search(g1, g2, CDKMCS.getBitSet(g1), CDKMCS.getBitSet(g2), true, true, am, bm);
    }

    static List<List<CDKRMap>> getSubgraphMaps(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        return CDKMCS.search(g1, g2, new BitSet(), CDKMCS.getBitSet(g2), true, true, am, bm);
    }

    static List<CDKRMap> getSubgraphMap(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        List<CDKRMap> result = null;
        List<List<CDKRMap>> rMapsList = CDKMCS.search(g1, g2, new BitSet(), CDKMCS.getBitSet(g2), false, false, am, bm);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    static List<List<CDKRMap>> getSubgraphAtomsMaps(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return CDKMCS.makeAtomsMapsOfBondsMaps(CDKMCS.getSubgraphMaps(g1, g2, am, bm), g1, g2);
        }
        ArrayList<List<CDKRMap>> atomsMap = new ArrayList<List<CDKRMap>>();
        atomsMap.add(list);
        return atomsMap;
    }

    private static List<CDKRMap> getSubgraphAtomsMap(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return CDKMCS.makeAtomsMapOfBondsMap(CDKMCS.getSubgraphMap(g1, g2, am, bm), g1, g2);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static boolean isSubgraph(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() > g1.getAtomCount()) {
            return false;
        }
        if (g2.getAtomCount() == 1) {
            IAtom atom = g2.getAtom(0);
            for (int i = 0; i < g1.getAtomCount(); ++i) {
                IQueryAtom qAtom;
                IAtom atom2 = g1.getAtom(i);
                if (atom instanceof IQueryAtom) {
                    qAtom = (IQueryAtom)atom;
                    if (!qAtom.matches(atom2)) continue;
                    return true;
                }
                if (atom2 instanceof IQueryAtom) {
                    qAtom = (IQueryAtom)atom2;
                    if (!qAtom.matches(atom)) continue;
                    return true;
                }
                return atom2.getSymbol().equals(atom.getSymbol());
            }
            return false;
        }
        if (!CDKMCS.testSubgraphHeuristics(g1, g2)) {
            return false;
        }
        return CDKMCS.getSubgraphMap(g1, g2, am, bm) != null;
    }

    public static List<IAtomContainer> getOverlaps(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        List<List<CDKRMap>> rMapsList = CDKMCS.search(g1, g2, new BitSet(), new BitSet(), true, false, am, bm);
        List<IAtomContainer> graphList = CDKMCS.projectList(rMapsList, g1, 0);
        return CDKMCS.getMaximum(graphList, am, bm);
    }

    public static BitSet getBitSet(IAtomContainer ac) {
        BitSet bs;
        int n = ac.getBondCount();
        if (n != 0) {
            bs = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bs.set(i);
            }
        } else {
            bs = new BitSet();
        }
        return bs;
    }

    public static CDKRGraph buildRGraph(IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) throws CDKException {
        CDKRGraph rGraph = new CDKRGraph();
        CDKMCS.nodeConstructor(rGraph, g1, g2, am, bm);
        CDKMCS.arcConstructor(rGraph, g1, g2);
        return rGraph;
    }

    static List<List<CDKRMap>> search(IAtomContainer g1, IAtomContainer g2, BitSet c1, BitSet c2, boolean findAllStructure, boolean findAllMap, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (g2.getAtomCount() == 1) {
            ArrayList<List<CDKRMap>> matches = new ArrayList<List<CDKRMap>>();
            IAtom queryAtom = g2.getAtom(0);
            for (IAtom atom : g1.atoms()) {
                if (!AtomBondMatcher.matches(queryAtom, atom, am)) continue;
                ArrayList<CDKRMap> lmap = new ArrayList<CDKRMap>();
                lmap.add(new CDKRMap(g1.indexOf(atom), 0));
                matches.add(lmap);
            }
            return matches;
        }
        ArrayList<List<CDKRMap>> rMapsList = new ArrayList<List<CDKRMap>>();
        CDKRGraph rGraph = CDKMCS.buildRGraph(g1, g2, am, bm);
        CDKMCS.setIterationManager(new IterationManager(g1.getAtomCount() + g2.getAtomCount()));
        rGraph.parse(c1, c2, findAllStructure, findAllMap);
        List<BitSet> solutionList = rGraph.getSolutions();
        solutionList.stream().forEach(set -> rMapsList.add(rGraph.bitSetToRMap((BitSet)set)));
        return rMapsList;
    }

    private static IAtomContainer project(List<CDKRMap> rMapList, IAtomContainer g, int id) {
        IAtomContainer ac = g.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IAtom, IAtom> table = new HashMap<IAtom, IAtom>();
        for (CDKRMap rMap : rMapList) {
            IAtom a2;
            IBond bond = id == 0 ? g.getBond(rMap.getId1()) : g.getBond(rMap.getId2());
            IAtom a = bond.getAtom(0);
            IAtom a1 = (IAtom)table.get(a);
            if (a1 == null) {
                try {
                    a1 = a.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                ac.addAtom(a1);
                table.put(a, a1);
            }
            if ((a2 = (IAtom)table.get(a = bond.getAtom(1))) == null) {
                try {
                    a2 = a.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                ac.addAtom(a2);
                table.put(a, a2);
            }
            IBond newBond = g.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, bond.getOrder()});
            newBond.setFlag(32, bond.getFlag(32));
            ac.addBond(newBond);
        }
        return ac;
    }

    private static List<IAtomContainer> projectList(List<List<CDKRMap>> rMapsList, IAtomContainer g, int id) {
        ArrayList<IAtomContainer> graphList = new ArrayList<IAtomContainer>();
        rMapsList.stream().map(rMapList -> CDKMCS.project(rMapList, g, id)).forEach(ac -> graphList.add((IAtomContainer)ac));
        return graphList;
    }

    private static List<IAtomContainer> getMaximum(List<IAtomContainer> graphList, AtomMatcher am, BondMatcher bm) throws CDKException {
        ArrayList<IAtomContainer> reducedGraphList = new ArrayList<IAtomContainer>();
        reducedGraphList.addAll(graphList);
        for (int i = 0; i < graphList.size(); ++i) {
            IAtomContainer gi = graphList.get(i);
            for (int j = i + 1; j < graphList.size(); ++j) {
                IAtomContainer gj = graphList.get(j);
                if (CDKMCS.isSubgraph(gj, gi, am, bm)) {
                    reducedGraphList.remove(gi);
                    continue;
                }
                if (!CDKMCS.isSubgraph(gi, gj, am, bm)) continue;
                reducedGraphList.remove(gj);
            }
        }
        return reducedGraphList;
    }

    static List<CDKRMap> checkSingleAtomCases(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() == 1) {
            ArrayList<CDKRMap> arrayList = new ArrayList<CDKRMap>();
            IAtom atom = g2.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                for (int i = 0; i < g1.getAtomCount(); ++i) {
                    if (!qAtom.matches(g1.getAtom(i))) continue;
                    arrayList.add(new CDKRMap(i, 0));
                }
            } else {
                String atomSymbol = atom.getSymbol();
                for (int i = 0; i < g1.getAtomCount(); ++i) {
                    if (!g1.getAtom(i).getSymbol().equals(atomSymbol)) continue;
                    arrayList.add(new CDKRMap(i, 0));
                }
            }
            return arrayList;
        }
        if (g1.getAtomCount() == 1) {
            ArrayList<CDKRMap> arrayList = new ArrayList<CDKRMap>();
            IAtom atom = g1.getAtom(0);
            for (int i = 0; i < g2.getAtomCount(); ++i) {
                IAtom atom2 = g2.getAtom(i);
                if (atom2 instanceof IQueryAtom) {
                    IQueryAtom qAtom = (IQueryAtom)atom2;
                    if (!qAtom.matches(atom)) continue;
                    arrayList.add(new CDKRMap(0, i));
                    continue;
                }
                if (!atom2.getSymbol().equals(atom.getSymbol())) continue;
                arrayList.add(new CDKRMap(0, i));
            }
            return arrayList;
        }
        return null;
    }

    static List<List<CDKRMap>> makeAtomsMapsOfBondsMaps(List<List<CDKRMap>> l, IAtomContainer g1, IAtomContainer g2) {
        if (l == null) {
            return l;
        }
        if (g2.getAtomCount() == 1) {
            return l;
        }
        ArrayList<List<CDKRMap>> result = new ArrayList<List<CDKRMap>>();
        l.stream().forEach(l2 -> result.add(CDKMCS.makeAtomsMapOfBondsMap(l2, g1, g2)));
        return result;
    }

    private static List<CDKRMap> makeAtomsMapOfBondsMap(List<CDKRMap> l, IAtomContainer g1, IAtomContainer g2) {
        if (l == null) {
            return l;
        }
        ArrayList<CDKRMap> result = new ArrayList<CDKRMap>();
        for (int i = 0; i < l.size(); ++i) {
            IBond bond1 = g1.getBond(l.get(i).getId1());
            IBond bond2 = g2.getBond(l.get(i).getId2());
            IAtom[] atom1 = BondManipulator.getAtomArray(bond1);
            IAtom[] atom2 = BondManipulator.getAtomArray(bond2);
            for (int j = 0; j < 2; ++j) {
                List<IBond> bondsConnectedToAtom1j = g1.getConnectedBondsList(atom1[j]);
                for (int k = 0; k < bondsConnectedToAtom1j.size(); ++k) {
                    if (bondsConnectedToAtom1j.get(k) == bond1) continue;
                    IBond testBond = bondsConnectedToAtom1j.get(k);
                    for (int m = 0; m < l.size(); ++m) {
                        if (l.get(m).getId1() != g1.indexOf(testBond)) continue;
                        IBond testBond2 = g2.getBond(l.get(m).getId2());
                        for (int n = 0; n < 2; ++n) {
                            CDKRMap map2;
                            List<IBond> bondsToTest = g2.getConnectedBondsList(atom2[n]);
                            if (!bondsToTest.contains(testBond2)) continue;
                            CDKRMap map = j == n ? new CDKRMap(g1.indexOf(atom1[0]), g2.indexOf(atom2[0])) : new CDKRMap(g1.indexOf(atom1[1]), g2.indexOf(atom2[0]));
                            if (!result.contains(map)) {
                                result.add(map);
                            }
                            if (result.contains(map2 = j == n ? new CDKRMap(g1.indexOf(atom1[1]), g2.indexOf(atom2[1])) : new CDKRMap(g1.indexOf(atom1[0]), g2.indexOf(atom2[1])))) continue;
                            result.add(map2);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static void nodeConstructor(CDKRGraph gr, IAtomContainer ac1, IAtomContainer ac2, AtomMatcher am, BondMatcher bm) throws CDKException {
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        gr.clear();
        if (ac1 == null) {
            return;
        }
        for (int i = 0; i < ac1.getBondCount(); ++i) {
            for (int j = 0; j < ac2.getBondCount(); ++j) {
                if (!AtomBondMatcher.matchAtomAndBond(ac1.getBond(i), ac2.getBond(j), am, bm, true)) continue;
                gr.addNode(new CDKRNode(i, j));
            }
        }
    }

    private static void arcConstructor(CDKRGraph gr, IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        for (int i = 0; i < gr.getGraph().size(); ++i) {
            CDKRNode x = gr.getGraph().get(i);
            x.getForbidden().set(i);
        }
        gr.setFirstGraphSize(ac1.getBondCount());
        gr.setSecondGraphSize(ac2.getBondCount());
        for (int i = 0; i < gr.getGraph().size(); ++i) {
            CDKRNode x = gr.getGraph().get(i);
            for (int j = i + 1; j < gr.getGraph().size(); ++j) {
                CDKRNode y = gr.getGraph().get(j);
                IBond a1 = ac1.getBond(gr.getGraph().get(i).getRMap().getId1());
                IBond a2 = ac2.getBond(gr.getGraph().get(i).getRMap().getId2());
                IBond b1 = ac1.getBond(gr.getGraph().get(j).getRMap().getId1());
                IBond b2 = ac2.getBond(gr.getGraph().get(j).getRMap().getId2());
                if (a2 instanceof IQueryBond) {
                    if (a1.equals(b1) || a2.equals(b2) || !CDKMCS.queryAdjacencyAndOrder(a1, b1, a2, b2)) {
                        x.getForbidden().set(j);
                        y.getForbidden().set(i);
                        continue;
                    }
                    if (!CDKMCS.hasCommonAtom(a1, b1)) continue;
                    x.getExtension().set(j);
                    y.getExtension().set(i);
                    continue;
                }
                if (a1.equals(b1) || a2.equals(b2) || !CDKMCS.getCommonSymbol(a1, b1).equals(CDKMCS.getCommonSymbol(a2, b2))) {
                    x.getForbidden().set(j);
                    y.getForbidden().set(i);
                    continue;
                }
                if (!CDKMCS.hasCommonAtom(a1, b1)) continue;
                x.getExtension().set(j);
                y.getExtension().set(i);
            }
        }
    }

    private static boolean hasCommonAtom(IBond a, IBond b) {
        return a.contains(b.getAtom(0)) || a.contains(b.getAtom(1));
    }

    private static String getCommonSymbol(IBond a, IBond b) {
        String symbol = "";
        if (a.contains(b.getAtom(0))) {
            symbol = b.getAtom(0).getSymbol();
        } else if (a.contains(b.getAtom(1))) {
            symbol = b.getAtom(1).getSymbol();
        }
        return symbol;
    }

    private static boolean queryAdjacency(IBond a1, IBond b1, IBond a2, IBond b2) {
        IAtom atom1 = null;
        IAtom atom2 = null;
        if (a1.contains(b1.getAtom(0))) {
            atom1 = b1.getAtom(0);
        } else if (a1.contains(b1.getAtom(1))) {
            atom1 = b1.getAtom(1);
        }
        if (a2.contains(b2.getAtom(0))) {
            atom2 = b2.getAtom(0);
        } else if (a2.contains(b2.getAtom(1))) {
            atom2 = b2.getAtom(1);
        }
        if (atom1 != null && atom2 != null) {
            return ((IQueryAtom)atom2).matches(atom1);
        }
        return atom1 == null && atom2 == null;
    }

    private static boolean queryAdjacencyAndOrder(IBond bond1, IBond bond2, IBond queryBond1, IBond queryBond2) {
        IAtom centralAtom = null;
        IAtom centralQueryAtom = null;
        if (bond1.contains(bond2.getAtom(0))) {
            centralAtom = bond2.getAtom(0);
        } else if (bond1.contains(bond2.getAtom(1))) {
            centralAtom = bond2.getAtom(1);
        }
        if (queryBond1.contains(queryBond2.getAtom(0))) {
            centralQueryAtom = queryBond2.getAtom(0);
        } else if (queryBond1.contains(queryBond2.getAtom(1))) {
            centralQueryAtom = queryBond2.getAtom(1);
        }
        if (centralAtom != null && centralQueryAtom != null && ((IQueryAtom)centralQueryAtom).matches(centralAtom)) {
            IQueryAtom queryAtom1 = (IQueryAtom)queryBond1.getOther(centralQueryAtom);
            IQueryAtom queryAtom2 = (IQueryAtom)queryBond2.getOther(centralQueryAtom);
            IAtom atom1 = bond1.getOther(centralAtom);
            IAtom atom2 = bond2.getOther(centralAtom);
            return queryAtom1.matches(atom1) && queryAtom2.matches(atom2) || queryAtom1.matches(atom2) && queryAtom2.matches(atom1);
        }
        return centralAtom == null && centralQueryAtom == null;
    }

    private static boolean testSubgraphHeuristics(IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        IAtom atom;
        IBond bond;
        int i;
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        int ac1SingleBondCount = 0;
        int ac1DoubleBondCount = 0;
        int ac1TripleBondCount = 0;
        int ac1AromaticBondCount = 0;
        int ac2SingleBondCount = 0;
        int ac2DoubleBondCount = 0;
        int ac2TripleBondCount = 0;
        int ac2AromaticBondCount = 0;
        int ac1SCount = 0;
        int ac1OCount = 0;
        int ac1NCount = 0;
        int ac1FCount = 0;
        int ac1ClCount = 0;
        int ac1BrCount = 0;
        int ac1ICount = 0;
        int ac1CCount = 0;
        int ac2SCount = 0;
        int ac2OCount = 0;
        int ac2NCount = 0;
        int ac2FCount = 0;
        int ac2ClCount = 0;
        int ac2BrCount = 0;
        int ac2ICount = 0;
        int ac2CCount = 0;
        for (i = 0; i < ac1.getBondCount(); ++i) {
            bond = ac1.getBond(i);
            if (bond.getFlag(32)) {
                ++ac1AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac1SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac1DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac1TripleBondCount;
        }
        for (i = 0; i < ac2.getBondCount(); ++i) {
            bond = ac2.getBond(i);
            if (bond instanceof IQueryBond) continue;
            if (bond.getFlag(32)) {
                ++ac2AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac2SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac2DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac2TripleBondCount;
        }
        if (ac2SingleBondCount > ac1SingleBondCount) {
            return false;
        }
        if (ac2AromaticBondCount > ac1AromaticBondCount) {
            return false;
        }
        if (ac2DoubleBondCount > ac1DoubleBondCount) {
            return false;
        }
        if (ac2TripleBondCount > ac1TripleBondCount) {
            return false;
        }
        block42: for (i = 0; i < ac1.getAtomCount(); ++i) {
            atom = ac1.getAtom(i);
            switch (atom.getSymbol()) {
                case "S": {
                    ++ac1SCount;
                    continue block42;
                }
                case "N": {
                    ++ac1NCount;
                    continue block42;
                }
                case "O": {
                    ++ac1OCount;
                    continue block42;
                }
                case "F": {
                    ++ac1FCount;
                    continue block42;
                }
                case "Cl": {
                    ++ac1ClCount;
                    continue block42;
                }
                case "Br": {
                    ++ac1BrCount;
                    continue block42;
                }
                case "I": {
                    ++ac1ICount;
                    continue block42;
                }
                case "C": {
                    ++ac1CCount;
                    continue block42;
                }
            }
        }
        block43: for (i = 0; i < ac2.getAtomCount(); ++i) {
            atom = ac2.getAtom(i);
            if (atom instanceof IQueryAtom) continue;
            switch (atom.getSymbol()) {
                case "S": {
                    ++ac2SCount;
                    continue block43;
                }
                case "N": {
                    ++ac2NCount;
                    continue block43;
                }
                case "O": {
                    ++ac2OCount;
                    continue block43;
                }
                case "F": {
                    ++ac2FCount;
                    continue block43;
                }
                case "Cl": {
                    ++ac2ClCount;
                    continue block43;
                }
                case "Br": {
                    ++ac2BrCount;
                    continue block43;
                }
                case "I": {
                    ++ac2ICount;
                    continue block43;
                }
                case "C": {
                    ++ac2CCount;
                    continue block43;
                }
            }
        }
        if (ac1SCount < ac2SCount) {
            return false;
        }
        if (ac1NCount < ac2NCount) {
            return false;
        }
        if (ac1OCount < ac2OCount) {
            return false;
        }
        if (ac1FCount < ac2FCount) {
            return false;
        }
        if (ac1ClCount < ac2ClCount) {
            return false;
        }
        if (ac1BrCount < ac2BrCount) {
            return false;
        }
        if (ac1ICount < ac2ICount) {
            return false;
        }
        return ac1CCount >= ac2CCount;
    }

    public static boolean isTimeout() {
        return timeout;
    }

    protected static IterationManager getIterationManager() {
        return iterationManager;
    }

    private static void setIterationManager(IterationManager aIterationManager) {
        iterationManager = aIterationManager;
    }
}

