/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.smsd.algorithm.rgraph.CDKRMapHandler;
import org.openscience.smsd.interfaces.IResults;

public class CDKMCSHandler
implements IResults {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CDKMCSHandler.class);
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean rOnPFlag = false;
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<Map<Integer, Integer>> allMCS;
    private boolean timeout;
    private AtomMatcher am;
    private BondMatcher bm;

    public CDKMCSHandler(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        this.source = source;
        this.target = target;
        this.am = am;
        this.bm = bm;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    public CDKMCSHandler(IAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    private synchronized boolean searchMCS() {
        CDKRMapHandler rmap = new CDKRMapHandler();
        try {
            List<Map<Integer, Integer>> solutions;
            if (this.source instanceof IQueryAtomContainer) {
                this.rOnPFlag = false;
                solutions = rmap.calculateOverlapsAndReduce(this.target, (IQueryAtomContainer)this.source);
                this.rOnPFlag = false;
            } else if (this.source.getAtomCount() < this.target.getAtomCount()) {
                this.rOnPFlag = false;
                solutions = rmap.calculateOverlapsAndReduce(this.target, this.source, this.am, this.bm);
            } else {
                this.rOnPFlag = true;
                solutions = rmap.calculateOverlapsAndReduce(this.source, this.target, this.am, this.bm);
            }
            this.setAllMapping(solutions);
            this.setAllAtomMapping();
        }
        catch (CDKException e) {
            rmap = null;
            LOGGER.error("WARNING: " + e.getMessage());
        }
        return rmap.isTimeout();
    }

    protected synchronized IAtomContainerSet getUncommon(IAtomContainer mol, IAtomContainer mcss, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws CDKException {
        ArrayList atomSerialsToDelete = new ArrayList();
        List<List<CDKRMap>> matches = CDKMCS.getSubgraphAtomsMaps(mol, mcss, this.am, this.bm);
        List<CDKRMap> mapList = matches.get(0);
        mapList.stream().map(o -> o).forEach(rmap -> atomSerialsToDelete.add(rmap.getId1()));
        ArrayList atomsToDelete = new ArrayList();
        atomSerialsToDelete.stream().forEach(serial -> atomsToDelete.add(mol.getAtom((int)serial)));
        atomsToDelete.stream().forEach(atom -> mol.removeAtom((IAtom)atom));
        return ConnectivityChecker.partitionIntoMolecules(mol);
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int counter = 0;
            for (Map<Integer, Integer> final_solution : solutions) {
                TreeMap atomMappings = new TreeMap();
                final_solution.entrySet().stream().forEach(Solutions -> {
                    int iIndex = (Integer)Solutions.getKey();
                    int jIndex = (Integer)Solutions.getValue();
                    if (this.rOnPFlag) {
                        atomMappings.put(iIndex, jIndex);
                    } else {
                        atomMappings.put(jIndex, iIndex);
                    }
                });
                if (this.allMCS.contains(atomMappings) || atomMappings.isEmpty()) continue;
                this.allMCS.add(counter, atomMappings);
                ++counter;
            }
        }
        catch (Exception ex) {
            ex.getCause();
        }
    }

    private synchronized void setAllAtomMapping() {
        int counter = 0;
        for (Map<Integer, Integer> final_solution : this.allMCS) {
            AtomAtomMapping atomMappings = new AtomAtomMapping(this.source, this.target);
            final_solution.keySet().stream().forEach(indexI -> {
                IAtom sourceAtom = this.source.getAtom((int)indexI);
                IAtom targetAtom = this.target.getAtom((Integer)final_solution.get(indexI));
                if (sourceAtom != null && targetAtom != null) {
                    atomMappings.put(sourceAtom, targetAtom);
                }
            });
            if (this.allAtomMCS.contains(atomMappings) || atomMappings.isEmpty()) continue;
            this.allAtomMCS.add(counter, atomMappings);
            ++counter;
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }
}

