/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.single;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.tools.BondEnergies;

public class SingleMapping {
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private final Map<Integer, Double> connectedBondOrder = new TreeMap<Integer, Double>();

    protected synchronized List<Map<IAtom, IAtom>> getOverLaps(IAtomContainer source, IAtomContainer target, AtomMatcher am) throws CDKException {
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() > 0) {
            this.setSingleAtomMap(mappings, am);
        }
        return this.postFilter(mappings);
    }

    protected synchronized List<Map<IAtom, IAtom>> getOverLaps(IQueryAtomContainer source, IAtomContainer target, AtomMatcher am) throws CDKException {
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() > 0) {
            this.setSingleAtomMap(mappings, am);
        }
        return this.postFilter(mappings);
    }

    private synchronized void setSingleAtomMap(List<Map<IAtom, IAtom>> mappings, AtomMatcher am) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom sourceAtom : this.source.atoms()) {
            for (IAtom targetAtom : this.target.atoms()) {
                HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                if (!am.matches(sourceAtom, targetAtom)) continue;
                mapAtoms.put(sourceAtom, targetAtom);
                List<IBond> Bonds = this.target.getConnectedBondsList(targetAtom);
                double totalOrder = 0.0;
                for (IBond bond : Bonds) {
                    IBond.Order bondOrder = bond.getOrder();
                    if (bondOrder == null) continue;
                    totalOrder += (double)(bondOrder.numeric() + be.getEnergies(bond));
                }
                if (!Objects.equals(targetAtom.getFormalCharge(), sourceAtom.getFormalCharge())) {
                    totalOrder += 0.5;
                }
                this.connectedBondOrder.put(counter, totalOrder);
                mappings.add(counter++, mapAtoms);
            }
        }
    }

    private synchronized List<Map<IAtom, IAtom>> postFilter(List<Map<IAtom, IAtom>> mappings) {
        ArrayList<Map<IAtom, IAtom>> sortedMap = new ArrayList<Map<IAtom, IAtom>>();
        if (mappings.isEmpty()) {
            return sortedMap;
        }
        Map<Integer, Double> sortedMapByValue = this.sortByValue(this.connectedBondOrder);
        sortedMapByValue.keySet().stream().map(key -> (Map)mappings.get((int)key)).forEach(mapToBeMoved -> sortedMap.add((Map<IAtom, IAtom>)mapToBeMoved));
        return sortedMap;
    }

    private <K, V> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, (object1, object2) -> ((Comparable)((Map.Entry)object1).getValue()).compareTo(((Map.Entry)object2).getValue()));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

