/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.ventofoggia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.algorithm.ventofoggia.Map2ValueComparator;
import org.openscience.smsd.algorithm.ventofoggia.SortOrder;

public class BaseMCS {
    protected int countR;
    protected int countP;
    protected final IAtomContainer source;
    protected final IAtomContainer target;
    protected final List<Map<IAtom, IAtom>> vfLibSolutions;
    final List<Map<Integer, Integer>> allLocalMCS;
    final List<AtomAtomMapping> allLocalAtomAtomMapping = new ArrayList<AtomAtomMapping>();
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BaseMCS.class);
    private final boolean DEBUG = false;
    final AtomMatcher atomMatcher;
    final BondMatcher bondMatcher;

    BaseMCS(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        this.allLocalMCS = new ArrayList<Map<Integer, Integer>>();
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
    }

    BaseMCS(IQueryAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        this.allLocalMCS = new ArrayList<Map<Integer, Integer>>();
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
    }

    protected synchronized boolean hasClique(Map<Integer, Integer> cliqueMap, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> storedMap : mapGlobal) {
            if (cliqueMap.size() < storedMap.size()) {
                return true;
            }
            if (!cliqueMap.equals(storedMap)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean isCliquePresent(Map<Integer, Integer> cliqueMap, List<Map<Integer, Integer>> mapGlobal) {
        return mapGlobal.stream().anyMatch(storedMap -> cliqueMap.equals(storedMap));
    }

    protected synchronized void extendCliquesWithMcGregor(List<Map<Integer, Integer>> refinedMCSSeeds) throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : refinedMCSSeeds) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (this.source instanceof IQueryAtomContainer) {
                mgit = new McGregor((IQueryAtomContainer)this.source, this.target, mappings, this.atomMatcher, this.bondMatcher);
                mgit.startMcGregorIteration((IQueryAtomContainer)this.source, mgit.getMCSSize(), extendMapping);
            } else if (this.countR > this.countP) {
                mgit = new McGregor(this.source, this.target, mappings, this.atomMatcher, this.bondMatcher);
                mgit.startMcGregorIteration(this.source, mgit.getMCSSize(), extendMapping);
            } else {
                extendMapping.clear();
                mgit = new McGregor(this.target, this.source, mappings, this.atomMatcher, this.bondMatcher);
                ROPFlag = false;
                firstPassMappings.entrySet().stream().forEach(map -> extendMapping.put((Integer)map.getValue(), (Integer)map.getKey()));
                mgit.startMcGregorIteration(this.target, mgit.getMCSSize(), extendMapping);
            }
            mappings = mgit.getMappings();
        }
        this.setMcGregorMappings(ROPFlag, mappings);
    }

    protected synchronized void setVFMappings(boolean RONP) {
        Collections.sort(this.vfLibSolutions, new Map2ValueComparator(SortOrder.DESCENDING));
        this.vfLibSolutions.stream().forEach(solution -> {
            HashMap<Integer, Integer> indexindexMapping = new HashMap<Integer, Integer>();
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            solution.entrySet().stream().forEach(mapping -> {
                if (RONP) {
                    indexindexMapping.put(this.source.indexOf((IAtom)mapping.getKey()), this.target.indexOf((IAtom)mapping.getValue()));
                    atomatomMapping.put((IAtom)mapping.getKey(), (IAtom)mapping.getValue());
                } else {
                    indexindexMapping.put(this.source.indexOf((IAtom)mapping.getValue()), this.target.indexOf((IAtom)mapping.getKey()));
                    atomatomMapping.put((IAtom)mapping.getValue(), (IAtom)mapping.getKey());
                }
            });
            if (!indexindexMapping.isEmpty() && !this.hasClique(indexindexMapping, this.getLocalMCSSolution())) {
                this.getLocalAtomMCSSolution().add(atomatomMapping);
                this.getLocalMCSSolution().add(indexindexMapping);
            }
        });
    }

    private synchronized void setMcGregorMappings(boolean RONP, List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        int solSize = 0;
        this.getLocalAtomMCSSolution().clear();
        this.getLocalMCSSolution().clear();
        for (List<Integer> mapping : mappings) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                int tIndex;
                int qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.source.getAtom(mapping.get(index));
                    tAtom = this.target.getAtom(mapping.get(index + 1));
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qAtom = this.source.getAtom(mapping.get(index + 1));
                    tAtom = this.target.getAtom(mapping.get(index));
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == -1 || tIndex == -1) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (indexindexMapping.size() > solSize) {
                solSize = indexindexMapping.size();
                this.getLocalAtomMCSSolution().clear();
                this.getLocalMCSSolution().clear();
                counter = 0;
            }
            if (indexindexMapping.isEmpty() || this.hasClique(indexindexMapping, this.getLocalMCSSolution()) || indexindexMapping.size() != solSize) continue;
            this.getLocalAtomMCSSolution().add(counter, atomatomMapping);
            this.getLocalMCSSolution().add(counter, indexindexMapping);
            ++counter;
        }
    }

    protected synchronized IAtomContainer getReactantMol() {
        return this.source;
    }

    protected synchronized IAtomContainer getProductMol() {
        return this.target;
    }

    private synchronized List<Map<Integer, Integer>> getLocalMCSSolution() {
        return Collections.synchronizedList(this.allLocalMCS);
    }

    private synchronized List<AtomAtomMapping> getLocalAtomMCSSolution() {
        return Collections.synchronizedList(this.allLocalAtomAtomMapping);
    }

    protected synchronized boolean isExtensionRequired(List<Map<Integer, Integer>> mcsSeeds) {
        int maxSize = 0;
        for (Map<Integer, Integer> map : mcsSeeds) {
            if (map.size() <= maxSize) continue;
            maxSize = map.size();
        }
        return this.source.getAtomCount() > maxSize && this.target.getAtomCount() > maxSize;
    }

    protected synchronized boolean isExtensionRequired() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        int maxSize = 0;
        for (Map<Integer, Integer> map : this.allLocalMCS) {
            if (map.size() <= maxSize) continue;
            maxSize = map.size();
        }
        return commonAtomCount > maxSize;
    }

    private synchronized int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }
}

