/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.ventofoggia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus.MappingHandler;
import org.openscience.smsd.algorithm.rgraph.CDKRMapHandler;
import org.openscience.smsd.algorithm.ventofoggia.Map1ValueComparator;
import org.openscience.smsd.algorithm.ventofoggia.SortOrder;
import org.openscience.smsd.graph.EdgeProductGraph;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.graph.algorithm.GraphKoch;
import org.openscience.smsd.interfaces.Algorithm;

public class MCSSeedGenerator
implements Callable<List<AtomAtomMapping>> {
    private final boolean DEBUG = false;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final List<AtomAtomMapping> allCliqueAtomMCS;
    private final Algorithm algorithm;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSSeedGenerator.class);
    private final AtomMatcher am;
    private final BondMatcher bm;

    public MCSSeedGenerator(IAtomContainer source, IAtomContainer target, Algorithm algorithm, AtomMatcher am, BondMatcher bm) {
        this.source = source;
        this.target = target;
        this.allCliqueAtomMCS = new ArrayList<AtomAtomMapping>();
        this.algorithm = algorithm;
        this.am = am;
        this.bm = bm;
    }

    public MCSSeedGenerator(IQueryAtomContainer source, IAtomContainer target, Algorithm algorithm) {
        this.source = source;
        this.target = target;
        this.allCliqueAtomMCS = new ArrayList<AtomAtomMapping>();
        this.algorithm = algorithm;
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
    }

    @Override
    public List<AtomAtomMapping> call() throws Exception {
        switch (this.algorithm) {
            case CDKMCS: {
                List<AtomAtomMapping> addUIT = this.addUIT();
                return addUIT;
            }
            case MCSPlus: {
                List<AtomAtomMapping> addKochCliques = this.addKochCliques();
                return addKochCliques;
            }
        }
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    protected synchronized List<AtomAtomMapping> addKochCliques() throws IOException {
        IAtomContainer ac2;
        IAtomContainer ac1;
        boolean flagExchange = false;
        if (this.source instanceof IQueryAtomContainer) {
            ac1 = (IQueryAtomContainer)this.source;
            ac2 = this.target;
        } else if (this.source.getAtomCount() <= this.target.getAtomCount()) {
            ac1 = this.source;
            ac2 = this.target;
        } else {
            flagExchange = true;
            ac1 = this.target;
            ac2 = this.source;
        }
        EdgeProductGraph gcg = EdgeProductGraph.create(ac1, ac2, this.am, this.bm);
        int search_cliques = gcg.searchCliques();
        Graph comp_graph_nodes = gcg.getCompatibilityGraph();
        GraphKoch init = null;
        boolean disconnected = ConnectivityChecker.isConnected(ac1) && ConnectivityChecker.isConnected(ac2);
        init = new GraphKoch(comp_graph_nodes);
        init.findMaximalCliques();
        Stack<Set<Vertex>> maxCliqueSet = init.getMaxCliquesSet();
        ArrayList<Map<Integer, Integer>> mappings = new ArrayList<Map<Integer, Integer>>();
        while (!maxCliqueSet.empty()) {
            Map<Integer, Integer> indexindexMapping = MappingHandler.getMapping(comp_graph_nodes, ac1, ac2, maxCliqueSet.peek(), this.am, this.bm);
            if (indexindexMapping != null) {
                mappings.add(indexindexMapping);
            }
            maxCliqueSet.pop();
        }
        for (Map map : mappings) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            for (Map.Entry map2 : map.entrySet()) {
                Integer qIndex = (Integer)map2.getKey();
                Integer tIndex = (Integer)map2.getValue();
                if (qIndex != -1 && tIndex != -1) {
                    IAtom tAtom;
                    IAtom qAtom;
                    if (flagExchange) {
                        qAtom = this.source.getAtom(tIndex);
                        tAtom = this.target.getAtom(qIndex);
                    } else {
                        qAtom = this.source.getAtom(qIndex);
                        tAtom = this.target.getAtom(tIndex);
                    }
                    atomatomMapping.put(qAtom, tAtom);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to -1");
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            if (atomatomMapping.isEmpty()) continue;
            this.allCliqueAtomMCS.add(atomatomMapping);
        }
        gcg.clear();
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    private List<AtomAtomMapping> addUIT() throws CDKException {
        List<Map<Integer, Integer>> solutions;
        boolean rOnPFlag;
        CDKRMapHandler rmap = new CDKRMapHandler();
        if (this.source instanceof IQueryAtomContainer) {
            rOnPFlag = false;
            solutions = rmap.calculateOverlapsAndReduce(this.target, (IQueryAtomContainer)this.source);
        } else if (this.source.getAtomCount() > this.target.getAtomCount()) {
            rOnPFlag = true;
            solutions = rmap.calculateOverlapsAndReduce(this.source, this.target, this.am, this.bm);
        } else {
            rOnPFlag = false;
            solutions = rmap.calculateOverlapsAndReduce(this.target, this.source, this.am, this.bm);
        }
        return this.setUITMappings(rOnPFlag, solutions);
    }

    private List<AtomAtomMapping> setUITMappings(boolean RONP, List<Map<Integer, Integer>> sol) {
        Collections.sort(sol, new Map1ValueComparator(SortOrder.DESCENDING));
        sol.stream().map(solution -> {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            solution.keySet().stream().forEach(qAtomIndex -> {
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.source.getAtom((int)qAtomIndex);
                    tAtom = this.target.getAtom((Integer)solution.get(qAtomIndex));
                } else {
                    tAtom = this.target.getAtom((int)qAtomIndex);
                    qAtom = this.source.getAtom((Integer)solution.get(qAtomIndex));
                }
                int qIndex = this.source.indexOf(qAtom);
                int tIndex = this.target.indexOf(tAtom);
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                } else {
                    try {
                        throw new CDKException("Atom index pointing to -1");
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
            });
            return atomatomMapping;
        }).filter(atomatomMapping -> !atomatomMapping.isEmpty()).forEach(atomatomMapping -> this.allCliqueAtomMCS.add((AtomAtomMapping)atomatomMapping));
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    private int[] getIndex(int cliqueIndex, List<Integer> comp_graph_nodes) {
        int[] v = new int[]{-1, -1};
        for (int i = 0; i < comp_graph_nodes.size(); i += 3) {
            if (cliqueIndex != comp_graph_nodes.get(i + 2)) continue;
            v[0] = comp_graph_nodes.get(i);
            v[1] = comp_graph_nodes.get(i + 1);
        }
        return v;
    }
}

