/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.ventofoggia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.ventofoggia.BaseMCS;
import org.openscience.smsd.algorithm.ventofoggia.MCSSeedGenerator;
import org.openscience.smsd.algorithm.ventofoggia.Map1ValueComparator;
import org.openscience.smsd.algorithm.ventofoggia.SortOrder;
import org.openscience.smsd.graph.algorithm.VentoFoggia;
import org.openscience.smsd.helper.Mappings;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.interfaces.IResults;

public final class VF2MCS
extends BaseMCS
implements IResults {
    private final List<AtomAtomMapping> allAtomMCS;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(VF2MCS.class);
    private final boolean DEBUG = false;

    public VF2MCS(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        super(source, target, am, bm);
        int maxVFMappingSize;
        boolean timeoutVF = this.searchVFCDKMappings();
        int n = maxVFMappingSize = this.allLocalMCS.iterator().hasNext() ? ((Map)this.allLocalMCS.iterator().next()).size() : 0;
        if (timeoutVF || maxVFMappingSize != source.getAtomCount() && maxVFMappingSize != target.getAtomCount()) {
            ArrayList<Map> mcsVFSeeds = new ArrayList<Map>();
            int counter = 0;
            for (Map vfMapping : this.allLocalMCS) {
                mcsVFSeeds.add(counter, vfMapping);
                ++counter;
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
            long startTimeSeeds = System.nanoTime();
            int threadsAvailable = Runtime.getRuntime().availableProcessors() - 1;
            if (threadsAvailable == 0) {
                threadsAvailable = 1;
            } else if (threadsAvailable > 2) {
                threadsAvailable = 2;
            }
            ExecutorService executor = Executors.newFixedThreadPool(threadsAvailable);
            ExecutorCompletionService<List<AtomAtomMapping>> cs = new ExecutorCompletionService<List<AtomAtomMapping>>(executor);
            IAtomContainer targetClone = null;
            try {
                targetClone = target.clone();
                HashSet<IBond> bondRemovedT = new HashSet<IBond>();
                for (IBond b1 : targetClone.bonds()) {
                    boolean flag = false;
                    for (IBond b2 : source.bonds()) {
                        if (!AtomBondMatcher.matchAtomAndBond(b1, b2, this.atomMatcher, this.bondMatcher, true)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    bondRemovedT.add(b1);
                }
                for (IBond b : bondRemovedT) {
                    targetClone.removeBond(b);
                }
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            int jobCounter = 0;
            if (targetClone != null && source.getBondCount() > 0 && targetClone.getBondCount() > 0) {
                MCSSeedGenerator mcsSeedGeneratorUIT = new MCSSeedGenerator(source, targetClone, Algorithm.CDKMCS, this.atomMatcher, this.bondMatcher);
                cs.submit(mcsSeedGeneratorUIT);
                ++jobCounter;
            }
            MCSSeedGenerator mcsSeedGeneratorKoch = new MCSSeedGenerator(source, targetClone, Algorithm.MCSPlus, this.atomMatcher, this.bondMatcher);
            cs.submit(mcsSeedGeneratorKoch);
            ++jobCounter;
            HashSet mcsSeeds = new HashSet();
            for (int i = 0; i < jobCounter; ++i) {
                try {
                    List chosen = (List)cs.take().get();
                    chosen.stream().map(mapping -> {
                        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
                        map.putAll(mapping.getMappingsByIndex());
                        return map;
                    }).forEach(map -> mcsSeeds.add(map));
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            System.gc();
            long stopTimeSeeds = System.nanoTime();
            int solutionSize = 0;
            counter = 0;
            ArrayList<Map<Integer, Integer>> cleanedMCSSeeds = new ArrayList<Map<Integer, Integer>>();
            if (!mcsSeeds.isEmpty()) {
                for (Map map2 : mcsSeeds) {
                    if (map2.size() > solutionSize) {
                        solutionSize = map2.size();
                        cleanedMCSSeeds.clear();
                        counter = 0;
                    }
                    if (map2.isEmpty() || map2.size() != solutionSize || super.isCliquePresent(map2, cleanedMCSSeeds)) continue;
                    cleanedMCSSeeds.add(counter, map2);
                    ++counter;
                }
            }
            mcsVFSeeds.stream().filter(map -> !map.isEmpty() && !super.isCliquePresent((Map<Integer, Integer>)map, (List<Map<Integer, Integer>>)cleanedMCSSeeds)).forEach(_item -> cleanedMCSSeeds.addAll(mcsVFSeeds));
            Collections.sort(cleanedMCSSeeds, new Map1ValueComparator(SortOrder.DESCENDING));
            try {
                super.extendCliquesWithMcGregor(cleanedMCSSeeds);
            }
            catch (IOException | CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            mcsSeeds.clear();
            cleanedMCSSeeds.clear();
            solutionSize = 0;
            counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        } else {
            int solutionSize = 0;
            int counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        }
    }

    public VF2MCS(IQueryAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        super(source, target, am, bm);
        boolean timeoutVF = this.searchVFCDKMappings();
        if (!timeoutVF) {
            ArrayList<Map> mcsVFSeeds = new ArrayList<Map>();
            int counter = 0;
            for (Map vfMapping : this.allLocalMCS) {
                mcsVFSeeds.add(counter, vfMapping);
                ++counter;
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
            long startTimeSeeds = System.nanoTime();
            ExecutorService executor = Executors.newCachedThreadPool();
            ExecutorCompletionService<List<AtomAtomMapping>> cs = new ExecutorCompletionService<List<AtomAtomMapping>>(executor);
            IAtomContainer targetClone = null;
            try {
                targetClone = target.clone();
                HashSet<IBond> bondRemovedT = new HashSet<IBond>();
                for (IBond b1 : source.bonds()) {
                    IQueryBond bond = (IQueryBond)b1;
                    IQueryAtom a1 = (IQueryAtom)b1.getAtom(0);
                    IQueryAtom a2 = (IQueryAtom)b1.getAtom(1);
                    for (IBond b2 : targetClone.bonds()) {
                        boolean matches = bond.matches(b2);
                        if (a1.matches(b2.getAtom(0)) && a2.matches(b2.getAtom(1)) && !matches) {
                            bondRemovedT.add(b2);
                            continue;
                        }
                        if (!a2.matches(b2.getAtom(0)) || !a1.matches(b2.getAtom(1)) || matches) continue;
                        bondRemovedT.add(b2);
                    }
                }
                for (IBond b : bondRemovedT) {
                    targetClone.removeBond(b);
                }
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            MCSSeedGenerator mcsSeedGeneratorUIT = new MCSSeedGenerator(source, targetClone, Algorithm.CDKMCS);
            MCSSeedGenerator mcsSeedGeneratorKoch = new MCSSeedGenerator(source, targetClone, Algorithm.MCSPlus);
            int jobCounter = 0;
            cs.submit(mcsSeedGeneratorUIT);
            ++jobCounter;
            cs.submit(mcsSeedGeneratorKoch);
            ++jobCounter;
            HashSet mcsSeeds = new HashSet();
            for (int i = 0; i < jobCounter; ++i) {
                try {
                    List chosen = (List)cs.take().get();
                    chosen.stream().map(mapping -> {
                        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
                        map.putAll(mapping.getMappingsByIndex());
                        return map;
                    }).forEach(map -> mcsSeeds.add(map));
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            System.gc();
            int solutionSize = 0;
            counter = 0;
            ArrayList<Map<Integer, Integer>> cleanedMCSSeeds = new ArrayList<Map<Integer, Integer>>();
            if (!mcsSeeds.isEmpty()) {
                for (Map map2 : mcsSeeds) {
                    if (map2.size() > solutionSize) {
                        solutionSize = map2.size();
                        cleanedMCSSeeds.clear();
                        counter = 0;
                    }
                    if (map2.isEmpty() || map2.size() != solutionSize || super.hasClique(map2, cleanedMCSSeeds)) continue;
                    cleanedMCSSeeds.add(counter, map2);
                    ++counter;
                }
            }
            for (Map map2 : mcsVFSeeds) {
                if (map2.isEmpty() || map2.size() < solutionSize || super.hasClique(map2, cleanedMCSSeeds)) continue;
                cleanedMCSSeeds.add(counter, map2);
                ++counter;
            }
            Collections.sort(cleanedMCSSeeds, new Map1ValueComparator(SortOrder.DESCENDING));
            try {
                super.extendCliquesWithMcGregor(cleanedMCSSeeds);
            }
            catch (IOException | CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            mcsSeeds.clear();
            cleanedMCSSeeds.clear();
            solutionSize = 0;
            counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        } else {
            int solSize = 0;
            int counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solSize) {
                        solSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
        }
    }

    private synchronized boolean searchVFCDKMappings() {
        if (!(this.source instanceof IQueryAtomContainer) && !(this.target instanceof IQueryAtomContainer)) {
            this.countR = this.getReactantMol().getAtomCount();
            this.countP = this.getProductMol().getAtomCount();
        }
        if (this.source instanceof IQueryAtomContainer) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll((IQueryAtomContainer)this.target);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.limit(10).toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        } else if (this.countR <= this.countP) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll(this.target);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.limit(10).toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        } else if (this.countR > this.countP) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.target, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll(this.source);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.limit(10).toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(false);
        }
        return !this.vfLibSolutions.isEmpty();
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.getReactantMol(), this.getProductMol());
    }

    synchronized boolean isMoleculeConnected(IAtomContainer compound1, IAtomContainer compound2) {
        boolean connected1 = true;
        IAtomContainerSet partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound1);
        for (IAtomContainer a : partitionIntoMolecules.atomContainers()) {
            if (a.getAtomCount() != 1) continue;
            connected1 = false;
        }
        boolean connected2 = true;
        partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound2);
        for (IAtomContainer a : partitionIntoMolecules.atomContainers()) {
            if (a.getAtomCount() != 1) continue;
            connected2 = false;
        }
        return connected1 & connected2;
    }
}

