/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.ventofoggia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.graph.algorithm.VentoFoggia;
import org.openscience.smsd.helper.Mappings;
import org.openscience.smsd.interfaces.IResults;

public class VF2Substructure
implements IResults {
    private final boolean DEBUG = false;
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<AtomAtomMapping> allAtomMCSCopy;
    private final List<Map<Integer, Integer>> allMCS;
    private final List<Map<Integer, Integer>> allMCSCopy;
    private List<Map<IAtom, IAtom>> vfLibSolutions;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private int bestHitSize = -1;
    private int countR = 0;
    private int countP = 0;
    private boolean isSubgraph = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(VF2Substructure.class);
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    public VF2Substructure(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm, boolean findallMatches) {
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allAtomMCSCopy = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allMCSCopy = new ArrayList<Map<Integer, Integer>>();
        this.isSubgraph = findallMatches ? this.findSubgraphs() : this.findSubgraph();
    }

    public VF2Substructure(IQueryAtomContainer source, IAtomContainer target, boolean findallMatches, AtomMatcher am, BondMatcher bm) {
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allAtomMCSCopy = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allMCSCopy = new ArrayList<Map<Integer, Integer>>();
        this.isSubgraph = findallMatches ? this.findSubgraphs() : this.findSubgraph();
    }

    private boolean findSubgraph() {
        boolean subgraph = this.searchVFCDKMapping();
        if (!this.allAtomMCSCopy.isEmpty() && this.allAtomMCSCopy.iterator().next().getCount() == this.source.getAtomCount()) {
            this.allAtomMCS.addAll(this.allAtomMCSCopy);
            this.allMCS.addAll(this.allMCSCopy);
        }
        return !this.allAtomMCS.isEmpty() && this.allAtomMCS.iterator().next().getCount() == this.source.getAtomCount();
    }

    private boolean findSubgraphs() {
        boolean flagSubGraph = this.searchVFCDKMapping();
        if (!flagSubGraph) {
            return false;
        }
        boolean timoutVF = this.searchVFCDKMappings();
        boolean flag = this.isExtensionFeasible();
        if (flag && !this.vfLibSolutions.isEmpty() && !timoutVF && !(this.source instanceof IQueryAtomContainer)) {
            try {
                this.searchMcGregorMapping();
            }
            catch (IOException | CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        } else if (!this.allAtomMCSCopy.isEmpty() && this.allAtomMCSCopy.iterator().next().getCount() == this.source.getAtomCount()) {
            this.allAtomMCS.addAll(this.allAtomMCSCopy);
            this.allMCS.addAll(this.allMCSCopy);
        }
        return !this.allAtomMCS.isEmpty() && this.allAtomMCS.iterator().next().getCount() == this.source.getAtomCount();
    }

    private synchronized boolean isExtensionFeasible() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        return commonAtomCount > this.bestHitSize;
    }

    private boolean hasMap(Map<Integer, Integer> maps, List<Map<Integer, Integer>> mapGlobal) {
        return mapGlobal.stream().anyMatch(test -> test.equals(maps));
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    private synchronized int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    private synchronized boolean searchVFCDKMapping() {
        if (!(this.source instanceof IQueryAtomContainer) && !(this.target instanceof IQueryAtomContainer)) {
            this.countR = this.getReactantMol().getAtomCount();
            this.countP = this.getProductMol().getAtomCount();
        }
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        if (this.source instanceof IQueryAtomContainer) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll((IQueryAtomContainer)this.target).limit(1);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        } else if (this.countR <= this.countP) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll(this.target).limit(1);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        }
        return !this.vfLibSolutions.isEmpty();
    }

    private synchronized boolean searchVFCDKMappings() {
        if (!(this.source instanceof IQueryAtomContainer) && !(this.target instanceof IQueryAtomContainer)) {
            this.countR = this.getReactantMol().getAtomCount();
            this.countP = this.getProductMol().getAtomCount();
        }
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        if (this.source instanceof IQueryAtomContainer) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll((IQueryAtomContainer)this.target);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.limit(10).toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        } else if (this.countR <= this.countP) {
            VentoFoggia findSubstructure = VentoFoggia.findSubstructure(this.source, this.atomMatcher, this.bondMatcher);
            Mappings matchAll = findSubstructure.matchAll(this.target);
            Iterable<Map<IAtom, IAtom>> toAtomMap = matchAll.limit(10).toAtomMap();
            for (Map<IAtom, IAtom> map : toAtomMap) {
                this.vfLibSolutions.add(map);
            }
            this.setVFMappings(true);
        }
        return !this.vfLibSolutions.isEmpty();
    }

    private synchronized void searchMcGregorMapping() throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : this.allMCSCopy) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (this.source instanceof IQueryAtomContainer) {
                mgit = new McGregor((IQueryAtomContainer)this.source, this.target, mappings, this.atomMatcher, this.bondMatcher);
                mgit.startMcGregorIteration((IQueryAtomContainer)this.source, mgit.getMCSSize(), extendMapping);
            } else {
                extendMapping.clear();
                mgit = new McGregor(this.target, this.source, mappings, this.atomMatcher, this.bondMatcher);
                ROPFlag = false;
                firstPassMappings.entrySet().stream().forEach(map -> extendMapping.put((Integer)map.getValue(), (Integer)map.getKey()));
                mgit.startMcGregorIteration(this.target, mgit.getMCSSize(), extendMapping);
            }
            mappings = mgit.getMappings();
        }
        this.setMcGregorMappings(ROPFlag, mappings);
    }

    private synchronized void setVFMappings(boolean RONP) {
        int counter = 0;
        for (Map<IAtom, IAtom> solution : this.vfLibSolutions) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            solution.entrySet().stream().forEach(mapping -> {
                Integer tIndex;
                Integer qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = (IAtom)mapping.getKey();
                    tAtom = (IAtom)mapping.getValue();
                    qIndex = this.source.indexOf(qAtom);
                    tIndex = this.target.indexOf(tAtom);
                } else {
                    tAtom = (IAtom)mapping.getKey();
                    qAtom = (IAtom)mapping.getValue();
                    qIndex = this.source.indexOf(qAtom);
                    tIndex = this.target.indexOf(tAtom);
                }
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                    indexindexMapping.put(qIndex, tIndex);
                } else {
                    try {
                        throw new CDKException("Atom index pointing to -1");
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
            });
            if (indexindexMapping.size() > this.bestHitSize) {
                this.bestHitSize = indexindexMapping.size();
                this.allAtomMCSCopy.clear();
                this.allMCSCopy.clear();
                counter = 0;
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, this.allMCSCopy) || indexindexMapping.size() != this.bestHitSize) continue;
            this.allAtomMCSCopy.add(counter, atomatomMapping);
            this.allMCSCopy.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private synchronized void setMcGregorMappings(boolean RONP, List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        for (List<Integer> mapping : mappings) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                Integer tIndex;
                Integer qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index));
                    tAtom = this.getProductMol().getAtom(mapping.get(index + 1));
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index + 1));
                    tAtom = this.getProductMol().getAtom(mapping.get(index));
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == null || tIndex == null) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (indexindexMapping.size() > this.bestHitSize) {
                this.bestHitSize = indexindexMapping.size();
                this.allAtomMCS.clear();
                this.allMCS.clear();
                counter = 0;
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, this.allMCS) || indexindexMapping.size() != this.bestHitSize) continue;
            this.allAtomMCS.add(counter, atomatomMapping);
            this.allMCS.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private synchronized IAtomContainer getReactantMol() {
        return this.source;
    }

    private synchronized IAtomContainer getProductMol() {
        return this.target;
    }

    public boolean isSubgraph() {
        return this.isSubgraph;
    }
}

