/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.substructure;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.vflib.substructure.Pair;
import org.openscience.smsd.algorithm.vflib.substructure.SharedState;

final class State {
    private final IAtomContainer source;
    private final IAtomContainer target;
    private AtomMatcher am;
    private BondMatcher bm;
    private int size;
    private int sourceTerminalSize;
    private int targetTerminalSize;
    private Pair<Integer, Integer> lastAddition;
    private SharedState sharedState;
    private final boolean ownSharedState;
    private boolean[][] matches;
    private boolean isMatchPossible = false;

    public boolean isGoal() {
        return this.size == this.source.getAtomCount();
    }

    public boolean isDead() {
        return !this.isMatchPossible || this.source.getAtomCount() > this.target.getAtomCount();
    }

    public boolean hasNextCandidate(Pair<Integer, Integer> candidate) {
        return candidate.getSourceAtom() != -1;
    }

    int getSize() {
        return this.size;
    }

    IAtomContainer getSource() {
        return this.source;
    }

    IAtomContainer getTarget() {
        return this.target;
    }

    IAtom sourceAtom(int index) {
        return this.source.getAtom(index);
    }

    IAtom targetAtom(int index) {
        return this.target.getAtom(index);
    }

    State(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        this.size = 0;
        this.sourceTerminalSize = 0;
        this.targetTerminalSize = 0;
        this.source = source;
        this.target = target;
        this.ownSharedState = true;
        this.matches = new boolean[this.source.getAtomCount()][this.target.getAtomCount()];
        this.isMatchPossible = this.isFeasible();
        this.lastAddition = new Pair<Integer, Integer>(-1, -1);
        this.sharedState = new SharedState(source.getAtomCount(), target.getAtomCount());
        this.am = am;
        this.bm = bm;
    }

    State(IQueryAtomContainer source, IAtomContainer target) {
        this.size = 0;
        this.sourceTerminalSize = 0;
        this.targetTerminalSize = 0;
        this.source = source;
        this.target = target;
        this.ownSharedState = true;
        this.matches = new boolean[this.source.getAtomCount()][this.target.getAtomCount()];
        this.isMatchPossible = this.isFeasible();
        this.lastAddition = new Pair<Integer, Integer>(-1, -1);
        this.sharedState = new SharedState(source.getAtomCount(), target.getAtomCount());
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
    }

    State(State state) {
        this.size = state.size;
        this.sourceTerminalSize = state.sourceTerminalSize;
        this.targetTerminalSize = state.targetTerminalSize;
        this.source = state.source;
        this.target = state.target;
        this.ownSharedState = false;
        this.matches = state.matches;
        this.lastAddition = new Pair<Integer, Integer>(-1, -1);
        this.sharedState = state.sharedState;
        this.am = state.am;
        this.bm = state.bm;
    }

    private boolean isFeasible() {
        for (int i = 0; i < this.source.getAtomCount(); ++i) {
            boolean flag = false;
            for (int j = 0; j < this.target.getAtomCount(); ++j) {
                if (this.matcher(i, j)) {
                    this.matches[i][j] = true;
                    flag = true;
                    continue;
                }
                this.matches[i][j] = false;
            }
            if (flag) continue;
            this.matches = null;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.ownSharedState && this.sharedState != null) {
            this.sharedState = null;
        }
    }

    AtomAtomMapping getMapping() {
        AtomAtomMapping mapping = new AtomAtomMapping(this.source, this.target);
        for (int i = 0; i < this.size; ++i) {
            mapping.put(this.source.getAtom(i), this.target.getAtom(this.sharedState.sourceMapping[i]));
        }
        return mapping;
    }

    Pair<Integer, Integer> nextCandidate(Pair<Integer, Integer> lastCandidate) {
        int lastSourceAtom = lastCandidate.getSourceAtom();
        int lastTargetAtom = lastCandidate.getTargetAtom();
        int sourceSize = this.source.getAtomCount();
        int targetSize = this.target.getAtomCount();
        if (lastSourceAtom == -1) {
            lastSourceAtom = 0;
        }
        lastTargetAtom = lastTargetAtom == -1 ? 0 : ++lastTargetAtom;
        if (this.sourceTerminalSize > this.size && this.targetTerminalSize > this.size) {
            while (lastSourceAtom < sourceSize && (this.sharedState.sourceMapping[lastSourceAtom] != -1 || this.sharedState.sourceTerminalSet[lastSourceAtom] == 0)) {
                ++lastSourceAtom;
                lastTargetAtom = 0;
            }
        } else {
            while (lastSourceAtom < sourceSize && this.sharedState.sourceMapping[lastSourceAtom] != -1) {
                ++lastSourceAtom;
                lastTargetAtom = 0;
            }
        }
        if (this.sourceTerminalSize > this.size && this.targetTerminalSize > this.size) {
            while (lastTargetAtom < targetSize && (this.sharedState.targetMapping[lastTargetAtom] != -1 || this.sharedState.targetTerminalSet[lastTargetAtom] == 0)) {
                ++lastTargetAtom;
            }
        } else {
            while (lastTargetAtom < targetSize && this.sharedState.targetMapping[lastTargetAtom] != -1) {
                ++lastTargetAtom;
            }
        }
        if (lastSourceAtom < sourceSize && lastTargetAtom < targetSize) {
            return new Pair<Integer, Integer>(lastSourceAtom, lastTargetAtom);
        }
        return new Pair<Integer, Integer>(-1, -1);
    }

    void nextState(Pair<Integer, Integer> candidate) {
        ++this.size;
        this.lastAddition = candidate;
        int sourceAtom = candidate.getSourceAtom();
        int targetAtom = candidate.getTargetAtom();
        if (this.sharedState.sourceTerminalSet[sourceAtom] < 1) {
            this.sharedState.sourceTerminalSet[sourceAtom] = this.size;
        }
        if (this.sharedState.targetTerminalSet[targetAtom] < 1) {
            this.sharedState.targetTerminalSet[targetAtom] = this.size;
        }
        this.sharedState.sourceMapping[sourceAtom] = targetAtom;
        this.sharedState.targetMapping[targetAtom] = sourceAtom;
        List<IAtom> sourceNeighbours = this.source.getConnectedAtomsList(this.source.getAtom(sourceAtom));
        sourceNeighbours.stream().map(neighbor -> this.source.indexOf((IAtom)neighbor)).filter(neighbourIndex -> this.sharedState.sourceTerminalSet[neighbourIndex] < 1).map(neighbourIndex -> {
            this.sharedState.sourceTerminalSet[neighbourIndex.intValue()] = this.size;
            return neighbourIndex;
        }).forEach(_item -> ++this.sourceTerminalSize);
        List<IAtom> targetNeighbours = this.target.getConnectedAtomsList(this.target.getAtom(targetAtom));
        targetNeighbours.stream().map(neighbor -> this.target.indexOf((IAtom)neighbor)).filter(neighbourIndex -> this.sharedState.targetTerminalSet[neighbourIndex] < 1).map(neighbourIndex -> {
            this.sharedState.targetTerminalSet[neighbourIndex.intValue()] = this.size;
            return neighbourIndex;
        }).forEach(_item -> ++this.targetTerminalSize);
    }

    void backTrack() {
        if (this.isGoal()) {
            this.lastAddition = new Pair<Integer, Integer>(-1, -1);
            return;
        }
        int addedSourceAtom = this.lastAddition.getSourceAtom();
        if (this.sharedState.sourceTerminalSet[addedSourceAtom] == this.size) {
            this.sharedState.sourceTerminalSet[addedSourceAtom] = 0;
        }
        List<IAtom> sourceNeighbours = this.source.getConnectedAtomsList(this.source.getAtom(addedSourceAtom));
        sourceNeighbours.stream().map(neighbor -> this.source.indexOf((IAtom)neighbor)).filter(neighbourIndex -> this.sharedState.sourceTerminalSet[neighbourIndex] == this.size).forEach(neighbourIndex -> {
            this.sharedState.sourceTerminalSet[neighbourIndex.intValue()] = 0;
        });
        int addedTargetAtom = this.lastAddition.getTargetAtom();
        if (this.sharedState.targetTerminalSet[addedTargetAtom] == this.size) {
            this.sharedState.targetTerminalSet[addedTargetAtom] = 0;
        }
        List<IAtom> targetNeighbours = this.target.getConnectedAtomsList(this.target.getAtom(addedTargetAtom));
        targetNeighbours.stream().map(neighbor -> this.target.indexOf((IAtom)neighbor)).filter(neighbourIndex -> this.sharedState.targetTerminalSet[neighbourIndex] == this.size).forEach(neighbourIndex -> {
            this.sharedState.targetTerminalSet[neighbourIndex.intValue()] = 0;
        });
        this.sharedState.sourceMapping[addedSourceAtom] = -1;
        this.sharedState.targetMapping[addedTargetAtom] = -1;
        --this.size;
        this.lastAddition = new Pair<Integer, Integer>(-1, -1);
    }

    boolean isMatchFeasible(Pair<Integer, Integer> candidate) {
        int targetAtom;
        int sourceAtom = candidate.getSourceAtom();
        if (!this.matches[sourceAtom][targetAtom = candidate.getTargetAtom().intValue()]) {
            return false;
        }
        int sourceTerminalNeighborCount = 0;
        int targetTerminalNeighborCount = 0;
        int sourceNewNeighborCount = 0;
        int targetNewNeighborCount = 0;
        List<IAtom> sourceNeighbours = this.source.getConnectedAtomsList(this.source.getAtom(sourceAtom));
        for (IAtom neighbour : sourceNeighbours) {
            int neighbourIndex = this.source.indexOf(neighbour);
            IAtom sourceAtomAtom = this.source.getAtom(sourceAtom);
            IBond sourceBond = this.source.getBond(sourceAtomAtom, neighbour);
            if (this.sharedState.sourceMapping[neighbourIndex] != -1) {
                int targetNeighbor = this.sharedState.sourceMapping[neighbourIndex];
                IAtom targetNeighbourAtom = this.target.getAtom(targetNeighbor);
                IAtom targetAtomAtom = this.target.getAtom(targetAtom);
                if (this.target.getBond(targetAtomAtom, targetNeighbourAtom) == null) {
                    return false;
                }
                IBond targetBond = this.target.getBond(targetAtomAtom, targetNeighbourAtom);
                if (this.matchBonds(sourceBond, targetBond)) continue;
                return false;
            }
            if (this.sharedState.sourceTerminalSet[neighbourIndex] > 0) {
                ++sourceTerminalNeighborCount;
                continue;
            }
            ++sourceNewNeighborCount;
        }
        List<IAtom> targetNeighbours = this.target.getConnectedAtomsList(this.target.getAtom(targetAtom));
        for (IAtom neighbour : targetNeighbours) {
            int neighbourIndex = this.target.indexOf(neighbour);
            if (this.sharedState.targetMapping[neighbourIndex] != -1) continue;
            if (this.sharedState.targetTerminalSet[neighbourIndex] > 0) {
                ++targetTerminalNeighborCount;
                continue;
            }
            ++targetNewNeighborCount;
        }
        return sourceTerminalNeighborCount <= targetTerminalNeighborCount && sourceNewNeighborCount <= targetNewNeighborCount;
    }

    boolean matchFirst(State state, List<AtomAtomMapping> mappings) {
        if (state.isGoal()) {
            mappings.add(state.getMapping());
            return true;
        }
        Pair<Integer, Integer> lastCandidate = new Pair<Integer, Integer>(-1, -1);
        boolean found = false;
        while (!found) {
            Pair<Integer, Integer> candidate = state.nextCandidate(lastCandidate);
            if (!state.hasNextCandidate(candidate)) {
                return false;
            }
            lastCandidate = candidate;
            if (!state.isMatchFeasible(candidate)) continue;
            State nextState = new State(state);
            nextState.nextState(candidate);
            found = this.matchFirst(nextState, mappings);
            if (found) {
                return true;
            }
            nextState.backTrack();
        }
        return found;
    }

    void matchAll(State state, List<AtomAtomMapping> mappings) {
        if (state.isGoal()) {
            AtomAtomMapping map = state.getMapping();
            if (!this.hasMap(map, mappings)) {
                mappings.add(state.getMapping());
            }
            return;
        }
        Pair<Integer, Integer> lastCandidate = new Pair<Integer, Integer>(-1, -1);
        Pair<Integer, Integer> candidate = state.nextCandidate(lastCandidate);
        while (state.hasNextCandidate(candidate)) {
            lastCandidate = candidate;
            if (!state.isMatchFeasible(lastCandidate)) continue;
            State nextState = new State(state);
            nextState.nextState(candidate);
            this.matchAll(nextState, mappings);
            nextState.backTrack();
        }
    }

    private boolean matcher(int queryAtom, int targetAtom) {
        List<IAtom> sourceNeighbours = this.source.getConnectedAtomsList(this.source.getAtom(queryAtom));
        List<IAtom> targetNeighbours = this.target.getConnectedAtomsList(this.target.getAtom(targetAtom));
        if (!this.matchAtoms(this.source.getAtom(queryAtom), this.target.getAtom(targetAtom))) {
            return false;
        }
        return sourceNeighbours.size() <= targetNeighbours.size();
    }

    boolean matchBonds(IBond queryBond, IBond targetBond) {
        return AtomBondMatcher.matches(queryBond, queryBond, this.bm);
    }

    boolean matchAtoms(IAtom sourceAtom, IAtom targetAtom) {
        return AtomBondMatcher.matches(sourceAtom, targetAtom, this.am);
    }

    private boolean hasMap(AtomAtomMapping map, List<AtomAtomMapping> mappings) {
        return mappings.stream().anyMatch(test -> test.equals(map));
    }
}

