/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.substructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.vflib.substructure.State;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.interfaces.IResults;

public final class VF2
implements IResults {
    private List<AtomAtomMapping> allAtomMCS = null;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean isSubgraph = false;
    private final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(VF2.class);
    private AtomMatcher am;
    private BondMatcher bm;

    public VF2(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) {
        this.source = source;
        this.target = target;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.isSubgraph = this.findSubgraph();
        this.am = am;
        this.bm = bm;
    }

    public VF2(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.am = AtomMatcher.forQuery();
        this.bm = BondMatcher.forQuery();
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.isSubgraph = this.findSubgraph();
    }

    private synchronized void isomorphism() {
        State state;
        if (!this.isDead(this.source, this.target) && MoleculeInitializer.testIsSubgraphHeuristics(this.source, this.target, this.am, this.bm) && !(state = new State(this.source, this.target, this.am, this.bm)).isDead()) {
            state.matchFirst(state, this.allAtomMCS);
        }
    }

    private synchronized void isomorphisms() {
        State state;
        if (!this.isDead(this.source, this.target) && MoleculeInitializer.testIsSubgraphHeuristics(this.source, this.target, this.am, this.bm) && !(state = new State(this.source, this.target, this.am, this.bm)).isDead()) {
            state.matchAll(state, this.allAtomMCS);
        }
    }

    private synchronized boolean isDead(IAtomContainer a, IAtomContainer b) {
        return a.getAtomCount() > b.getAtomCount();
    }

    private boolean findSubgraph() {
        this.isomorphism();
        return !this.allAtomMCS.isEmpty();
    }

    private boolean findSubgraphs() {
        this.isomorphisms();
        return !this.allAtomMCS.isEmpty();
    }

    @Override
    public List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public boolean isSubgraph() {
        return this.isSubgraph;
    }
}

