/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.filters.ChemicalFilters;
import org.openscience.smsd.filters.IChemicalFilter;
import org.openscience.smsd.filters.Sotter;

public final class FragmentFilter
extends Sotter
implements IChemicalFilter<Integer> {
    private final List<Integer> fragmentSize;
    private final ChemicalFilters chemfilter;

    FragmentFilter(ChemicalFilters chemfilter) {
        this.chemfilter = chemfilter;
        this.fragmentSize = new ArrayList<Integer>();
    }

    @Override
    public synchronized Integer sortResults(Map<Integer, AtomAtomMapping> allFragmentAtomMCS, Map<Integer, Integer> fragmentScoreMap) throws CDKException {
        int _minFragmentScore = 9999;
        for (Integer key : allFragmentAtomMCS.keySet()) {
            AtomAtomMapping mcsAtom = allFragmentAtomMCS.get(key);
            int fragmentCount = this.getMappedMoleculeFragmentSize(mcsAtom);
            fragmentScoreMap.put(key, fragmentCount);
            if (_minFragmentScore <= fragmentCount) continue;
            _minFragmentScore = fragmentCount;
        }
        return _minFragmentScore;
    }

    @Override
    public synchronized List<Integer> getScores() {
        return Collections.unmodifiableList(this.fragmentSize);
    }

    @Override
    public synchronized void clearScores() {
        this.fragmentSize.clear();
    }

    @Override
    public synchronized void addScore(int counter, Integer value) {
        this.fragmentSize.add(counter, value);
    }

    @Override
    public synchronized void fillMap(Map<Integer, Integer> fragmentScoreMap) {
        int Index2 = 0;
        for (Integer score : this.fragmentSize) {
            fragmentScoreMap.put(Index2, score);
            ++Index2;
        }
    }

    private synchronized int getMappedMoleculeFragmentSize(AtomAtomMapping mcsAtomSolution) {
        IAtomContainer Educt = SilentChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, this.chemfilter.getQuery());
        IAtomContainer product = SilentChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, this.chemfilter.getTarget());
        if (mcsAtomSolution != null) {
            mcsAtomSolution.getMappingsByAtoms().entrySet().stream().forEach(map -> {
                IAtom atomE = (IAtom)map.getKey();
                IAtom atomP = (IAtom)map.getValue();
                Educt.removeAtom(atomE);
                product.removeAtom(atomP);
            });
        }
        return this.getFragmentCount(Educt) + this.getFragmentCount(product);
    }

    private synchronized int getFragmentCount(IAtomContainer molecule) {
        boolean fragmentFlag = true;
        IAtomContainerSet fragmentMolSet = SilentChemObjectBuilder.getInstance().newInstance(IAtomContainerSet.class, new Object[0]);
        int countFrag = 0;
        if (molecule.getAtomCount() > 0) {
            fragmentFlag = ConnectivityChecker.isConnected(molecule);
            if (!fragmentFlag) {
                fragmentMolSet.add(ConnectivityChecker.partitionIntoMolecules(molecule));
            } else {
                fragmentMolSet.addAtomContainer(molecule);
            }
            countFrag = fragmentMolSet.getAtomContainerCount();
        }
        return countFrag;
    }
}

