/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph;

import java.io.Serializable;
import java.util.Objects;
import org.openscience.smsd.graph.EdgeType;

public class Edge
implements Serializable {
    private static final long serialVersionUID = 52343464641L;
    private final Integer source;
    private final Integer sink;
    private EdgeType edgeType;

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Objects.hashCode(this.source);
        hash = 11 * hash + Objects.hashCode(this.sink);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.sink, other.sink);
    }

    public EdgeType getEdgeType() {
        return this.edgeType == null ? EdgeType.UNSET : this.edgeType;
    }

    public void setEdgeType(EdgeType edgeType) {
        this.edgeType = edgeType;
    }

    public String toString() {
        return "Edge{i=" + this.source + ", j=" + this.sink + "}";
    }

    public Edge(Integer i, Integer j) {
        this.source = i;
        this.sink = j;
        this.edgeType = EdgeType.UNSET;
    }

    public Integer getSource() {
        return this.source;
    }

    public Integer getSink() {
        return this.sink;
    }

    public boolean isC_Edge() {
        return this.edgeType == EdgeType.C_EDGE;
    }

    public boolean isD_Edge() {
        return this.edgeType == EdgeType.D_EDGE;
    }
}

