/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.graph.EdgeType;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public final class EdgeProductGraph
implements Serializable {
    private final boolean DEBUG = false;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private static final long serialVersionUID = 96986606860861L;
    private final Graph g;
    private final IAtomContainer source;
    private final IAtomContainer target;

    public static EdgeProductGraph create(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws IOException {
        return new EdgeProductGraph(source, target, am, bm);
    }

    public Graph getCompatibilityGraph() {
        return this.g;
    }

    private EdgeProductGraph(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws IOException {
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.source = source;
        this.target = target;
        this.g = new Graph();
    }

    public int searchCliques() {
        this.compatibilityGraphNodes();
        int edges = this.compatibilityGraphDirected();
        return this.g.V();
    }

    private void compatibilityGraphNodes() {
        int compatibilityNodeCounter = 1;
        Iterable<IBond> qbonds = this.source.bonds();
        Iterable<IBond> tbonds = this.target.bonds();
        for (IBond a : qbonds) {
            for (IBond b : tbonds) {
                if (!AtomBondMatcher.matchAtomAndBond(a, b, this.atomMatcher, this.bondMatcher, true)) continue;
                Vertex node = new Vertex(compatibilityNodeCounter);
                node.setCompatibilityBondPair(this.source.indexOf(a), this.target.indexOf(b));
                this.g.addNode(node);
                ++compatibilityNodeCounter;
            }
        }
    }

    private void addEdge(Vertex n1, Vertex n2) {
        EdgeType edgetype = this.edgePairsCompatible(n1, n2);
        if (edgetype != null && (edgetype == EdgeType.C_EDGE || edgetype == EdgeType.D_EDGE)) {
            this.g.addEdge(n1, n2, edgetype);
        }
    }

    private int compatibilityGraphDirected() {
        int counter = 1;
        Stack<Vertex> nodesToCompare = new Stack<Vertex>();
        Iterator<Vertex> iterator = this.g.iterator();
        while (iterator.hasNext()) {
            nodesToCompare.add(iterator.next());
        }
        while (!nodesToCompare.empty()) {
            Vertex n1 = (Vertex)nodesToCompare.pop();
            for (Vertex n2 : nodesToCompare) {
                this.addEdge(n1, n2);
                ++counter;
            }
        }
        return this.g.E();
    }

    private EdgeType edgePairsCompatible(Vertex p1, Vertex p2) {
        IBond e1 = this.source.getBond(p1.getQueryBondIndex());
        IBond e2 = this.target.getBond(p1.getTargetBondIndex());
        IBond f1 = this.source.getBond(p2.getQueryBondIndex());
        IBond f2 = this.target.getBond(p2.getTargetBondIndex());
        if (e1 == f1 || e2 == f2) {
            return null;
        }
        Set<IAtom> possibleVerticesG1 = this.commonVertices(this.source, e1, f1);
        Set<IAtom> possibleVerticesG2 = this.commonVertices(this.target, e2, f2);
        if (possibleVerticesG1.isEmpty() && possibleVerticesG2.isEmpty()) {
            return EdgeType.D_EDGE;
        }
        if (!possibleVerticesG1.isEmpty() && !possibleVerticesG2.isEmpty()) {
            for (IAtom v1 : possibleVerticesG1) {
                for (IAtom v2 : possibleVerticesG2) {
                    if (!AtomBondMatcher.matches(v1, v2, this.atomMatcher)) continue;
                    return EdgeType.C_EDGE;
                }
            }
        }
        return null;
    }

    public Set<IAtom> commonVertices(IAtomContainer ac, IBond e1, IBond e2) {
        LinkedHashSet<IAtom> commonVertices = new LinkedHashSet<IAtom>();
        if (e1.getBegin().equals(e2.getBegin())) {
            commonVertices.add(e1.getBegin());
        }
        if (e1.getBegin().equals(e2.getEnd())) {
            commonVertices.add(e1.getBegin());
        }
        if (e1.getEnd().equals(e2.getBegin())) {
            commonVertices.add(e1.getEnd());
        }
        if (e1.getEnd().equals(e2.getEnd())) {
            commonVertices.add(e1.getEnd());
        }
        return commonVertices;
    }

    public IAtomContainer toQuerySubgraph(Set<Vertex> edgeProductVertices) throws CloneNotSupportedException {
        IAtomContainer ac = ExtAtomContainerManipulator.cloneWithIDs(this.source);
        HashSet atomsMapped = new HashSet();
        edgeProductVertices.stream().map(ep -> ep.getQueryBondIndex()).map(bondIndex -> ac.getBond((int)bondIndex)).map(bond -> {
            atomsMapped.add(bond.getBegin());
            return bond;
        }).forEachOrdered(bond -> atomsMapped.add(bond.getEnd()));
        HashSet<IAtom> atomsToBeRemoved = new HashSet<IAtom>();
        for (IAtom a2 : ac.atoms()) {
            atomsToBeRemoved.add(a2);
        }
        atomsToBeRemoved.removeAll(atomsMapped);
        atomsToBeRemoved.forEach(a -> ac.removeAtom((IAtom)a));
        return ac;
    }

    public IAtomContainer toTargetSubgraph(Set<Vertex> edgeProductVertices) throws CloneNotSupportedException {
        IAtomContainer ac = ExtAtomContainerManipulator.cloneWithIDs(this.target);
        HashSet atomsMapped = new HashSet();
        edgeProductVertices.stream().map(ep -> ep.getTargetBondIndex()).map(bondIndex -> ac.getBond((int)bondIndex)).map(bond -> {
            atomsMapped.add(bond.getBegin());
            return bond;
        }).forEachOrdered(bond -> atomsMapped.add(bond.getEnd()));
        HashSet<IAtom> atomsToBeRemoved = new HashSet<IAtom>();
        for (IAtom a2 : ac.atoms()) {
            atomsToBeRemoved.add(a2);
        }
        atomsToBeRemoved.removeAll(atomsMapped);
        atomsToBeRemoved.forEach(a -> ac.removeAtom((IAtom)a));
        return ac;
    }

    public void clear() {
        this.g.clear();
    }
}

