/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openscience.smsd.graph.Edge;
import org.openscience.smsd.graph.EdgeType;
import org.openscience.smsd.graph.Vertex;

public final class Graph
implements Iterable<Vertex> {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Map<Vertex, Set<Vertex>> adj;
    private final Map<Vertex, Set<Vertex>> c_adj;
    private final Map<Vertex, Set<Vertex>> d_adj;
    private final Map<EdgeType, Set<Edge>> adj_type_Map;
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public Graph() {
        this.adj = new TreeMap<Vertex, Set<Vertex>>();
        this.c_adj = new TreeMap<Vertex, Set<Vertex>>();
        this.d_adj = new TreeMap<Vertex, Set<Vertex>>();
        this.adj_type_Map = new HashMap<EdgeType, Set<Edge>>();
    }

    public int V() {
        return this.vertices.size();
    }

    public int E() {
        return this.edges().size();
    }

    public Set<Vertex> nodes() {
        HashSet<Vertex> nodes = new HashSet<Vertex>();
        nodes.addAll(this.vertices);
        return nodes;
    }

    public Set<Edge> edges() {
        HashSet<Edge> edgesSet = new HashSet<Edge>();
        this.adj_type_Map.values().forEach(edges -> edgesSet.addAll((Collection<Edge>)edges));
        return edgesSet;
    }

    private void validateVertex(Vertex v) {
        if (!this.vertices.contains(v)) {
            throw new IllegalArgumentException("vertex " + v + " not found in the graph");
        }
    }

    public void addEdge(Vertex v, Vertex u, EdgeType e) {
        this.validateVertex(v);
        this.validateVertex(u);
        Edge edge = new Edge(this.vertices.indexOf(v), this.vertices.indexOf(u));
        edge.setEdgeType(e);
        this.addEdge(edge);
    }

    private void addEdge(Edge e) {
        this.addEdge(this.adj, e);
        if (e.getEdgeType() == EdgeType.C_EDGE) {
            this.addEdge(this.c_adj, e);
        }
        if (e.getEdgeType() == EdgeType.D_EDGE) {
            this.addEdge(this.d_adj, e);
        }
        if (!this.adj_type_Map.containsKey((Object)e.getEdgeType())) {
            this.adj_type_Map.put(e.getEdgeType(), new HashSet());
        }
        this.adj_type_Map.get((Object)e.getEdgeType()).add(e);
    }

    private void addEdge(Map map, Edge e) {
        this.addEdge(map, this.vertices.get(e.getSource()), this.vertices.get(e.getSink()));
        this.addEdge(map, this.vertices.get(e.getSink()), this.vertices.get(e.getSource()));
    }

    private void addEdge(Map<Vertex, Set<Vertex>> map, Vertex u, Vertex v) {
        if (!map.containsKey(u)) {
            map.put(u, new HashSet());
        }
        map.get(u).add(v);
    }

    public void addNode(Vertex node) {
        if (this.adj.containsKey(node)) {
            throw new IllegalArgumentException("Node " + node + " found in the graph");
        }
        this.adj.put(node, new HashSet());
        this.vertices.add(node);
    }

    public Set<Vertex> getNeighbours(Vertex v) {
        this.validateVertex(v);
        return new TreeSet<Vertex>((Collection)this.adj.get(v));
    }

    public int getDegree(Vertex v) {
        this.validateVertex(v);
        return this.adj.get(v).size();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.vertices.size()).append(" vertices, ").append(this.edges().size()).append(" edges ").append(NEWLINE);
        this.adj.entrySet().stream().map(m -> {
            s.append(m.getKey()).append(": ");
            return m;
        }).map(m -> {
            ((Set)m.getValue()).forEach(w -> s.append(w).append(" "));
            return m;
        }).forEachOrdered(_item -> s.append(NEWLINE));
        return s.toString();
    }

    public void clear() {
        this.vertices.clear();
        this.adj.clear();
        this.c_adj.clear();
        this.d_adj.clear();
        this.adj_type_Map.clear();
    }

    public boolean hasEdge(Vertex u, Vertex v) {
        return this.adj.containsKey(u) && this.adj.get(u).contains(v) ? true : this.adj.containsKey(v) && this.adj.get(v).contains(u);
    }

    public Iterable<Edge> edgesOf(Vertex currentVertex) {
        this.validateVertex(currentVertex);
        Integer v = this.vertices.indexOf(currentVertex);
        LinkedHashSet<Edge> edgesOfVertex = new LinkedHashSet<Edge>();
        this.edges().stream().map(e -> {
            if (e.getSource().equals(v)) {
                edgesOfVertex.add((Edge)e);
            }
            return e;
        }).filter(e -> e.getSink().equals(v)).forEachOrdered(e -> edgesOfVertex.add((Edge)e));
        return edgesOfVertex;
    }

    public boolean isCEdge(Vertex u, Vertex v) {
        this.validateVertex(u);
        this.validateVertex(v);
        return this.c_adj.containsKey(u) && this.c_adj.get(u).contains(v) ? true : this.c_adj.containsKey(v) && this.c_adj.get(v).contains(u);
    }

    public boolean isDEdge(Vertex u, Vertex v) {
        this.validateVertex(u);
        this.validateVertex(v);
        return this.d_adj.containsKey(u) && this.d_adj.get(u).contains(v) ? true : this.d_adj.containsKey(v) && this.d_adj.get(v).contains(u);
    }

    public Vertex getEdgeSource(Edge edge) {
        return this.vertices.get(edge.getSource());
    }

    public Vertex getEdgeTarget(Edge edge) {
        return this.vertices.get(edge.getSink());
    }

    public boolean removeVertex(Vertex v) {
        this.adj.keySet().stream().filter(key -> !this.adj.get(key).isEmpty() && this.adj.get(key).contains(v)).forEachOrdered(key -> this.adj.get(key).remove(v));
        this.c_adj.keySet().stream().filter(key -> !this.c_adj.get(key).isEmpty() && this.c_adj.get(key).contains(v)).forEachOrdered(key -> this.c_adj.get(key).remove(v));
        this.d_adj.keySet().stream().filter(key -> !this.d_adj.get(key).isEmpty() && this.d_adj.get(key).contains(v)).forEachOrdered(key -> this.d_adj.get(key).remove(v));
        this.adj_type_Map.entrySet().forEach(c -> ((Set)c.getValue()).stream().filter(e -> this.vertices.get(e.getSource()) == v || this.vertices.get(e.getSink()) == v).forEachOrdered(e -> this.adj_type_Map.get(c.getKey()).remove(e)));
        this.adj.remove(v);
        this.c_adj.remove(v);
        this.d_adj.remove(v);
        return this.vertices.remove(v);
    }

    private Set<Edge> getEdgesOfType(EdgeType e) {
        HashSet<Edge> edgesOfTypes = new HashSet<Edge>();
        if (this.adj_type_Map.containsKey((Object)e)) {
            edgesOfTypes.addAll((Collection<Edge>)this.adj_type_Map.get((Object)e));
        }
        return edgesOfTypes;
    }

    public Set<Vertex> getCEdgeNeighbours(Vertex u) {
        this.validateVertex(u);
        return this.c_adj.containsKey(u) ? new HashSet(this.c_adj.get(u)) : new HashSet();
    }

    @Override
    public Iterator<Vertex> iterator() {
        return this.vertices.iterator();
    }

    public Set<Edge> getCEdges() {
        return this.getEdgesOfType(EdgeType.C_EDGE);
    }

    public Set<Edge> getDEdges() {
        return this.getEdgesOfType(EdgeType.D_EDGE);
    }

    public Vertex resolveVertex(Integer index) {
        if (this.vertices.size() > index) {
            return this.vertices.get(index);
        }
        return null;
    }
}

