/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph;

import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.graph.Multigraph;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class MoleculeAsGraph {
    private MoleculeAsGraph() {
    }

    public static Graph getMoleculeGraph(IAtomContainer molecule, boolean respectBondOrder, boolean respectRing, boolean atomType) {
        int i;
        HashMap<Integer, StringBuilder> vertices = new HashMap<Integer, StringBuilder>();
        Multigraph<StringBuilder, StringBuilder> graph = new Multigraph<StringBuilder, StringBuilder>(StringBuilder.class);
        for (i = 0; i < molecule.getAtomCount(); ++i) {
            IAtom atom = molecule.getAtom(i);
            int id = molecule.indexOf(atom);
            Object label = atomType ? atom.getSymbol() + ":" + atom.getAtomTypeName() : atom.getSymbol();
            StringBuilder node = new StringBuilder((String)label);
            graph.addVertex(node);
            vertices.put(id, node);
        }
        for (i = 0; i < molecule.getBondCount(); ++i) {
            IBond bond = molecule.getBond(i);
            int begin = molecule.indexOf(bond.getBegin());
            int end = molecule.indexOf(bond.getEnd());
            String label = respectBondOrder ? "" + bond.getOrder().numeric() : "" + IBond.Order.UNSET.numeric();
            StringBuilder node = new StringBuilder(label);
            graph.addEdge((StringBuilder)vertices.get(begin), (StringBuilder)vertices.get(end), node);
        }
        return graph;
    }
}

