/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph;

import java.io.Serializable;
import java.util.Comparator;

public class Vertex
implements Comparable<Vertex>,
Comparator<Vertex>,
Serializable {
    private Integer query;
    private Integer target;
    private final int id;
    private String label;

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.id;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return this.id == other.id;
    }

    public String toString() {
        if (this.label.isEmpty()) {
            return "V{id=" + this.id + "(" + this.query + "," + this.target + ")}";
        }
        if (this.query == null) {
            return "V{id=" + this.id + ", label=" + this.label + "}";
        }
        return "V{Q=" + this.query + ", T=" + this.target + ", id=" + this.id + ", label=" + this.label + "}";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Vertex(int node) {
        this.id = node;
        this.label = "";
        this.query = null;
        this.target = null;
    }

    @Override
    public int compareTo(Vertex o) {
        return this.getID() - o.getID();
    }

    @Override
    public int compare(Vertex o1, Vertex o2) {
        return o1.getID() - o2.getID();
    }

    public int getID() {
        return this.id;
    }

    public void setCompatibilityBondPair(Integer a, Integer b) {
        this.query = a;
        this.target = b;
    }

    public Integer getTargetBondIndex() {
        return this.target;
    }

    public Integer getQueryBondIndex() {
        return this.query;
    }
}

