/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.IClique;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.tools.IterationManager;

public class GraphBronKerbosch
implements IClique {
    private static final boolean DEBUG = false;
    private final Collection<Set<Vertex>> cliques;
    IterationManager manager;
    private final Graph graph;

    @Override
    public Stack<Set<Vertex>> getMaxCliquesSet() {
        Stack<Set<Vertex>> maxCliquesSet = new Stack<Set<Vertex>>();
        int best_clique_size = 0;
        for (Set<Vertex> clique : this.cliques) {
            if (clique.size() < best_clique_size) continue;
            if (clique.size() > best_clique_size) {
                while (!maxCliquesSet.empty()) {
                    maxCliquesSet.pop();
                }
                best_clique_size = clique.size();
            }
            if (clique.size() != best_clique_size) continue;
            maxCliquesSet.push(clique);
        }
        return maxCliquesSet;
    }

    @Override
    public Collection<Set<Vertex>> getCliques() {
        return this.cliques;
    }

    public GraphBronKerbosch(Graph comp_graph_nodes) {
        this.graph = comp_graph_nodes;
        this.cliques = new HashSet<Set<Vertex>>();
        int interation = 2 * this.graph.V();
        if (interation > 1000) {
            interation = 1000;
        }
        this.manager = new IterationManager(interation);
    }

    @Override
    public void findMaximalCliques() {
        TreeSet<Vertex> potential_clique_R = new TreeSet<Vertex>();
        TreeSet<Vertex> candidates_P = new TreeSet<Vertex>();
        TreeSet<Vertex> already_found_X = new TreeSet<Vertex>();
        Iterator<Vertex> iterator = this.graph.iterator();
        while (iterator.hasNext()) {
            candidates_P.add(iterator.next());
        }
        int printDepth = 1;
        this.BronKerboschWithPivot(potential_clique_R, candidates_P, already_found_X, printDepth);
    }

    private void BronKerboschWithPivot(TreeSet<Vertex> R, TreeSet<Vertex> P, TreeSet<Vertex> X, int printDepth) {
        if (P.isEmpty() && X.isEmpty()) {
            this.cliques.add(new HashSet<Vertex>(R));
            return;
        }
        if (this.manager.isMaxIteration()) {
            return;
        }
        this.manager.increment();
        TreeSet<Vertex> P1 = new TreeSet<Vertex>((SortedSet<Vertex>)P);
        Vertex u = this.getMaxDegreeVertex(new ArrayList<Vertex>(this.union(P1, X)));
        P1 = new TreeSet<Vertex>(this.removeNeigbour(P1, u));
        for (Vertex v : P1) {
            R.add(v);
            ArrayList<Vertex> neighbors = new ArrayList<Vertex>(this.findNeighbors(v));
            this.BronKerboschWithPivot(R, new TreeSet<Vertex>(this.intersect(P, neighbors)), new TreeSet<Vertex>(this.intersect(X, neighbors)), printDepth + 1);
            R.remove(v);
            P.remove(v);
            X.add(v);
        }
    }

    private void BronKerboschWithoutPivot(TreeSet<Vertex> R, TreeSet<Vertex> P, TreeSet<Vertex> X, int printDepth) {
        if (P.isEmpty() && X.isEmpty()) {
            this.cliques.add(new HashSet<Vertex>(R));
            return;
        }
        Vertex v = null;
        if (!P.isEmpty()) {
            v = P.first();
        }
        while (!P.isEmpty() && v != P.last()) {
            R.add(v);
            ArrayList<Vertex> neighbors = new ArrayList<Vertex>(this.findNeighbors(v));
            this.BronKerboschWithoutPivot(R, new TreeSet<Vertex>(this.intersect(P, neighbors)), new TreeSet<Vertex>(this.intersect(X, neighbors)), printDepth + 1);
            P.remove(v);
            X.add(v);
            if (P.isEmpty()) continue;
            v = P.first();
        }
    }

    private Vertex getMaxDegreeVertex(List<Vertex> t) {
        int temp = 0;
        Vertex n = null;
        for (int i = 0; i < t.size(); ++i) {
            int degreeVertex = this.getDegreeVertex(t.get(i));
            if (degreeVertex <= temp) continue;
            temp = degreeVertex;
            n = t.get(i);
        }
        return n;
    }

    private void BronKerbosch(TreeSet<Vertex> R, TreeSet<Vertex> P, TreeSet<Vertex> X) {
        TreeSet<Vertex> candidates_array = new TreeSet<Vertex>((SortedSet<Vertex>)P);
        if (!this.end(P, X)) {
            candidates_array.stream().map(candidate -> {
                TreeSet<Vertex> new_candidates = new TreeSet<Vertex>();
                TreeSet<Vertex> new_already_found = new TreeSet<Vertex>();
                R.add((Vertex)candidate);
                P.remove(candidate);
                P.stream().filter(new_candidate -> this.isNeighbor((Vertex)candidate, (Vertex)new_candidate)).forEachOrdered(new_candidate -> new_candidates.add((Vertex)new_candidate));
                X.stream().filter(new_found -> this.isNeighbor((Vertex)candidate, (Vertex)new_found)).forEachOrdered(new_found -> new_already_found.add((Vertex)new_found));
                if (new_candidates.isEmpty() && new_already_found.isEmpty()) {
                    this.cliques.add(new HashSet(R));
                } else {
                    this.BronKerbosch(R, new_candidates, new_already_found);
                }
                X.add((Vertex)candidate);
                return candidate;
            }).forEachOrdered(candidate -> R.remove(candidate));
        }
    }

    private boolean end(TreeSet<Vertex> candidates, TreeSet<Vertex> already_found) {
        boolean end = false;
        for (Vertex found : already_found) {
            int edgecounter = 0;
            edgecounter = candidates.stream().filter(candidate -> this.isNeighbor(found, (Vertex)candidate)).map(_item -> 1).reduce(edgecounter, Integer::sum);
            if (edgecounter != candidates.size()) continue;
            end = true;
        }
        return end;
    }

    private int getDegreeVertex(Vertex node) {
        return this.graph.getDegree(node);
    }

    private Set<Vertex> findNeighbors(Vertex central_node) {
        Set<Vertex> allNeighbours = this.graph.getNeighbours(central_node);
        return allNeighbours;
    }

    private Collection<Vertex> intersect(Collection<Vertex> source, Collection<Vertex> sink) {
        HashSet<Vertex> intersection = new HashSet<Vertex>(source);
        intersection.retainAll(sink);
        return intersection;
    }

    private Collection<Vertex> union(Collection<Vertex> source, Collection<Vertex> sink) {
        HashSet<Vertex> union = new HashSet<Vertex>(source);
        union.addAll(sink);
        return union;
    }

    private Collection<Vertex> removeNeigbour(Collection<Vertex> source, Vertex v) {
        HashSet<Vertex> remaining = new HashSet<Vertex>(source);
        remaining.removeAll(this.findNeighbors(v));
        return remaining;
    }

    private static String toText(Collection<Vertex> solution, String start, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        solution.forEach(i -> sb.append(i).append(","));
        sb.append(end);
        return sb.toString();
    }

    private static String addSpacer(int s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    private void printClique(Collection<Vertex> R) {
        System.out.print("Clique Set R=[");
        R.forEach(v -> System.out.print(" " + v + ","));
        System.out.print(" ]\n");
    }

    private boolean isNeighbor(Vertex found, Vertex candidate) {
        return this.graph.hasEdge(found, candidate);
    }
}

