/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.openscience.smsd.graph.Edge;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.IClique;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.tools.IterationManager;

public class GraphKoch
implements IClique {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    private final Collection<Set<Vertex>> cliques;
    private final Graph graph;
    IterationManager manager;

    @Override
    public Collection<Set<Vertex>> getCliques() {
        return this.cliques;
    }

    @Override
    public Stack<Set<Vertex>> getMaxCliquesSet() {
        Stack<Set<Vertex>> maxCliquesSet = new Stack<Set<Vertex>>();
        int best_clique_size = 0;
        for (Set<Vertex> clique : this.cliques) {
            if (clique.size() < best_clique_size) continue;
            if (clique.size() > best_clique_size) {
                while (!maxCliquesSet.empty()) {
                    maxCliquesSet.pop();
                }
                best_clique_size = clique.size();
            }
            if (clique.size() != best_clique_size) continue;
            maxCliquesSet.push(new TreeSet<Vertex>(clique));
        }
        return maxCliquesSet;
    }

    public GraphKoch(Graph compatibilityGraph) {
        this.graph = compatibilityGraph;
        this.cliques = new HashSet<Set<Vertex>>();
        int interation = this.graph.V() * 100;
        if (interation > 50000) {
            interation = 50000;
        }
        this.manager = new IterationManager(interation);
    }

    @Override
    public void findMaximalCliques() {
        Set<Object> result = new LinkedHashSet();
        int currentmaxresult = 0;
        LinkedHashSet<Vertex> T = new LinkedHashSet<Vertex>();
        for (Vertex u : this.graph.nodes()) {
            if (this.manager.isMaxIteration()) {
                return;
            }
            LinkedHashSet<Vertex> P = new LinkedHashSet<Vertex>();
            LinkedHashSet<Vertex> D = new LinkedHashSet<Vertex>();
            LinkedHashSet<Vertex> S = new LinkedHashSet<Vertex>();
            Set<Vertex> N = this.findNeighbors(u);
            for (Vertex v : N) {
                if (this.isCEdge(u, v)) {
                    if (T.contains(v)) {
                        S.add(v);
                        continue;
                    }
                    P.add(v);
                    continue;
                }
                if (!this.isDEdge(u, v)) continue;
                D.add(v);
            }
            LinkedHashSet<Vertex> C2 = new LinkedHashSet<Vertex>();
            C2.add(u);
            Set<Vertex> subresult = this.Enumerate_C_Cliques(C2, P, D, currentmaxresult);
            if (subresult != null && subresult.size() >= result.size()) {
                result = subresult;
                currentmaxresult = result.size();
                this.cliques.add(result);
            }
            T.add(u);
        }
    }

    private Set<Vertex> enumerateCliques(Set<Vertex> C2, Set<Vertex> P, int currentmaxresult) {
        Set<Vertex> result = new LinkedHashSet<Vertex>(C2);
        if (this.manager.isMaxIteration()) {
            return result;
        }
        this.manager.increment();
        if (P.isEmpty() || P.size() + C2.size() <= currentmaxresult) {
            return result;
        }
        ArrayList<Vertex> P_Copy = new ArrayList<Vertex>(P);
        Vertex ut = (Vertex)P_Copy.get(0);
        for (Vertex currentVertex : P) {
            if (this.graph.hasEdge(ut, currentVertex)) continue;
            P_Copy.remove(currentVertex);
            LinkedHashSet<Vertex> P_Prime = new LinkedHashSet<Vertex>(P_Copy);
            LinkedHashSet<Vertex> N = new LinkedHashSet<Vertex>();
            for (Edge edge : this.graph.edgesOf(currentVertex)) {
                Vertex neighbour = this.graph.getEdgeSource(edge);
                if (neighbour.equals(currentVertex)) {
                    neighbour = this.graph.getEdgeTarget(edge);
                }
                N.add(neighbour);
            }
            LinkedHashSet<Vertex> C_Copy = new LinkedHashSet<Vertex>(C2);
            C_Copy.add(currentVertex);
            P_Prime.retainAll(N);
            Set<Vertex> clique = this.enumerateCliques(C_Copy, P_Prime, currentmaxresult);
            if (clique.size() <= result.size()) continue;
            result = clique;
            currentmaxresult = clique.size();
        }
        return result;
    }

    private Set<Vertex> Enumerate_C_Cliques(Set<Vertex> C2, Set<Vertex> P, Set<Vertex> D, int currentmaxresult) {
        Set<Vertex> result = new LinkedHashSet<Vertex>(C2);
        if (this.manager.isMaxIteration()) {
            return result;
        }
        this.manager.increment();
        if (P.isEmpty() || P.size() + C2.size() + D.size() <= currentmaxresult) {
            return result;
        }
        LinkedHashSet<Vertex> P_Copy = new LinkedHashSet<Vertex>(P);
        for (Vertex ui : P) {
            P_Copy.remove(ui);
            LinkedHashSet<Vertex> P_Prime = new LinkedHashSet<Vertex>(P_Copy);
            LinkedHashSet<Vertex> D_Prime = new LinkedHashSet<Vertex>(D);
            Set<Vertex> N = this.findNeighbors(ui);
            D.stream().filter(v -> this.isCEdge(ui, (Vertex)v)).map(v -> {
                P_Prime.add((Vertex)v);
                return v;
            }).forEachOrdered(v -> D_Prime.remove(v));
            LinkedHashSet<Vertex> C_Copy = new LinkedHashSet<Vertex>(C2);
            C_Copy.add(ui);
            P_Prime.retainAll(N);
            D_Prime.retainAll(N);
            Set<Vertex> clique = this.Enumerate_C_Cliques(C_Copy, P_Prime, D_Prime, currentmaxresult);
            if (clique == null || clique.size() <= result.size()) continue;
            result = clique;
            currentmaxresult = clique.size();
        }
        return result;
    }

    private Set<Vertex> Enumerate_C_Cliques_Complex(Set<Vertex> C2, Set<Vertex> P, Set<Vertex> D, Set<Vertex> T, int currentmaxresult) {
        Set<Vertex> result = new LinkedHashSet<Vertex>(C2);
        if (this.manager.isMaxIteration()) {
            return result;
        }
        this.manager.increment();
        if (P.isEmpty() || P.size() + C2.size() + D.size() <= currentmaxresult) {
            return result;
        }
        LinkedHashSet<Vertex> P_Copy = new LinkedHashSet<Vertex>(P);
        Vertex ut = (Vertex)P_Copy.iterator().next();
        for (Vertex ui : P) {
            LinkedHashSet<Vertex> target = new LinkedHashSet<Vertex>(D);
            target.removeAll(this.findNeighbors(ut));
            if (this.graph.hasEdge(ut, ui) && !this.hasCPath(ui, target, new LinkedHashSet<Vertex>())) continue;
            P_Copy.remove(ui);
            LinkedHashSet<Vertex> P_Prime = new LinkedHashSet<Vertex>(P_Copy);
            LinkedHashSet<Vertex> D_Prime = new LinkedHashSet<Vertex>(D);
            Set<Vertex> N = this.findNeighbors(ui);
            D.forEach(v -> {
                if (P.contains(v)) {
                    P_Prime.add((Vertex)v);
                } else if (D.contains(v) && this.isCEdge(ui, (Vertex)v)) {
                    if (T.contains(v)) {
                        P_Prime.add((Vertex)v);
                    }
                    D_Prime.remove(v);
                }
            });
            LinkedHashSet<Vertex> C_Copy = new LinkedHashSet<Vertex>(C2);
            C_Copy.add(ui);
            P_Prime.retainAll(N);
            D_Prime.retainAll(N);
            Set<Vertex> clique = this.Enumerate_C_Cliques_Complex(C_Copy, P_Prime, D_Prime, T, currentmaxresult);
            if (clique.size() <= result.size()) continue;
            result = clique;
            currentmaxresult = clique.size();
        }
        return result;
    }

    private boolean isCEdge(Vertex u, Vertex v) {
        return this.graph.isCEdge(u, v);
    }

    private boolean isDEdge(Vertex u, Vertex v) {
        return this.graph.isDEdge(u, v);
    }

    private Set<Vertex> findNeighbors(Vertex central_node) {
        Set<Vertex> allNeighbours = this.graph.getNeighbours(central_node);
        return allNeighbours;
    }

    private boolean hasCPath(Vertex source, Set<Vertex> target, Set<Vertex> exclude) {
        if (target.stream().anyMatch(v -> this.isCEdge(source, (Vertex)v))) {
            return true;
        }
        boolean result = false;
        exclude.add(source);
        Set<Vertex> neighbours = this.neighbourCVertices(source);
        neighbours.removeAll(exclude);
        result = neighbours.stream().map(neighbour -> this.hasCPath((Vertex)neighbour, target, exclude)).reduce(result, (accumulator, _item) -> accumulator | _item);
        return result;
    }

    private Set<Vertex> neighbourCVertices(Vertex u) {
        Set<Vertex> allNeighbours = this.graph.getCEdgeNeighbours(u);
        return allNeighbours;
    }
}

