/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.graph.algorithm;

import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.graph.EdgeProductGraph;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.graph.algorithm.GraphKoch;

public class MCSAlgorithm {
    private static final boolean DEBUG = false;

    public static IAtomContainer koch(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws IOException, CloneNotSupportedException, CDKException {
        EdgeProductGraph compatibilityGraph = EdgeProductGraph.create(source, target, am, bm);
        compatibilityGraph.searchCliques();
        boolean disconnected = ConnectivityChecker.isConnected(source) && ConnectivityChecker.isConnected(target);
        GraphKoch graphKoch = new GraphKoch(compatibilityGraph.getCompatibilityGraph());
        graphKoch.findMaximalCliques();
        Stack<Set<Vertex>> maxCliquesSet = graphKoch.getMaxCliquesSet();
        if (maxCliquesSet == null || maxCliquesSet.isEmpty()) {
            return null;
        }
        return compatibilityGraph.toQuerySubgraph(maxCliquesSet.peek());
    }
}

