/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.helper;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class BondEnergy {
    private final String symbol1;
    private final String symbol2;
    private final IBond.Order bondOrder;
    private int energy = -1;

    public BondEnergy(String symbol1, String symbol2, IBond.Order order, int energy) {
        this.symbol1 = symbol1;
        this.symbol2 = symbol2;
        this.bondOrder = order;
        this.energy = energy;
    }

    public synchronized String getSymbolFirstAtom() {
        return this.symbol1;
    }

    public synchronized String getSymbolSecondAtom() {
        return this.symbol2;
    }

    public synchronized IBond.Order getBondOrder() {
        return this.bondOrder;
    }

    public synchronized int getEnergy() {
        return this.energy;
    }

    public synchronized boolean matches(IBond bond) {
        IAtom atom1 = bond.getAtom(0);
        IAtom atom2 = bond.getAtom(1);
        return (atom1.getSymbol().equalsIgnoreCase(this.symbol1) && atom2.getSymbol().equalsIgnoreCase(this.symbol2) || atom1.getSymbol().equalsIgnoreCase(this.symbol2) && atom2.getSymbol().equalsIgnoreCase(this.symbol1)) && bond.getOrder().compareTo(this.bondOrder) == 0;
    }
}

