/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.helper;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public final class Mappings
implements Iterable<int[]> {
    private final Iterable<int[]> iterable;
    private IAtomContainer query;
    private IAtomContainer target;

    public Mappings(IAtomContainer query2, IAtomContainer target, Iterable<int[]> iterable) {
        this.query = query2;
        this.target = target;
        this.iterable = iterable;
    }

    public Mappings filter(Predicate<int[]> predicate) {
        return new Mappings(this.query, this.target, Iterables.filter(this.iterable, predicate));
    }

    public <T> Iterable<T> map(Function<int[], T> f) {
        return Iterables.transform(this.iterable, f);
    }

    public Mappings limit(int limit) {
        return new Mappings(this.query, this.target, Iterables.limit(this.iterable, limit));
    }

    public Mappings uniqueAtoms() {
        return new Mappings(this.query, this.target, new Iterable<int[]>(){

            @Override
            public Iterator<int[]> iterator() {
                return Iterators.filter(Mappings.this.iterable.iterator(), new UniqueAtomMatches());
            }
        });
    }

    public Mappings uniqueBonds() {
        final int[][] g = GraphUtil.toAdjList(this.query);
        return new Mappings(this.query, this.target, new Iterable<int[]>(){

            @Override
            public Iterator<int[]> iterator() {
                return Iterators.filter(Mappings.this.iterable.iterator(), new UniqueBondMatches(g));
            }
        });
    }

    public int[][] toArray() {
        return Iterables.toArray(this.iterable, int[].class);
    }

    public Iterable<Map<IAtom, IAtom>> toAtomMap() {
        return this.map(new ToAtomMap(this.query, this.target));
    }

    public Iterable<Map<IBond, IBond>> toBondMap() {
        return this.map(new ToBondMap(this.query, this.target));
    }

    public Iterable<Map<IChemObject, IChemObject>> toAtomBondMap() {
        return this.map(new ToAtomBondMap(this.query, this.target));
    }

    public Iterable<IChemObject> toChemObjects() {
        return FluentIterable.from(this.map(new ToAtomBondMap(this.query, this.target))).transformAndConcat(new Function<Map<IChemObject, IChemObject>, Iterable<? extends IChemObject>>(){

            @Override
            public Iterable<? extends IChemObject> apply(Map<IChemObject, IChemObject> map) {
                return map.values();
            }
        });
    }

    public Iterable<IAtomContainer> toSubstructures() {
        return FluentIterable.from(this.map(new ToAtomBondMap(this.query, this.target))).transform(new Function<Map<IChemObject, IChemObject>, IAtomContainer>(){

            @Override
            public IAtomContainer apply(Map<IChemObject, IChemObject> map) {
                IAtomContainer submol = Mappings.this.target.getBuilder().newInstance(IAtomContainer.class, Mappings.this.query.getAtomCount(), Mappings.this.target.getBondCount(), 0, 0);
                for (IAtom atom : Mappings.this.query.atoms()) {
                    submol.addAtom((IAtom)map.get(atom));
                }
                for (IBond bond : Mappings.this.query.bonds()) {
                    submol.addBond((IBond)map.get(bond));
                }
                return submol;
            }
        });
    }

    public boolean atLeast(int n) {
        return this.limit(n).count() == n;
    }

    public int[] first() {
        return Iterables.getFirst(this.iterable, new int[0]);
    }

    public int count() {
        return Iterables.size(this.iterable);
    }

    public int countUnique() {
        return this.uniqueAtoms().count();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.iterable.iterator();
    }

    private final class ToAtomMap
    implements Function<int[], Map<IAtom, IAtom>> {
        private final IAtomContainer query;
        private final IAtomContainer target;

        private ToAtomMap(IAtomContainer query2, IAtomContainer target) {
            this.query = query2;
            this.target = target;
        }

        @Override
        public Map<IAtom, IAtom> apply(int[] mapping) {
            ImmutableMap.Builder<IAtom, IAtom> map = ImmutableMap.builder();
            for (int i = 0; i < mapping.length; ++i) {
                map.put(this.query.getAtom(i), this.target.getAtom(mapping[i]));
            }
            return map.build();
        }
    }

    private final class ToBondMap
    implements Function<int[], Map<IBond, IBond>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToBondMap(IAtomContainer query2, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
            this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
            GraphUtil.toAdjList(target, this.bonds2);
        }

        @Override
        public Map<IBond, IBond> apply(int[] mapping) {
            ImmutableMap.Builder<IBond, IBond> map = ImmutableMap.builder();
            for (int u = 0; u < this.g1.length; ++u) {
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put(this.bonds1.get(u, v), this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return map.build();
        }
    }

    private final class ToAtomBondMap
    implements Function<int[], Map<IChemObject, IChemObject>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToAtomBondMap(IAtomContainer query2, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
            this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
            GraphUtil.toAdjList(target, this.bonds2);
        }

        @Override
        public Map<IChemObject, IChemObject> apply(int[] mapping) {
            ImmutableMap.Builder<IChemObject, IChemObject> map = ImmutableMap.builder();
            for (int u = 0; u < this.g1.length; ++u) {
                map.put(Mappings.this.query.getAtom(u), Mappings.this.target.getAtom(mapping[u]));
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put(this.bonds1.get(u, v), this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return map.build();
        }
    }

    final class UniqueBondMatches
    implements Predicate<int[]> {
        private final Set<Set<Tuple>> unique;
        private final int[][] g;

        private UniqueBondMatches(int[][] g, int expectedHits) {
            this.unique = Sets.newHashSetWithExpectedSize(expectedHits);
            this.g = g;
        }

        public UniqueBondMatches(int[][] g) {
            this(g, 10);
        }

        @Override
        public boolean apply(int[] input) {
            return this.unique.add(this.toEdgeSet(input));
        }

        private Set<Tuple> toEdgeSet(int[] mapping) {
            HashSet<Tuple> edges = new HashSet<Tuple>(mapping.length * 2);
            for (int u = 0; u < this.g.length; ++u) {
                for (int v : this.g[u]) {
                    edges.add(new Tuple(mapping[u], mapping[v]));
                }
            }
            return edges;
        }

        private final class Tuple {
            final int u;
            final int v;

            private Tuple(int u, int v) {
                this.u = u;
                this.v = v;
            }

            public int hashCode() {
                return this.u ^ this.v;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Tuple that = (Tuple)o;
                return this.u == that.u && this.v == that.v || this.u == that.v && this.v == that.u;
            }
        }
    }

    final class UniqueAtomMatches
    implements Predicate<int[]> {
        private final Set<BitSet> unique;

        private UniqueAtomMatches(int expectedHits) {
            this.unique = Sets.newHashSetWithExpectedSize(expectedHits);
        }

        public UniqueAtomMatches() {
            this(10);
        }

        @Override
        public boolean apply(int[] input) {
            return this.unique.add(this.toBitSet(input));
        }

        private BitSet toBitSet(int[] mapping) {
            BitSet hits = new BitSet();
            for (int v : mapping) {
                hits.set(v);
            }
            return hits;
        }
    }
}

