/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MoleculeInitializer {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MoleculeInitializer.class);

    public static synchronized void initializeMolecule(IAtomContainer atomContainer) throws CDKException {
        if (atomContainer == null) {
            return;
        }
        try {
            try {
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                ExtAtomContainerManipulator.aromatizeCDK(atomContainer);
            }
            catch (CDKException e) {
                ExtAtomContainerManipulator.aromatizeDayLight(atomContainer);
            }
        }
        catch (CDKException e) {
            LOGGER.error(Level.WARNING, "Error in aromaticity dectection. ", atomContainer.getID());
        }
        String SMALLEST_RING_SIZE = "SMALLEST_RING_SIZE";
        if (!(atomContainer instanceof IQueryAtomContainer)) {
            HashMap<String, Integer> valencesTable = new HashMap<String, Integer>();
            valencesTable.put("H", 1);
            valencesTable.put("Li", 1);
            valencesTable.put("Be", 2);
            valencesTable.put("B", 3);
            valencesTable.put("C", 4);
            valencesTable.put("N", 5);
            valencesTable.put("O", 6);
            valencesTable.put("F", 7);
            valencesTable.put("Na", 1);
            valencesTable.put("Mg", 2);
            valencesTable.put("Al", 3);
            valencesTable.put("Si", 4);
            valencesTable.put("P", 5);
            valencesTable.put("S", 6);
            valencesTable.put("Cl", 7);
            valencesTable.put("K", 1);
            valencesTable.put("Ca", 2);
            valencesTable.put("Ga", 3);
            valencesTable.put("Ge", 4);
            valencesTable.put("As", 5);
            valencesTable.put("Se", 6);
            valencesTable.put("Br", 7);
            valencesTable.put("Rb", 1);
            valencesTable.put("Sr", 2);
            valencesTable.put("In", 3);
            valencesTable.put("Sn", 4);
            valencesTable.put("Sb", 5);
            valencesTable.put("Te", 6);
            valencesTable.put("I", 7);
            valencesTable.put("Cs", 1);
            valencesTable.put("Ba", 2);
            valencesTable.put("Tl", 3);
            valencesTable.put("Pb", 4);
            valencesTable.put("Bi", 5);
            valencesTable.put("Po", 6);
            valencesTable.put("At", 7);
            valencesTable.put("Fr", 1);
            valencesTable.put("Ra", 2);
            valencesTable.put("Cu", 2);
            valencesTable.put("Mn", 2);
            valencesTable.put("Co", 2);
            IRingSet allRings = null;
            CycleFinder cycleFinder = Cycles.or(Cycles.all(), Cycles.or(Cycles.relevant(), Cycles.essential()));
            Cycles cycles = cycleFinder.find(atomContainer);
            allRings = cycles.toRingSet();
            RingSetManipulator.markAromaticRings(allRings);
            CycleFinder cf = Cycles.essential();
            cycles = cf.find(atomContainer);
            IRingSet sssr = cycles.toRingSet();
            for (IAtom atom : atomContainer.atoms()) {
                if (atom == null) continue;
                if (allRings != null && allRings.contains(atom)) {
                    atom.setIsInRing(true);
                    atom.setIsAromatic(true);
                    atom.setFlag(2, true);
                    atom.setFlag(8, false);
                    ArrayList<Integer> ringsizes = new ArrayList<Integer>();
                    IRingSet currentRings = allRings.getRings(atom);
                    int min = 0;
                    for (int i = 0; i < currentRings.getAtomContainerCount(); ++i) {
                        int size = currentRings.getAtomContainer(i).getAtomCount();
                        if (min > size) {
                            min = size;
                        }
                        ringsizes.add(size);
                    }
                    Collections.sort(ringsizes);
                    atom.setProperty("cdk:RingSizes", ringsizes);
                    atom.setProperty("cdk:SmallestRings", sssr.getRings(atom));
                    atom.setProperty(SMALLEST_RING_SIZE, min);
                } else {
                    atom.setIsInRing(false);
                    atom.setIsAromatic(false);
                    atom.setFlag(2, false);
                    atom.setFlag(8, true);
                    atom.setProperty(SMALLEST_RING_SIZE, 0);
                }
                int hCount = Objects.equals(atom.getImplicitHydrogenCount(), CDKConstants.UNSET) ? 0 : atom.getImplicitHydrogenCount();
                List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
                int total = hCount + connectedAtoms.size();
                hCount = connectedAtoms.stream().filter(connectedAtom -> connectedAtom.getSymbol().equals("H")).map(_item -> 1).reduce(hCount, Integer::sum);
                atom.setProperty("cdk:TotalConnections", total);
                atom.setProperty("cdk:TotalHydrogenCount", hCount);
                if (valencesTable.get(atom.getSymbol()) == null) continue;
                int formalCharge = Objects.equals(atom.getFormalCharge(), CDKConstants.UNSET) ? 0 : atom.getFormalCharge();
                atom.setValency((Integer)valencesTable.get(atom.getSymbol()) - formalCharge);
            }
            for (IBond bond : atomContainer.bonds()) {
                if (allRings != null && allRings.getRings(bond).getAtomContainerCount() > 0) {
                    bond.setFlag(2, true);
                    bond.setFlag(8, false);
                    bond.setIsInRing(true);
                    bond.setIsAromatic(true);
                    continue;
                }
                bond.setIsInRing(false);
                bond.setIsAromatic(false);
            }
            for (IAtom atom : atomContainer.atoms()) {
                List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
                int counter = 0;
                for (IAtom connectedAtom2 : connectedAtoms) {
                    IAtom any = connectedAtom2;
                    if (!any.getFlag(2)) continue;
                    ++counter;
                }
                atom.setProperty("cdk:RingConnections", counter);
            }
            ExtAtomContainerManipulator.aromatizeMolecule(atomContainer);
        }
    }

    public static boolean testIsSubgraphHeuristics(IAtomContainer q, IAtomContainer t) {
        String hyb;
        ArrayList<String> atomUniqueCounter1 = new ArrayList<String>();
        ArrayList<String> atomUniqueCounter2 = new ArrayList<String>();
        for (IAtom a : q.atoms()) {
            hyb = a.getHybridization() == CDKConstants.UNSET ? a.getSymbol() : a.getAtomTypeName();
            atomUniqueCounter1.add(hyb);
        }
        for (IAtom b : t.atoms()) {
            hyb = b.getHybridization() == CDKConstants.UNSET ? b.getSymbol() : b.getAtomTypeName();
            atomUniqueCounter2.add(hyb);
        }
        Collections.sort(atomUniqueCounter1);
        Collections.sort(atomUniqueCounter2);
        if (atomUniqueCounter1.isEmpty()) {
            return false;
        }
        LinkedList common = new LinkedList(atomUniqueCounter1);
        common.retainAll(atomUniqueCounter2);
        atomUniqueCounter1.clear();
        atomUniqueCounter2.clear();
        return common.size() == atomUniqueCounter1.size() ? true : common.size() == atomUniqueCounter2.size();
    }

    public static synchronized boolean testIsSubgraphHeuristics(IAtomContainer ac1, IAtomContainer ac2, AtomMatcher am, BondMatcher bm) {
        int val;
        IAtom atom;
        int i;
        boolean ac1SingleBondCount = false;
        boolean ac1DoubleBondCount = false;
        boolean ac1TripleBondCount = false;
        boolean ac1AromaticBondCount = false;
        boolean ac2SingleBondCount = false;
        boolean ac2DoubleBondCount = false;
        boolean ac2TripleBondCount = false;
        boolean ac2AromaticBondCount = false;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < ac1.getAtomCount(); ++i) {
            atom = ac1.getAtom(i);
            if (atom == null || atom instanceof IQueryAtom) continue;
            if (map.containsKey(atom.getSymbol())) {
                val = (Integer)map.get(atom.getSymbol()) + 1;
                map.put(atom.getSymbol(), val);
                continue;
            }
            map.put(atom.getSymbol(), 1);
        }
        for (i = 0; i < ac2.getAtomCount(); ++i) {
            atom = ac2.getAtom(i);
            if (!map.containsKey(atom.getSymbol())) continue;
            val = (Integer)map.get(atom.getSymbol()) - 1;
            if (val > 0) {
                map.put(atom.getSymbol(), val);
                continue;
            }
            map.remove(atom.getSymbol());
        }
        return map.isEmpty();
    }
}

