/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.mcss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.mcss.JobType;
import org.openscience.smsd.mcss.MCSSThread;
import org.openscience.smsd.tools.AtomContainerComparator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MCSS {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSS.class);
    private final Collection<IAtomContainer> calculateMCSS;
    final AtomMatcher am;
    final BondMatcher bm;

    public MCSS(List<IAtomContainer> jobList, JobType jobType, int numberOfThreads) {
        this(jobList, jobType, numberOfThreads, AtomBondMatcher.atomMatcher(true, true), AtomBondMatcher.bondMatcher(true, true));
    }

    public MCSS(List<IAtomContainer> jobList, JobType jobType, int numberOfThreads, AtomMatcher am, BondMatcher bm) {
        this.am = am;
        this.bm = bm;
        int threadsAvailable = Runtime.getRuntime().availableProcessors() - 1;
        LOGGER.debug("Demand threads: " + numberOfThreads);
        LOGGER.debug(", Available threads: " + threadsAvailable);
        if (numberOfThreads > 0 && threadsAvailable >= numberOfThreads) {
            threadsAvailable = numberOfThreads;
        } else if (threadsAvailable <= 0) {
            threadsAvailable = 1;
        }
        LOGGER.debug(", Assigned threads: " + threadsAvailable + NEW_LINE);
        ArrayList<IAtomContainer> selectedJobs = new ArrayList<IAtomContainer>(jobList.size());
        jobList.stream().forEach(ac -> selectedJobs.add(ExtAtomContainerManipulator.removeHydrogens(ac)));
        AtomContainerComparator comparator = new AtomContainerComparator();
        Collections.sort(selectedJobs, comparator);
        this.calculateMCSS = this.calculateMCSS(selectedJobs, jobType, threadsAvailable);
        selectedJobs.clear();
    }

    private synchronized Collection<IAtomContainer> calculateMCSS(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        IAtomContainer inTheList;
        LinkedList<IAtomContainer> newMCSSList;
        if (nThreads == 1) {
            newMCSSList = new LinkedList<IAtomContainer>(this.submitSingleThreadedJob(mcssList, jobType, nThreads));
        } else {
            newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(mcssList, jobType, nThreads));
            while (newMCSSList.size() > 1) {
                if (newMCSSList.size() > 2) {
                    newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(newMCSSList, jobType, nThreads));
                    continue;
                }
                newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(newMCSSList, jobType, 1));
            }
        }
        if (!mcssList.isEmpty() && !newMCSSList.isEmpty() && (inTheList = mcssList.get(mcssList.size() - 1)) == newMCSSList.iterator().next()) {
            return new LinkedBlockingQueue<IAtomContainer>();
        }
        return newMCSSList;
    }

    public synchronized Collection<IAtomContainer> getCalculateMCSS() {
        return Collections.unmodifiableCollection(this.calculateMCSS);
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> submitSingleThreadedJob(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        LinkedBlockingQueue<IAtomContainer> solutions = new LinkedBlockingQueue<IAtomContainer>();
        MCSSThread task = new MCSSThread(mcssList, jobType, 1);
        Object results = task.call();
        if (results != null) {
            solutions.addAll((Collection<IAtomContainer>)results);
        }
        return solutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LinkedBlockingQueue<IAtomContainer> submitMultiThreadedJob(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        int taskNumber = 1;
        LinkedBlockingQueue<IAtomContainer> solutions = new LinkedBlockingQueue<IAtomContainer>();
        LinkedBlockingQueue<MCSSThread> callablesQueue = new LinkedBlockingQueue<MCSSThread>();
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        int step = (int)Math.ceil(mcssList.size() / nThreads);
        if (step < 2) {
            step = 2;
        }
        for (int i = 0; i < mcssList.size(); i += step) {
            ArrayList<IAtomContainer> subList;
            int endPoint = i + step;
            if (endPoint > mcssList.size()) {
                endPoint = mcssList.size();
            }
            if ((subList = new ArrayList<IAtomContainer>(mcssList.subList(i, endPoint))).size() > 1) {
                MCSSThread mcssJobThread = new MCSSThread(subList, jobType, taskNumber, this.am, this.bm);
                callablesQueue.add(mcssJobThread);
                ++taskNumber;
                continue;
            }
            solutions.add((IAtomContainer)subList.get(0));
        }
        try {
            List futureList = threadPool.invokeAll(callablesQueue);
            for (Future callable : futureList) {
                LinkedBlockingQueue mapping = (LinkedBlockingQueue)callable.get();
                if (callable.isDone() && mapping != null) {
                    solutions.addAll(mapping);
                    continue;
                }
                LOGGER.warn("WARNING: InComplete job in AtomMappingTool: ");
            }
            threadPool.shutdown();
            while (!threadPool.isTerminated()) {
            }
            System.gc();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
            LOGGER.error(e);
        }
        finally {
            threadPool.shutdown();
        }
        return solutions;
    }

    public synchronized String getTitle() {
        return "Calculating Maximum Commmon Substrutures (MCSS) using SMSD";
    }
}

