/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.mcss;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.mcss.Fragment;
import org.openscience.smsd.mcss.JobType;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MCSSThread
implements Callable<LinkedBlockingQueue<IAtomContainer>> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSSThread.class);
    private final List<IAtomContainer> mcssList;
    private final JobType jobType;
    private final int taskNumber;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    public MCSSThread(List<IAtomContainer> mcssList, JobType jobType, int taskNumber) {
        this(mcssList, jobType, taskNumber, AtomBondMatcher.atomMatcher(true, true), AtomBondMatcher.bondMatcher(true, true));
    }

    public MCSSThread(List<IAtomContainer> mcssList, JobType jobType, int taskNumber, AtomMatcher am, BondMatcher bm) {
        this.mcssList = mcssList;
        this.jobType = jobType;
        this.taskNumber = taskNumber;
        this.atomMatcher = am;
        this.bondMatcher = bm;
    }

    @Override
    public synchronized LinkedBlockingQueue<IAtomContainer> call() {
        if (this.jobType.equals(JobType.MULTIPLE)) {
            return this.multiSolution();
        }
        return this.singleSolution();
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> multiSolution() {
        LinkedBlockingQueue<IAtomContainer> mcss = new LinkedBlockingQueue<IAtomContainer>();
        LOGGER.debug("Calling MCSSTask " + this.taskNumber + " with " + this.mcssList.size() + " items");
        long startTime = Calendar.getInstance().getTimeInMillis();
        IAtomContainer querySeed = this.mcssList.get(0);
        long calcTime = startTime;
        ConcurrentLinkedQueue<IAtomContainer> seeds = new ConcurrentLinkedQueue<IAtomContainer>();
        try {
            TreeSet<Fragment> localSeeds = new TreeSet<Fragment>();
            int minSeedSize = querySeed.getAtomCount();
            for (int index = 1; index < this.mcssList.size(); ++index) {
                IAtomContainer target = this.mcssList.get(index);
                Isomorphism comparison = new Isomorphism(querySeed, target, Algorithm.DEFAULT, this.atomMatcher, this.bondMatcher);
                comparison.setChemFilters(true, true, true);
                Collection<Fragment> fragmentsFromMCS = this.getMCSS(comparison);
                LOGGER.debug("comparison for task " + this.taskNumber + " has " + fragmentsFromMCS.size() + " unique matches of size " + comparison.getFirstAtomMapping().getCount());
                LOGGER.debug("MCSS for task " + this.taskNumber + " has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
                LOGGER.debug("Target for task " + this.taskNumber + " has " + target.getAtomCount() + " atoms, and " + target.getBondCount() + " bonds");
                long endCalcTime = Calendar.getInstance().getTimeInMillis();
                LOGGER.debug("Task " + this.taskNumber + " index " + index + " took " + (endCalcTime - calcTime) + "ms");
                calcTime = endCalcTime;
                if (fragmentsFromMCS.isEmpty()) {
                    localSeeds.clear();
                    break;
                }
                for (Fragment fragment : fragmentsFromMCS) {
                    if (minSeedSize > fragment.getContainer().getAtomCount()) {
                        localSeeds.clear();
                        minSeedSize = fragment.getContainer().getAtomCount();
                    }
                    if (minSeedSize != fragment.getContainer().getAtomCount()) continue;
                    localSeeds.add(fragment);
                }
            }
            if (!localSeeds.isEmpty()) {
                for (Fragment f : localSeeds) {
                    seeds.add(f.getContainer());
                }
                localSeeds.clear();
            }
            LOGGER.debug("No of Potential MULTIPLE " + seeds.size());
            minSeedSize = Integer.MAX_VALUE;
            while (!seeds.isEmpty()) {
                IAtomContainer fragmentMCS = (IAtomContainer)seeds.poll();
                localSeeds = new TreeSet();
                LOGGER.debug("Potential MULTIPLE " + this.getMCSSSmiles(fragmentMCS));
                for (IAtomContainer target : this.mcssList) {
                    Isomorphism comparison = new Isomorphism(fragmentMCS, target, Algorithm.DEFAULT, this.atomMatcher, this.bondMatcher);
                    comparison.setChemFilters(true, true, true);
                    Collection<Fragment> fragmentsFromMCS = this.getMCSS(comparison);
                    if (fragmentsFromMCS == null || fragmentsFromMCS.isEmpty()) {
                        localSeeds.clear();
                        break;
                    }
                    for (Fragment fragment : fragmentsFromMCS) {
                        if (minSeedSize > fragment.getContainer().getAtomCount()) {
                            localSeeds.clear();
                            minSeedSize = fragment.getContainer().getAtomCount();
                        }
                        if (minSeedSize != fragment.getContainer().getAtomCount()) continue;
                        localSeeds.add(fragment);
                    }
                    fragmentMCS = ((Fragment)localSeeds.iterator().next()).getContainer();
                }
                if (localSeeds.isEmpty()) continue;
                for (Fragment f : localSeeds) {
                    mcss.add(f.getContainer());
                }
                localSeeds.clear();
            }
        }
        catch (CDKException e) {
            LOGGER.error("ERROR IN MCS Thread: ", e.getMessage());
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        LOGGER.debug("Done: task " + this.taskNumber + " took " + (endTime - startTime) + "ms");
        LOGGER.debug(" and mcss has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
        return mcss;
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> singleSolution() {
        LOGGER.debug("Calling MCSSTask " + this.taskNumber + " with " + this.mcssList.size() + " items");
        LinkedBlockingQueue<IAtomContainer> mcss = new LinkedBlockingQueue<IAtomContainer>();
        long startTime = Calendar.getInstance().getTimeInMillis();
        IAtomContainer querySeed = this.mcssList.get(0);
        long calcTime = startTime;
        try {
            for (int index = 1; index < this.mcssList.size(); ++index) {
                IAtomContainer target = ExtAtomContainerManipulator.removeHydrogens(this.mcssList.get(index));
                Isomorphism comparison = new Isomorphism(querySeed, target, Algorithm.DEFAULT, this.atomMatcher, this.bondMatcher);
                comparison.setChemFilters(true, true, true);
                Collection<Fragment> fragmentsFomMCS = this.getMCSS(comparison);
                LOGGER.debug("comparison for task " + this.taskNumber + " has " + fragmentsFomMCS.size() + " unique matches of size " + comparison.getFirstAtomMapping().getCount());
                LOGGER.debug("MCSS for task " + this.taskNumber + " has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
                LOGGER.debug("Target for task " + this.taskNumber + " has " + target.getAtomCount() + " atoms, and " + target.getBondCount() + " bonds");
                long endCalcTime = Calendar.getInstance().getTimeInMillis();
                LOGGER.debug("Task " + this.taskNumber + " index " + index + " took " + (endCalcTime - calcTime) + "ms");
                calcTime = endCalcTime;
                if (fragmentsFomMCS.isEmpty()) break;
                querySeed = fragmentsFomMCS.iterator().next().getContainer();
            }
            if (querySeed != null) {
                mcss.add(querySeed);
                long endTime = Calendar.getInstance().getTimeInMillis();
                LOGGER.debug("Done: task " + this.taskNumber + " took " + (endTime - startTime) + "ms");
                LOGGER.debug(" and mcss has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
            }
        }
        catch (Exception e) {
            LOGGER.error("ERROR IN MCS Thread: ", e.getMessage());
        }
        return mcss;
    }

    private synchronized Collection<Fragment> getMCSS(BaseMapping comparison) {
        HashSet<Fragment> matchList = new HashSet<Fragment>();
        comparison.getAllAtomMapping().stream().forEach(mapping -> {
            try {
                IAtomContainer match = mapping.getCommonFragment();
                try {
                    matchList.add(new Fragment(match));
                }
                catch (CDKException ex) {
                    LOGGER.error("ERROR IN MCS Thread: ", ex);
                }
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.error("ERROR IN MCS Thread: ", ex);
            }
        });
        return matchList;
    }

    public synchronized String getMCSSSmiles(IAtomContainer ac) throws CDKException {
        Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.or(Cycles.relevant(), Cycles.essential())));
        SmilesGenerator g = new SmilesGenerator(1809);
        aromaticity.apply(ac);
        return g.create(ac);
    }

    public synchronized int getTaskNumber() {
        return this.taskNumber;
    }
}

