/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class Utility {
    static final String NEW_LINE = System.getProperty("line.separator");

    static int print_matrix(List<Integer> MCGregor_Matrix, int bondnum_A, List<Integer> i_bonds_A, List<String> c_bonds_A, int bondnum_B, List<Integer> i_bonds_B, List<String> c_bonds_B) {
        int a;
        System.out.println("bondnum_A " + bondnum_A);
        System.out.println("bondnum_B " + bondnum_B);
        System.out.println("c_bonds_A " + c_bonds_A.size());
        Utility.print_list(c_bonds_A);
        System.out.println("i_bonds_A " + i_bonds_A.size());
        Utility.print_list(i_bonds_A);
        System.out.println("c_bonds_B " + c_bonds_B.size());
        Utility.print_list(c_bonds_B);
        System.out.println("i_bonds_B " + i_bonds_B.size());
        Utility.print_list(i_bonds_B);
        System.out.print("matrix: " + NEW_LINE + "-    ");
        for (a = 0; a < bondnum_B; ++a) {
            System.out.print(" " + c_bonds_B.get(a * 4 + 0) + c_bonds_B.get(a * 4 + 1));
        }
        System.out.print(NEW_LINE + "     ");
        for (a = 0; a < bondnum_B; ++a) {
            System.out.print(" " + i_bonds_B.get(a * 3 + 0) + i_bonds_B.get(a * 3 + 1));
        }
        System.out.println("");
        for (a = 0; a < bondnum_A; ++a) {
            System.out.print(c_bonds_A.get(a * 4 + 0) + c_bonds_A.get(a * 4 + 1));
            System.out.print(" " + i_bonds_A.get(a * 3 + 0) + i_bonds_A.get(a * 3 + 1));
            for (int b = 0; b < bondnum_B; ++b) {
                System.out.print("   " + MCGregor_Matrix.get(a * bondnum_B + b));
            }
            System.out.println("");
        }
        System.out.println("");
        return 0;
    }

    static void print_list(List list) {
        list.stream().forEach(o -> System.out.print(o + " "));
        System.out.println("");
    }

    public static List<Integer> getBubbleSort(List<Integer> unSortedVector) {
        ArrayList<Integer> sortedVector = new ArrayList<Integer>(unSortedVector);
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int j = 1; j < sortedVector.size() - 1; ++j) {
                if ((Integer)sortedVector.get(j) <= (Integer)sortedVector.get(j + 1)) continue;
                int temp = (Integer)sortedVector.get(j);
                sortedVector.set(j, (Integer)sortedVector.get(j + 1));
                sortedVector.set(j + 1, temp);
                flag = true;
            }
        }
        return sortedVector;
    }

    public static boolean isMatch(IAtomContainer ac1, IAtomContainer ac2, boolean either) throws CDKException {
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac1);
        MoleculeInitializer.initializeMolecule(ac1);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac2);
        MoleculeInitializer.initializeMolecule(ac2);
        AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(false, true);
        BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(true, true);
        if (ac1.getAtomCount() <= ac2.getAtomCount()) {
            Substructure pattern = new Substructure(ac1, ac2, atomMatcher, bondMatcher, false);
            return pattern.isSubgraph();
        }
        if (either && ac1.getAtomCount() >= ac2.getAtomCount()) {
            Substructure pattern = new Substructure(ac2, ac1, atomMatcher, bondMatcher, false);
            return pattern.isSubgraph();
        }
        return false;
    }

    public static Map<IAtom, IAtom> findSubgraph(IAtomContainer source, IAtomContainer target, boolean matchAtomType, boolean matchBonds, boolean shouldMatchRings, boolean matchRingSize) throws CDKException {
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(source);
        MoleculeInitializer.initializeMolecule(source);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(target);
        MoleculeInitializer.initializeMolecule(target);
        AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(matchAtomType, matchRingSize);
        BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(matchBonds, shouldMatchRings);
        if (source.getAtomCount() <= target.getAtomCount()) {
            try {
                Substructure s = new Substructure(source, target, atomMatcher, bondMatcher, false);
                s.setChemFilters(true, true, true);
                return s.getFirstAtomMapping().getMappingsByAtoms();
            }
            catch (CDKException ex) {
                Logger.getLogger(uk.ac.ebi.reactionblast.mechanism.helper.Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new HashMap<IAtom, IAtom>();
    }
}

