/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

class ChemicalFormatParser {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(ChemicalFormatParser.class);

    ChemicalFormatParser() {
    }

    protected static IReaction parseCML(String input) throws FileNotFoundException, CDKException {
        File f = new File(input);
        if (!f.isFile()) {
            LOGGER.warn(Level.WARNING, String.format("CML file not found! " + f.getName(), new Object[0]));
            System.exit(1);
        }
        String[] split = f.getName().split(".cml");
        CMLReader cmlReader = new CMLReader(new FileInputStream(input));
        AtomContainer ac = cmlReader.read(new AtomContainer());
        Reaction r = new Reaction();
        r.addReactant(ac, 1.0);
        r.addProduct(ac, 1.0);
        r.setID(split[0]);
        return r;
    }

    protected static List<IReaction> parseRXN(String fileNames) {
        String[] files = fileNames.split(";");
        ArrayList<IReaction> reactions = new ArrayList<IReaction>();
        for (String file : files) {
            String[] f = file.split("\\.(?=[^\\.]+$)");
            if (f[0].equals("rxn")) continue;
            String fileName = f[0].trim() + ".rxn";
            File filepath = new File(fileName);
            if (!filepath.isFile()) {
                LOGGER.error(Level.WARNING, String.format("RXN file not found! %s", filepath.getName()));
                System.exit(1);
            }
            try {
                LOGGER.info(Level.INFO, "Annotating Reaction {0}", filepath.getName());
                try (MDLRXNV2000Reader reader = new MDLRXNV2000Reader(new FileReader(filepath));){
                    try {
                        IReaction rxnReactions = reader.read(new Reaction());
                        reader.close();
                        rxnReactions.setID(filepath.getName().split(".rxn")[0]);
                        rxnReactions = ChemicalFormatParser.convertRoundTripRXNSMILES(rxnReactions);
                        reactions.add(rxnReactions);
                    }
                    catch (IOException | CDKException ex) {
                        LOGGER.debug("ERROR in Reading Reaction file " + filepath + NEW_LINE + ex);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to Read and Annotate RXN File ");
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return reactions;
    }

    protected static IReaction convertRoundTripRXNSMILES(IReaction ref_reaction) throws CDKException {
        String id;
        IAtomContainer atomContainer;
        int i;
        SmilesGenerator sg = new SmilesGenerator(1812);
        String createSmilesFromReaction = sg.create(ref_reaction);
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        IReaction parseReactionSmiles = smilesParser.parseReactionSmiles(createSmilesFromReaction);
        parseReactionSmiles.setID(ref_reaction.getID());
        for (i = 0; i < ref_reaction.getReactantCount(); ++i) {
            atomContainer = parseReactionSmiles.getReactants().getAtomContainer(i);
            id = ref_reaction.getReactants().getAtomContainer(i).getID();
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
            atomContainer.setID(id);
        }
        for (i = 0; i < ref_reaction.getProductCount(); ++i) {
            atomContainer = parseReactionSmiles.getProducts().getAtomContainer(i);
            id = ref_reaction.getProducts().getAtomContainer(i).getID();
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
            atomContainer.setID(id);
        }
        return parseReactionSmiles;
    }

    protected static List<IReaction> parseReactionSMILES(String reactionSmiles) {
        SmilesParser sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
        String[] smiles = reactionSmiles.split("\\s+");
        ArrayList<IReaction> reactions = new ArrayList<IReaction>();
        int smilesIndex = 1;
        for (String s : smiles) {
            try {
                IReaction parseReactionSmile = sp.parseReactionSmiles(s);
                try {
                    parseReactionSmile = ChemicalFormatParser.convertRoundTripRXNSMILES(parseReactionSmile);
                }
                catch (CDKException e) {
                    LOGGER.error(Level.SEVERE, NEW_LINE, " Sorry - error in Configuring reaction smiles: ", e.getMessage());
                }
                try {
                    LOGGER.info(Level.INFO, "Annotating Reaction smiles");
                    if (smiles.length > 1) {
                        parseReactionSmile.setID("smiles_" + smilesIndex);
                    } else {
                        parseReactionSmile.setID("smiles");
                    }
                    reactions.add(parseReactionSmile);
                }
                catch (Exception ex) {
                    LOGGER.error(Level.SEVERE, NEW_LINE, ex);
                }
            }
            catch (InvalidSmilesException ex) {
                LOGGER.error(Level.SEVERE, NEW_LINE, ex);
            }
            ++smilesIndex;
        }
        return reactions;
    }
}

