/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool;

import org.apache.commons.cli.Options;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CommandLineOptions {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CommandLineOptions.class);

    protected Options createAAMOptions() {
        Options optionsAAM = new Options();
        optionsAAM.addOption("h", "help", false, "Help page for command usage");
        optionsAAM.addOption("Q", "formatQ", true, "Query Type (RXN/SMI)");
        optionsAAM.addOption("q", "query", true, "Query");
        optionsAAM.addOption("j", "job", true, "Task (AAM)");
        optionsAAM.addOption("g", "image", false, "create png of the mapping");
        optionsAAM.addOption("m", "mappings", false, "Report all mappings");
        optionsAAM.addOption("u", "premap", false, "use user defined mappings");
        optionsAAM.addOption("p", "prefix", true, "Job prefix");
        optionsAAM.addOption("f", "formatO", true, "Output format (TEXT/XML)");
        optionsAAM.addOption("c", "complexMode", false, "Use Rings etc. bit time comsuming");
        return optionsAAM;
    }

    protected Options createAnnotateOptions() {
        Options optionsCompare = new Options();
        optionsCompare.addOption("h", "help", false, "Help page for command usage");
        optionsCompare.addOption("Q", "formatQ", true, "Query Type (RXN/SMI)");
        optionsCompare.addOption("q", "query", true, "Query");
        optionsCompare.addOption("j", "job", true, "Task (ANNOTATE)");
        optionsCompare.addOption("u", "premap", false, "use user defined mappings");
        optionsCompare.addOption("g", "image", false, "create png of the mapping");
        optionsCompare.addOption("p", "prefix", true, "Job prefix");
        optionsCompare.addOption("f", "formatO", true, "Output format (TEXT/XML/BOTH)");
        optionsCompare.addOption("x", "patterns", false, "Report all matched molecular pairs (RPAIR type)");
        optionsCompare.addOption("c", "complexMode", false, "Use Rings etc. bit time comsuming");
        return optionsCompare;
    }

    protected Options createCompareOptions() {
        Options optionsCompare = new Options();
        optionsCompare.addOption("h", "help", false, "Help page for command usage");
        optionsCompare.addOption("u", "premap", false, "use user defined mappings");
        optionsCompare.addOption("Q", "formatQ", true, "Query Type (RXN/SMI)");
        optionsCompare.addOption("q", "query", true, "Query");
        optionsCompare.addOption("T", "formatT", true, "Target Type (RXN/SMI)");
        optionsCompare.addOption("t", "target", true, "Target");
        optionsCompare.addOption("j", "job", true, "Task (COMPARE)");
        optionsCompare.addOption("g", "image", false, "create png of the mapping");
        optionsCompare.addOption("p", "prefix", true, "Job prefix");
        optionsCompare.addOption("f", "formatO", true, "Output format (TEXT/XML/BOTH)");
        optionsCompare.addOption("x", "patterns", false, "Report all matched molecular pairs (RPAIR type)");
        optionsCompare.addOption("c", "complexMode", false, "Use Rings etc. bit time comsuming");
        return optionsCompare;
    }
}

