/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.aamtool.ChemicalFormatParser;
import uk.ac.ebi.reactionblast.tools.ImageGenerator;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000RXNWriter;

class Helper
extends ChemicalFormatParser {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Helper.class);

    Helper() {
    }

    protected static void getHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("!--------------------------------------------------------");
        sb.append(NEW_LINE);
        sb.append("Reaction Decoder Tool (RDT)");
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("Author: Syed Asad Rahman");
        sb.append(NEW_LINE);
        sb.append("e-mail: asad@ebi.ac.uk|s9asad@gmail.com");
        sb.append(NEW_LINE);
        sb.append("c/o EMBL-European BioInformatics Institute (EBI)");
        sb.append(NEW_LINE);
        sb.append("WTGC, CB10 1SD Hinxton");
        sb.append(NEW_LINE);
        sb.append("UK");
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("Note: The copyright of this software belongs to the author");
        sb.append(NEW_LINE);
        sb.append("and EMBL-European BioInformatics Institute (EBI).");
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("Reference");
        sb.append(NEW_LINE);
        sb.append("Rahman, S.A. et.al.(2016) Reaction Decoder Tool (RDT):");
        sb.append(NEW_LINE);
        sb.append("Extracting Features from Chemical Reactions, Bioinformatics (2016)");
        sb.append(NEW_LINE);
        sb.append("doi: 10.1093/bioinformatics/btw096");
        sb.append(NEW_LINE);
        sb.append("!--------------------------------------------------------");
        sb.append(NEW_LINE);
        System.out.println(sb.toString());
    }

    protected static void displayBlankLines(int numberBlankLines, OutputStream out) {
        try {
            for (int i = 0; i < numberBlankLines; ++i) {
                out.write(NEW_LINE.getBytes());
            }
        }
        catch (IOException ioEx) {
            for (int i = 0; i < numberBlankLines; ++i) {
                System.out.println();
            }
        }
    }

    protected static void printHelp(OutputStream out, Options options) {
        String commandLineSyntax = "java -jar ReactionDecoder.jar";
        try (PrintWriter writer = new PrintWriter(out);){
            HelpFormatter formatter = new HelpFormatter();
            Helper.displayBlankLines(2, out);
            formatter.printHelp(writer, 80, "java -jar ReactionDecoder.jar", "HELP", options, 5, 3, "End of Helper Help", true);
            writer.flush();
            writer.close();
        }
    }

    protected static void printHelp(Map<String, Options> optionsMap, int printedRowWidth, String header, String footer, int spacesBeforeOption, int spacesBeforeOptionDescription, boolean displayUsage, OutputStream out) {
        String commandLineSyntax = "java -jar ReactionDecoder.jar";
        try (PrintWriter writer = new PrintWriter(out);){
            HelpFormatter helpFormatter = new HelpFormatter();
            optionsMap.keySet().stream().map(headerString -> {
                helpFormatter.printHelp(writer, printedRowWidth, "java -jar ReactionDecoder.jar", (String)headerString, (Options)optionsMap.get(headerString), spacesBeforeOption, spacesBeforeOptionDescription, "End of Helper " + headerString + " Help", displayUsage);
                return headerString;
            }).map(_item -> {
                Helper.displayBlankLines(2, out);
                return _item;
            }).forEach(_item -> writer.flush());
            writer.close();
        }
    }

    protected static File generateImage(String canonicalRootPath, IReaction mappedReaction, String reactionID) throws Exception {
        File file = new File(canonicalRootPath);
        new ImageGenerator().drawLeftToRightReactionLayout(file, mappedReaction, reactionID);
        return new File(file.getCanonicalFile(), reactionID + ".png");
    }

    protected static File generateAAMImage(String canonicalRootPath, IReaction mappedReaction, String reactionID) throws Exception {
        File file = new File(canonicalRootPath);
        new ImageGenerator().drawTopToBottomReactionLayout(file, mappedReaction, reactionID);
        return new File(file.getCanonicalFile(), reactionID + ".png");
    }

    protected static File writeRXNMappedFile(String canonicalRootPath, IReaction mappedReaction, String name) throws IOException, CDKException {
        File f = new File(canonicalRootPath + File.separator + name + ".rxn");
        try (MDLV2000RXNWriter writer = new MDLV2000RXNWriter(new FileWriter(f));){
            writer.write(mappedReaction);
            writer.close();
        }
        return f;
    }

    protected String printUsageExamples() {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append("Option examples: ");
        sb.append(NEW_LINE);
        sb.append("-Q RXN -q reaction.rxn");
        sb.append(NEW_LINE);
        sb.append("-Q SMI -q \"C=C1CCCC(=O)C1>>O[C@H]1CCCC(=C)C1\"");
        sb.append(NEW_LINE);
        return sb.toString();
    }
}

