/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ebi.aamtool.Annotator;
import uk.ac.ebi.aamtool.CommandLineOptions;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;

public class ReactionDecoder
extends Annotator {
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(ReactionDecoder.class);

    public static void main(String[] args) {
        try {
            CommandLineOptions cmd = new CommandLineOptions();
            Options createAAMOptions = cmd.createAAMOptions();
            Options createCompareOptions = cmd.createCompareOptions();
            Options createAnnotateOptions = cmd.createAnnotateOptions();
            DefaultParser parser1 = new DefaultParser();
            CommandLine aamLine = parser1.parse(createAAMOptions, args, true);
            DefaultParser parser2 = new DefaultParser();
            CommandLine compareLine = parser2.parse(createCompareOptions, args, true);
            DefaultParser parser3 = new DefaultParser();
            CommandLine annotateLine = parser3.parse(createAnnotateOptions, args, true);
            ReactionDecoder.getHeader();
            boolean complexMappingFlag = false;
            if (aamLine.hasOption('c') || compareLine.hasOption('c') || annotateLine.hasOption('c')) {
                complexMappingFlag = true;
            }
            ReactionDecoder rxn = new ReactionDecoder();
            if (aamLine.hasOption('j') && aamLine.getOptionValue("j").equalsIgnoreCase("AAM") && aamLine.hasOption('Q') && aamLine.hasOption('q') && aamLine.hasOption('f')) {
                System.out.println("-- AAM --");
                rxn.AAMTask(aamLine, createAAMOptions, complexMappingFlag);
            } else if (compareLine.hasOption('j') && compareLine.getOptionValue("j").equalsIgnoreCase("COMPARE") && compareLine.hasOption('Q') && compareLine.hasOption('q') && compareLine.hasOption('T') && compareLine.hasOption('t') && compareLine.hasOption('f')) {
                System.out.println("-- COMPARE --");
                rxn.CompareTask(compareLine, createCompareOptions, complexMappingFlag);
            } else if (annotateLine.hasOption('j') && annotateLine.getOptionValue("j").equalsIgnoreCase("ANNOTATE") && annotateLine.hasOption('Q') && annotateLine.hasOption('q') && annotateLine.hasOption('f')) {
                System.out.println("-- ANNOTATE --");
                rxn.AnnotateTask(annotateLine, createAnnotateOptions, complexMappingFlag);
            } else if (aamLine.hasOption('j') && aamLine.getOptionValue("j").equalsIgnoreCase("AAM")) {
                System.out.println("-- AAM USAGE --");
                ReactionDecoder.printHelp(System.out, createAAMOptions);
            } else if (compareLine.hasOption('j') && compareLine.getOptionValue("j").equalsIgnoreCase("COMPARE")) {
                System.out.println("-- REACTION COMPARE USAGE --");
                ReactionDecoder.printHelp(System.out, createCompareOptions);
            } else if (compareLine.hasOption('j') && compareLine.getOptionValue("j").equalsIgnoreCase("ANNOTATE")) {
                System.out.println("-- REACTION ANNOTATION USAGE --");
                ReactionDecoder.printHelp(System.out, createAnnotateOptions);
            } else {
                System.out.println("-- REACTION DECODER HELP --");
                TreeMap<String, Options> options = new TreeMap<String, Options>();
                options.put("Atom-Atom Mapping (AAM-Tool)", createAAMOptions);
                options.put("Reaction Annotation (RA-Tool)", createAnnotateOptions);
                options.put("Reaction Comparison (RC-Tool)", createCompareOptions);
                ReactionDecoder.printHelp(options, 80, "EC-BLAST", "End of Help", 5, 3, true, System.out);
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, " CommandLine option parsing error: ", ex);
        }
        System.exit(1);
    }

    private synchronized void FormatXMLToFile(Document doc, String fileName) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        doc.setXmlStandalone(true);
        DOMSource source = new DOMSource(doc);
        File file = new File(fileName + ".xml");
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
        System.out.println("Output is presented in xml format: " + file.getAbsolutePath());
    }

    private synchronized void FormatTextToFile(StringBuilder doc, String fileName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        File file = new File(fileName + ".txt");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            writer.write(doc.toString());
        }
        System.out.println("Output is presented in text format: " + file.getAbsolutePath());
    }

    private synchronized void AAMTask(CommandLine aamLine, Options createAAMOptions, boolean complexMappingFlag) throws Exception {
        ReactionMechanismTool annotateReaction;
        String optionValue = aamLine.getOptionValue("q");
        if (aamLine.hasOption('m')) {
            this.REPORT_ALL_MAPPINGS = true;
        }
        if (aamLine.hasOption('g')) {
            this.GENERATE_IMAGE = false;
            this.GENERATE_AAMIMAGE = true;
        }
        if (aamLine.hasOption('p')) {
            this.PREFIX = aamLine.getOptionValue("p");
        }
        if (aamLine.hasOption('u')) {
            this.REMAP = false;
        }
        IReaction reaction = null;
        switch (aamLine.getOptionValue("Q")) {
            case "SMI": {
                List<IReaction> parseReactions;
                if (optionValue.contains(">>")) {
                    parseReactions = ReactionDecoder.parseReactionSMILES(optionValue);
                    if (!parseReactions.iterator().hasNext()) break;
                    reaction = parseReactions.iterator().next();
                    break;
                }
                LOGGER.debug("Not a valid reaction SMILES");
                break;
            }
            case "RXN": {
                List<IReaction> parseReactions = ReactionDecoder.parseRXN(optionValue);
                if (!parseReactions.iterator().hasNext()) break;
                reaction = parseReactions.iterator().next();
                break;
            }
            default: {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createAAMOptions);
            }
        }
        if (reaction == null) {
            return;
        }
        String jobFileName = !this.PREFIX.isEmpty() ? this.PREFIX + "_ECBLAST_" + reaction.getID() + "_AAM" : "ECBLAST_" + reaction.getID() + "_AAM";
        boolean writeFiles = this.writeFiles(jobFileName, annotateReaction = ReactionDecoder.getReactionMechanismTool(reaction, this.REMAP, complexMappingFlag));
        if (writeFiles && aamLine.getOptionValue("f").equalsIgnoreCase("XML")) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("EC_BLAST");
            doc.appendChild(rootElement);
            this.annotateReactionAsXML(annotateReaction, jobFileName, doc, rootElement);
            this.FormatXMLToFile(doc, jobFileName);
            System.out.println("XML File saved!");
        } else if (writeFiles && aamLine.getOptionValue("f").equalsIgnoreCase("TEXT")) {
            StringBuilder sb = new StringBuilder();
            this.annotateReactionAsText(annotateReaction, reaction.getID() + "_AAM", sb);
            this.FormatTextToFile(sb, jobFileName);
        } else if (writeFiles && aamLine.getOptionValue("f").equalsIgnoreCase("BOTH")) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("EC_BLAST");
            doc.appendChild(rootElement);
            this.annotateReactionAsXML(annotateReaction, jobFileName, doc, rootElement);
            StringBuilder sb = new StringBuilder();
            this.annotateReactionAsText(annotateReaction, jobFileName, sb);
            this.FormatTextToFile(sb, jobFileName);
            this.FormatXMLToFile(doc, jobFileName);
            System.out.println("XML File saved!");
        } else {
            ReactionDecoder.displayBlankLines(2, System.out);
            System.out.println("-- USAGE --");
            ReactionDecoder.printHelp(System.out, createAAMOptions);
        }
    }

    private synchronized void CompareTask(CommandLine compareLine, Options createCompareOptions, boolean complexMappingFlag) throws ParserConfigurationException, Exception {
        boolean writeFiles;
        String optionValueQ = compareLine.getOptionValue("q");
        String optionValueT = compareLine.getOptionValue("t");
        this.REPORT_PATTERNS = true;
        if (compareLine.hasOption("g")) {
            this.GENERATE_IMAGE = true;
            this.GENERATE_AAMIMAGE = false;
        }
        if (compareLine.hasOption('p')) {
            this.PREFIX = compareLine.getOptionValue("p");
        }
        if (compareLine.hasOption('u')) {
            this.REMAP = false;
        }
        if (compareLine.hasOption('x')) {
            this.REPORT_MMP = true;
        }
        IReaction queryReaction = null;
        switch (compareLine.getOptionValue("Q")) {
            case "SMI": {
                List<IReaction> parseReactions;
                if (optionValueQ.contains(">>")) {
                    parseReactions = ReactionDecoder.parseReactionSMILES(optionValueQ);
                    if (!parseReactions.iterator().hasNext()) break;
                    queryReaction = parseReactions.iterator().next();
                    break;
                }
                LOGGER.debug("Not a valid reaction SMILES");
                break;
            }
            case "RXN": {
                List<IReaction> parseReactions = ReactionDecoder.parseRXN(optionValueQ);
                if (!parseReactions.iterator().hasNext()) break;
                queryReaction = parseReactions.iterator().next();
                break;
            }
            default: {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createCompareOptions);
            }
        }
        IReaction targetReaction = null;
        switch (compareLine.getOptionValue("T")) {
            case "SMI": {
                List<IReaction> parseReactions;
                if (optionValueT.contains(">>")) {
                    parseReactions = ReactionDecoder.parseReactionSMILES(optionValueT);
                    if (!parseReactions.iterator().hasNext()) break;
                    targetReaction = parseReactions.iterator().next();
                    break;
                }
                LOGGER.debug("Not a valid reaction SMILES");
                break;
            }
            case "RXN": {
                List<IReaction> parseReactions = ReactionDecoder.parseRXN(optionValueT);
                if (!parseReactions.iterator().hasNext()) break;
                targetReaction = parseReactions.iterator().next();
                break;
            }
            default: {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createCompareOptions);
            }
        }
        if (queryReaction == null || targetReaction == null) {
            return;
        }
        String jobFileName = !this.PREFIX.isEmpty() ? this.PREFIX + "_ECBLAST_" + queryReaction.getID() + "_" + targetReaction.getID() + "_COMPARE" : "ECBLAST_" + queryReaction.getID() + "_" + targetReaction.getID() + "_COMPARE";
        String jobFileNameQuery = !this.PREFIX.isEmpty() ? this.PREFIX + "_ECBLAST_" + queryReaction.getID() + "_Query" : "ECBLAST_" + queryReaction.getID() + "_Query";
        String jobFileNameTarget = !this.PREFIX.isEmpty() ? this.PREFIX + "_ECBLAST_" + targetReaction.getID() + "_Target" : "ECBLAST_" + targetReaction.getID() + "_Target";
        ReactionMechanismTool annotateReactionQ = ReactionDecoder.getReactionMechanismTool(queryReaction, this.REMAP, complexMappingFlag);
        ReactionMechanismTool annotateReactionT = ReactionDecoder.getReactionMechanismTool(targetReaction, this.REMAP, complexMappingFlag);
        boolean writeFiles1 = this.writeFiles(jobFileNameQuery, annotateReactionQ);
        boolean writeFiles2 = this.writeFiles(jobFileNameTarget, annotateReactionT);
        boolean bl = writeFiles = writeFiles1 && writeFiles2;
        if (writeFiles && annotateReactionQ != null && annotateReactionT != null) {
            if (compareLine.getOptionValue("f").equalsIgnoreCase("XML")) {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("EC_BLAST");
                doc.appendChild(rootElement);
                this.compareRXNXML(annotateReactionQ, jobFileNameQuery, annotateReactionT, jobFileNameTarget, doc, rootElement);
                this.FormatXMLToFile(doc, jobFileName);
                System.out.println("XML File saved!");
            } else if (writeFiles && compareLine.getOptionValue("f").equalsIgnoreCase("TEXT")) {
                StringBuilder sb = new StringBuilder();
                this.compareRXNText(annotateReactionQ, jobFileNameQuery, annotateReactionT, jobFileNameTarget, sb);
                this.FormatTextToFile(sb, jobFileName);
            } else if (writeFiles && compareLine.getOptionValue("f").equalsIgnoreCase("BOTH")) {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("EC_BLAST");
                doc.appendChild(rootElement);
                this.compareRXNXML(annotateReactionQ, jobFileNameQuery, annotateReactionT, jobFileNameTarget, doc, rootElement);
                StringBuilder sb = new StringBuilder();
                this.compareRXNText(annotateReactionQ, jobFileNameQuery, annotateReactionT, jobFileNameTarget, sb);
                this.FormatTextToFile(sb, jobFileName);
                this.FormatXMLToFile(doc, jobFileName);
                System.out.println("XML File saved!");
            } else {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createCompareOptions);
            }
        }
    }

    private synchronized void AnnotateTask(CommandLine annotateLine, Options createAnnotateOptions, boolean complexMappingFlag) throws TransformerException, CloneNotSupportedException, FileNotFoundException, IOException, Exception {
        String optionValue = annotateLine.getOptionValue("q");
        this.REPORT_PATTERNS = true;
        if (annotateLine.hasOption("g")) {
            this.GENERATE_IMAGE = true;
            this.GENERATE_AAMIMAGE = false;
        }
        if (annotateLine.hasOption('p')) {
            this.PREFIX = annotateLine.getOptionValue("p");
        }
        if (annotateLine.hasOption('x')) {
            this.REPORT_MMP = true;
        }
        if (annotateLine.hasOption('u')) {
            this.REMAP = false;
        }
        IReaction reaction = null;
        switch (annotateLine.getOptionValue("Q")) {
            case "SMI": {
                List<IReaction> parseReactions;
                if (optionValue.contains(">>")) {
                    parseReactions = ReactionDecoder.parseReactionSMILES(optionValue);
                    if (!parseReactions.iterator().hasNext()) break;
                    reaction = parseReactions.iterator().next();
                    break;
                }
                LOGGER.debug("Not a valid reaction SMILES");
                break;
            }
            case "RXN": {
                List<IReaction> parseReactions = ReactionDecoder.parseRXN(optionValue);
                if (!parseReactions.iterator().hasNext()) break;
                reaction = parseReactions.iterator().next();
                break;
            }
            default: {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createAnnotateOptions);
            }
        }
        if (reaction == null) {
            return;
        }
        String jobFileName = !this.PREFIX.isEmpty() ? this.PREFIX + "_ECBLAST_" + reaction.getID() + "_ANNONATE" : "ECBLAST_" + reaction.getID() + "_ANNONATE";
        ReactionMechanismTool annotateReaction = ReactionDecoder.getReactionMechanismTool(reaction, this.REMAP, complexMappingFlag);
        boolean writeFiles = this.writeFiles(jobFileName, annotateReaction);
        try {
            if (writeFiles && annotateLine.getOptionValue("f").equalsIgnoreCase("XML")) {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("EC_BLAST");
                doc.appendChild(rootElement);
                this.annotateReactionAsXML(annotateReaction, jobFileName, doc, rootElement);
                this.FormatXMLToFile(doc, jobFileName);
                System.out.println("XML File saved!");
            } else if (writeFiles && annotateLine.getOptionValue("f").equalsIgnoreCase("TEXT")) {
                StringBuilder sb = new StringBuilder();
                this.annotateReactionAsText(annotateReaction, reaction.getID() + "_AAM", sb);
                this.FormatTextToFile(sb, jobFileName);
            } else if (writeFiles && annotateLine.getOptionValue("f").equalsIgnoreCase("BOTH")) {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("EC_BLAST");
                doc.appendChild(rootElement);
                this.annotateReactionAsXML(annotateReaction, jobFileName, doc, rootElement);
                StringBuilder sb = new StringBuilder();
                this.annotateReactionAsText(annotateReaction, jobFileName, sb);
                this.FormatTextToFile(sb, jobFileName);
                this.FormatXMLToFile(doc, jobFileName);
                System.out.println("XML File saved!");
            } else {
                ReactionDecoder.displayBlankLines(2, System.out);
                System.out.println("-- USAGE --");
                ReactionDecoder.printHelp(System.out, createAnnotateOptions);
            }
        }
        catch (IOException | CloneNotSupportedException | ParserConfigurationException | TransformerException | DOMException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }
}

