/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Centre;
import uk.ac.ebi.centres.CentreProvider;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.Perceptor;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.SignCalculator;
import uk.ac.ebi.centres.descriptor.General;

public class DefaultPerceptor<A>
implements Perceptor<A> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(DefaultPerceptor.class);
    private final CentrePerceptor<A> mainPerceptor;
    private final CentrePerceptor<A> auxPerceptor;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private long timeout = 250L;

    public DefaultPerceptor(final PriorityRule<A> rule, final PriorityRule<A> auxRule, final SignCalculator<A> calculator) {
        this.mainPerceptor = new CentrePerceptor<A>(rule){

            @Override
            public Descriptor perceive(Centre<A> centre, Collection<Centre<A>> centres) {
                return centre.perceive(rule, calculator);
            }
        };
        this.auxPerceptor = new CentrePerceptor<A>(auxRule){

            @Override
            public Descriptor perceive(Centre<A> centre, Collection<Centre<A>> centres) {
                return centre.perceiveAuxiliary(centres, rule, calculator) != 0 ? centre.perceive(auxRule, calculator) : General.UNKNOWN;
            }
        };
    }

    private List<Centre<A>> _perceive(Collection<Centre<A>> unperceived, CentrePerceptor<A> perceptor) {
        ArrayList perceived = new ArrayList();
        LinkedHashMap map = new LinkedHashMap();
        do {
            map.clear();
            unperceived.forEach(centre -> {
                Descriptor descriptor = perceptor.perceive((Centre)centre, unperceived);
                if (descriptor != General.UNKNOWN) {
                    map.put(centre, descriptor);
                }
            });
            map.entrySet().stream().map(entry -> {
                unperceived.remove(entry.getKey());
                return entry;
            }).map(entry -> {
                perceived.add((Centre)entry.getKey());
                return entry;
            }).map(entry -> {
                ((Centre)entry.getKey()).dispose();
                return entry;
            }).forEachOrdered(entry -> ((Centre)entry.getKey()).setDescriptor((Descriptor)entry.getValue()));
        } while (!map.isEmpty());
        return perceived;
    }

    @Override
    public void perceive(CentreProvider<A> provider, DescriptorManager<A> manager) {
        Collection<Centre<A>> unperceived = provider.getCentres(manager);
        if (unperceived.isEmpty()) {
            return;
        }
        List<Centre<A>> perceived = this._perceive(unperceived, this.mainPerceptor);
        if (!unperceived.isEmpty() && perceived.isEmpty()) {
            perceived.addAll(this._perceive(unperceived, this.auxPerceptor));
        }
        for (Centre<A> centre : unperceived) {
            centre.setDescriptor(General.NONE);
            centre.dispose();
        }
        unperceived.clear();
        unperceived = null;
        manager.clear();
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
    }

    abstract class CentrePerceptor<A> {
        private final PriorityRule<A> rule;

        protected CentrePerceptor(PriorityRule<A> rule) {
            this.rule = rule;
        }

        public abstract Descriptor perceive(Centre<A> var1, Collection<Centre<A>> var2);
    }
}

