/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;

public class Priority {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Priority.class);
    private Boolean unique;
    private Descriptor.Type type;
    private Set<Set<Integer>> duplicates;

    public Priority(Boolean unique, Descriptor.Type type) {
        this.unique = unique;
        this.type = type;
    }

    public Priority(Boolean unique, Descriptor.Type type, Set<Set<Integer>> duplicates) {
        this.unique = unique;
        this.type = type;
        this.duplicates = duplicates;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    public Descriptor.Type getType() {
        return this.type;
    }

    public <A> List<List<Ligand<A>>> createBins(List<Ligand<A>> ligands) {
        if (this.duplicates == null) {
            throw new IllegalArgumentException("No duplicates stored at time of sort!");
        }
        ArrayList bins = new ArrayList(ligands.size());
        ligands.stream().map(ligand -> {
            ArrayList<Ligand> bin = new ArrayList<Ligand>();
            bin.add((Ligand)ligand);
            return bin;
        }).forEachOrdered(bin -> bins.add((List)bin));
        HashSet removed = new HashSet();
        this.duplicates.stream().map(pair2 -> pair2.iterator()).forEachOrdered(it -> {
            int i = (Integer)it.next();
            int j = (Integer)it.next();
            if (!removed.contains(i) || !removed.contains(j)) {
                ((List)bins.get(i)).addAll((Collection)bins.get(j));
                removed.add(j);
            }
        });
        removed.forEach(r -> bins.remove(r));
        return bins;
    }
}

