/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.calculator;

import uk.ac.ebi.centres.SignCalculator;

public abstract class AbstractSignCalculator<A>
implements SignCalculator<A> {
    private static final int x = 0;
    private static final int y = 1;
    private static final int z = 2;

    public abstract double getX(A var1);

    public abstract double getY(A var1);

    double[] crossproduct(double[] v1, double[] v2) {
        return new double[]{v1[1] * v2[2] - v2[1] * v1[1], v1[2] * v2[0] - v2[2] * v1[0], v1[0] * v2[1] - v2[0] * v1[1]};
    }

    double magnitude(double[] vector) {
        return Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
    }

    abstract double[] toVector(A var1, A var2);

    double determinant(double[][] arr) {
        double result = 0.0;
        if (arr.length == 1) {
            result = arr[0][0];
            return result;
        }
        if (arr.length == 2) {
            result = arr[0][0] * arr[1][1] - arr[0][1] * arr[1][0];
            return result;
        }
        for (int i = 0; i < arr[0].length; ++i) {
            double[][] temp = new double[arr.length - 1][arr[0].length - 1];
            for (int j = 1; j < arr.length; ++j) {
                for (int k = 0; k < arr[0].length; ++k) {
                    if (k < i) {
                        temp[j - 1][k] = arr[j][k];
                        continue;
                    }
                    if (k <= i) continue;
                    temp[j - 1][k - 1] = arr[j][k];
                }
            }
            result += arr[0][i] * Math.pow(-1.0, i) * this.determinant(temp);
        }
        return result;
    }
}

