/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.calculator;

import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.calculator.AbstractSignCalculator;

public abstract class ThreeDimensionalSignCalculator<A>
extends AbstractSignCalculator<A> {
    public abstract double getZ(A var1);

    @Override
    double[] toVector(A base, A atom) {
        return new double[]{this.getX(atom) - this.getX(base), this.getY(atom) - this.getY(base), this.getZ(atom) - this.getZ(base)};
    }

    @Override
    public int getSign(Ligand<A> a1, Ligand<A> a2, Ligand<A> a3, Ligand<A> a4) {
        if (a1.getDepth() == 0 && a2.getDepth() == 0 && a3.getDepth() == 0 && a4.getDepth() == 0) {
            return 0;
        }
        double[][] matrix = new double[][]{{this.getX(a1.getAtom()), this.getY(a1.getAtom()), this.getZ(a1.getAtom()), 1.0}, {this.getX(a2.getAtom()), this.getY(a2.getAtom()), this.getZ(a2.getAtom()), 1.0}, {this.getX(a3.getAtom()), this.getY(a3.getAtom()), this.getZ(a3.getAtom()), 1.0}, {this.getX(a4.getAtom()), this.getY(a4.getAtom()), this.getZ(a4.getAtom()), 1.0}};
        return (int)Math.signum(this.determinant(matrix));
    }

    @Override
    public int getSign(A a1, A a2, A a3) {
        double[][] matrix = new double[][]{{this.getX(a1), this.getY(a1), this.getZ(a1)}, {this.getX(a2), this.getY(a2), this.getZ(a2)}, {this.getX(a3), this.getY(a3), this.getZ(a3)}};
        double magnitude = this.magnitude(this.crossproduct(this.toVector(a2, a1), this.toVector(a2, a3)));
        return magnitude < 0.2 ? 0 : (int)Math.signum(this.determinant(matrix));
    }
}

