/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import java.util.ArrayList;
import java.util.Collection;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Centre;
import uk.ac.ebi.centres.CentreProvider;
import uk.ac.ebi.centres.ConnectionTable;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.cdk.CDKConnectionTable;
import uk.ac.ebi.centres.graph.ConnectionTableDigraph;
import uk.ac.ebi.centres.ligand.AbstractLigand;
import uk.ac.ebi.centres.ligand.PlanarCentre;
import uk.ac.ebi.centres.ligand.TetrahedralCentre;

public class CDKCentreProvider
implements CentreProvider<IAtom> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CDKCentreProvider.class);
    private final IAtomContainer container;
    private final ConnectionTable<IAtom> table;
    private IAtomContainer cyclicFragments;

    public CDKCentreProvider(IAtomContainer container) {
        this.container = container;
        this.table = new CDKConnectionTable(container);
    }

    @Override
    public Integer getAtomCount() {
        return this.container.getAtomCount();
    }

    @Override
    public Collection<Centre<IAtom>> getCentres(DescriptorManager<IAtom> manager) {
        AbstractLigand centre;
        ArrayList<Centre<IAtom>> centres = new ArrayList<Centre<IAtom>>(this.container.getAtomCount());
        for (IAtom atom : this.container.atoms()) {
            if (!IAtomType.Hybridization.SP3.equals((Object)atom.getHybridization()) || this.container.getConnectedBondsCount(atom) <= 2 || atom.getFormalNeighbourCount() != 4 || !this.hasStereoBonds(this.container, atom)) continue;
            centre = new TetrahedralCentre<IAtom>(manager.getDescriptor(atom), atom);
            centre.setProvider(new ConnectionTableDigraph<IAtom>(centre, manager, this.table));
            centres.add((Centre<IAtom>)((Object)centre));
        }
        for (IBond bond : this.container.bonds()) {
            if (!IBond.Order.DOUBLE.equals((Object)bond.getOrder()) || this.container.getConnectedBondsCount(bond.getAtom(0)) <= 1 || this.container.getConnectedBondsCount(bond.getAtom(1)) <= 1 || bond.getFlag(32) != Boolean.FALSE.booleanValue() || !this.onlyConnectedToSingleBonds(bond, this.container) || this.getCyclicFragments().contains(bond) || this.hasVariableBond(this.container, bond.getAtom(0)) || this.hasVariableBond(this.container, bond.getAtom(1))) continue;
            centre = new PlanarCentre<IAtom>(bond.getAtom(0), bond.getAtom(1), manager.getDescriptor(bond.getAtom(0), bond.getAtom(1)));
            ((PlanarCentre)centre).setProvider(new ConnectionTableDigraph<IAtom>(centre, manager, this.table));
            centres.add((Centre<IAtom>)((Object)centre));
        }
        return centres;
    }

    private boolean onlyConnectedToSingleBonds(IBond bond, IAtomContainer container) {
        return this.onlyConnectedToSingleBonds(bond, bond.getAtom(0), container) && this.onlyConnectedToSingleBonds(bond, bond.getAtom(1), container);
    }

    private boolean onlyConnectedToSingleBonds(IBond bond, IAtom atom, IAtomContainer container) {
        for (IBond connected : container.getConnectedBondsList(atom)) {
            if (IBond.Order.SINGLE.equals((Object)connected.getOrder()) || connected.equals(bond)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private IAtomContainer getCyclicFragments() {
        if (this.cyclicFragments == null) {
            this.cyclicFragments = new SpanningTree(this.container).getCyclicFragmentsContainer();
        }
        return this.cyclicFragments;
    }

    private boolean hasVariableBond(IAtomContainer container, IAtom atom) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IBond.Stereo stereo = bond.getStereo();
            if (!IBond.Stereo.UP_OR_DOWN.equals((Object)stereo) && !IBond.Stereo.UP_OR_DOWN_INVERTED.equals((Object)stereo)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean hasStereoBonds(IAtomContainer container, IAtom atom) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IBond.Stereo stereo = bond.getStereo();
            if (!IBond.Stereo.UP.equals((Object)stereo) && !IBond.Stereo.DOWN.equals((Object)stereo) && !IBond.Stereo.UP_INVERTED.equals((Object)stereo) && !IBond.Stereo.DOWN_INVERTED.equals((Object)stereo)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

