/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.descriptor.General;

public class CDKManager
implements DescriptorManager<IAtom> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(DescriptorManager.class);
    private final IAtomContainer container;
    private final Map<IChemObject, MutableDescriptor> map = new HashMap<IChemObject, MutableDescriptor>();

    public CDKManager(IAtomContainer container) {
        this.container = container;
    }

    @Override
    public MutableDescriptor getDescriptor(IAtom atom) {
        return this._getDescriptor(atom);
    }

    @Override
    public MutableDescriptor getDescriptor(IAtom first, IAtom second) {
        return this._getDescriptor(this.container.getBond(first, second));
    }

    private MutableDescriptor _getDescriptor(IChemObject chemObject) {
        MutableDescriptor mutator = this.map.get(chemObject);
        if (mutator == null) {
            mutator = new ProxyMutator(chemObject);
            this.map.put(chemObject, mutator);
        }
        return mutator;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    class ProxyMutator
    extends MutableDescriptor {
        private final IChemObject chemObject;

        ProxyMutator(IChemObject chemObject) {
            this.chemObject = chemObject;
            chemObject.setProperty("descriptor", General.UNKNOWN);
        }

        @Override
        public synchronized Descriptor get() {
            return (Descriptor)this.chemObject.getProperty("descriptor");
        }

        @Override
        public synchronized void set(Descriptor descriptor) {
            this.chemObject.setProperty("descriptor", descriptor);
        }
    }
}

