/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.DefaultPerceptor;
import uk.ac.ebi.centres.cdk.CDK2DSignCalculator;
import uk.ac.ebi.centres.cdk.CDKCentreProvider;
import uk.ac.ebi.centres.cdk.CDKManager;
import uk.ac.ebi.centres.priority.AtomicNumberRule;
import uk.ac.ebi.centres.priority.CombinedRule;
import uk.ac.ebi.centres.priority.DuplicateAtomRule;
import uk.ac.ebi.centres.priority.MassNumberRule;
import uk.ac.ebi.centres.priority.access.PsuedoAtomicNumberModifier;
import uk.ac.ebi.centres.priority.access.descriptor.AuxiliaryDescriptor;
import uk.ac.ebi.centres.priority.access.descriptor.PrimaryDescriptor;
import uk.ac.ebi.centres.priority.descriptor.PairRule;
import uk.ac.ebi.centres.priority.descriptor.RSRule;
import uk.ac.ebi.centres.priority.descriptor.ZERule;

public class CDKPerceptor
extends DefaultPerceptor<IAtom> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CDKPerceptor.class);

    public CDKPerceptor() {
        super(new CombinedRule(new AtomicNumberRule<IAtom>(new PsuedoAtomicNumberModifier<IAtom>(atom -> atom.getAtomicNumber() == null ? 0 : atom.getAtomicNumber())), new DuplicateAtomRule(), new MassNumberRule<IAtom>(atom -> atom.getMassNumber() == null ? 11 : atom.getMassNumber()), new ZERule(), new PairRule(new PrimaryDescriptor()), new RSRule(new PrimaryDescriptor())), new CombinedRule(new AtomicNumberRule<IAtom>(new PsuedoAtomicNumberModifier<IAtom>(atom -> atom.getAtomicNumber() == null ? 0 : atom.getAtomicNumber())), new MassNumberRule<IAtom>(atom -> atom.getMassNumber()), new ZERule(), new PairRule(new AuxiliaryDescriptor()), new RSRule(new AuxiliaryDescriptor())), new CDK2DSignCalculator());
    }

    public void perceive(IAtomContainer container) {
        try {
            if (!GeometryUtil.has2DCoordinates(container)) {
                try {
                    IAtomContainer clone = container.clone();
                    StructureDiagramGenerator sdg = new StructureDiagramGenerator(clone);
                    sdg.generateCoordinates();
                    container = sdg.getMolecule();
                }
                catch (CDKException clone) {
                    // empty catch block
                }
            }
            this.perceive(new CDKCentreProvider(container), new CDKManager(container));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("WARNING: 2D CDK based stereo perception failed! " + e);
        }
    }
}

