/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.graph;

import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.MutableDescriptor;

public class Arc<A> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Arc.class);
    private Ligand<A> tail;
    private Ligand<A> head;
    private MutableDescriptor descriptor;
    private int depth = 0;

    public Arc(Ligand<A> tail, Ligand<A> head, MutableDescriptor descriptor) {
        this.tail = tail;
        this.head = head;
        this.descriptor = descriptor;
    }

    public Arc(Ligand<A> tail, Ligand<A> head, MutableDescriptor descriptor, int depth) {
        this.tail = tail;
        this.head = head;
        this.descriptor = descriptor;
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public Descriptor getDescriptor() {
        return this.descriptor.get();
    }

    public Ligand<A> getHead() {
        return this.head;
    }

    public Ligand<A> getTail() {
        return this.tail;
    }

    public void transpose() {
        Ligand<A> tmp = this.tail;
        this.tail = this.head;
        this.head = tmp;
        this.depth *= -1;
        this.head.setParent(this.tail.getAtom());
        this.head.reset();
        this.tail.reset();
    }

    public String toString() {
        return this.tail + " -> " + this.head;
    }
}

