/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.graph;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.descriptor.General;

public class DefaultDescriptorManager<A>
implements DescriptorManager<A> {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(DefaultDescriptorManager.class);
    private final Map<A, MutableDescriptor> atomMap = new HashMap<A, MutableDescriptor>();
    private final Map<Map.Entry<A, A>, MutableDescriptor> bondMap = new HashMap<Map.Entry<A, A>, MutableDescriptor>();

    @Override
    public MutableDescriptor getDescriptor(A atom) {
        MutableDescriptor mutableDescriptor = this.atomMap.get(atom);
        if (mutableDescriptor == null) {
            mutableDescriptor = new MutableDescriptor();
            this.atomMap.put(atom, mutableDescriptor);
        }
        return mutableDescriptor;
    }

    @Override
    public MutableDescriptor getDescriptor(A first, A second) {
        AbstractMap.SimpleEntry<A, A> entry = new AbstractMap.SimpleEntry<A, A>(first, second);
        MutableDescriptor mutableDescriptor = this.bondMap.get(entry);
        if (mutableDescriptor == null) {
            mutableDescriptor = new MutableDescriptor();
            this.bondMap.put(entry, mutableDescriptor);
            this.bondMap.put(new AbstractMap.SimpleEntry<A, A>(second, first), mutableDescriptor);
        }
        return mutableDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.atomMap.entrySet().stream().filter(entry -> ((MutableDescriptor)entry.getValue()).get() != General.UNKNOWN).forEachOrdered(entry -> sb.append(entry.getKey()).append(": ").append(((MutableDescriptor)entry.getValue()).get()).append(NEW_LINE));
        this.bondMap.entrySet().stream().filter(entry -> ((MutableDescriptor)entry.getValue()).get() != General.UNKNOWN).forEachOrdered(entry -> sb.append(((Map.Entry)entry.getKey()).getKey()).append("=").append(((Map.Entry)entry.getKey()).getValue()).append(": ").append(((MutableDescriptor)entry.getValue()).get()).append(NEW_LINE));
        return sb.toString();
    }

    @Override
    public void clear() {
        this.atomMap.clear();
        this.bondMap.clear();
    }
}

