/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.centres.Digraph;
import uk.ac.ebi.centres.Ligand;

public abstract class CytoscapeWriter<A>
implements Closeable {
    static final String NEW_LINE = System.getProperty("line.separator");
    private final Digraph<A> digraph;
    private Writer sif;
    private File folder;
    private final Map<String, Map<String, String>> attributes = new HashMap<String, Map<String, String>>();

    public CytoscapeWriter(File folder, Digraph<A> digraph) throws IOException {
        this.digraph = digraph;
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("Folder should be a directory");
        }
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalArgumentException("Unable to create folder");
        }
        this.folder = folder;
        this.sif = new FileWriter(new File(folder, folder.getName().replace(" ", "-") + ".sif"));
    }

    public void writeSif() throws IOException {
        this.write(this.digraph.getProximal(), "1");
    }

    public void writeAttributes() throws IOException {
        for (Map.Entry<String, Map<String, String>> entry : this.attributes.entrySet()) {
            try (FileWriter attributeWriter = new FileWriter(new File(this.folder, entry.getKey() + ".noa"));){
                attributeWriter.write(entry.getKey().replaceAll(" ", ".") + " (class=String)" + NEW_LINE);
                for (Map.Entry<String, String> nodeEntry : entry.getValue().entrySet()) {
                    attributeWriter.write(nodeEntry.getKey() + " = " + nodeEntry.getValue() + NEW_LINE);
                }
            }
        }
    }

    private void write(List<Ligand<A>> ligands, String sourceId) throws IOException {
        for (int i = 0; i < ligands.size(); ++i) {
            Ligand<A> ligand = ligands.get(i);
            String targetId = sourceId + Integer.toString(i + 1);
            this.sif.write(sourceId + "\t->\t" + targetId + "\n");
            HashMap<String, String> map = new HashMap<String, String>();
            this.mapAttributes(ligand.getAtom(), map);
            map.entrySet().stream().map(e -> {
                if (!this.attributes.containsKey(e.getKey())) {
                    this.attributes.put((String)e.getKey(), new HashMap());
                }
                return e;
            }).forEachOrdered(e -> this.attributes.get(e.getKey()).put(targetId, (String)e.getValue()));
            this.write(ligands.get(i).getLigands(), targetId);
        }
    }

    public abstract void mapAttributes(A var1, Map<String, String> var2);

    @Override
    public void close() throws IOException {
        this.sif.close();
    }
}

