/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.ligand;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import uk.ac.ebi.centres.ConnectionProvider;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.descriptor.General;
import uk.ac.ebi.centres.graph.Arc;

public abstract class AbstractLigand<A>
implements Ligand<A> {
    private Descriptor auxiliary = General.UNKNOWN;
    private ConnectionProvider<A> provider;
    private final Set<A> visited;
    private final MutableDescriptor descriptor;
    private final int distance;
    private boolean duplicate;
    private List<Ligand<A>> ligands;
    private Descriptor descriptorCache;

    public AbstractLigand(ConnectionProvider<A> provider, Set<A> visited, MutableDescriptor descriptor, int distance) {
        this.provider = provider;
        this.descriptor = descriptor;
        this.distance = distance;
        this.visited = Sets.newHashSet(visited);
    }

    public AbstractLigand(Set<A> visited, MutableDescriptor descriptor, int distance) {
        this.descriptor = descriptor;
        this.distance = distance;
        this.visited = Sets.newHashSet(visited);
    }

    public AbstractLigand(MutableDescriptor descriptor, int distance) {
        this.descriptor = descriptor;
        this.distance = distance;
        this.visited = Collections.EMPTY_SET;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public ConnectionProvider<A> getProvider() {
        return this.provider;
    }

    public void setProvider(ConnectionProvider<A> provider) {
        this.provider = provider;
    }

    @Override
    public Boolean isVisited(A atom) {
        return this.visited.contains(atom);
    }

    @Override
    public Set<A> getVisited() {
        return this.visited;
    }

    @Override
    public void setDescriptor(Descriptor descriptor) {
        this.descriptor.set(descriptor);
    }

    @Override
    public Descriptor getDescriptor() {
        if (this.descriptorCache == null) {
            Descriptor descriptor = this.descriptor.get();
            if (descriptor == General.NONE) {
                this.descriptorCache = descriptor;
            }
            return descriptor;
        }
        return this.descriptorCache;
    }

    @Override
    public List<Ligand<A>> getLigands() {
        if (this.ligands == null) {
            this.ligands = this.provider.getLigands(this);
        }
        return this.ligands;
    }

    @Override
    public void reset() {
        this.ligands = null;
    }

    public String toString() {
        Object atom = this.getAtom();
        if (atom instanceof IAtom) {
            return ((IElement)atom).getSymbol() + ((IChemObject)atom).getProperty("number");
        }
        return "Non CDK Atom";
    }

    @Override
    public List<Arc<A>> getArcs() {
        return this.provider.getArcs(this);
    }

    @Override
    public Arc<A> getParentArc() {
        return this.provider.getParentArc(this);
    }

    @Override
    public int getDistanceFromRoot() {
        return this.distance;
    }

    @Override
    public Descriptor getAuxiliary() {
        return this.auxiliary;
    }

    @Override
    public void setAuxiliary(Descriptor descriptor) {
        this.auxiliary = descriptor;
    }

    @Override
    public int getDepth() {
        Arc<A> arc = this.getParentArc();
        return arc == null ? 0 : arc.getDepth();
    }

    @Override
    public boolean isBranching() {
        return Boolean.FALSE;
    }

    @Override
    public boolean isTerminal() {
        return Boolean.FALSE;
    }
}

