/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.ligand;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Centre;
import uk.ac.ebi.centres.ConnectionProvider;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.Priority;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.SignCalculator;
import uk.ac.ebi.centres.descriptor.General;
import uk.ac.ebi.centres.descriptor.Planar;
import uk.ac.ebi.centres.ligand.AbstractLigand;
import uk.ac.ebi.centres.ligand.NonterminalLigand;

public class PlanarCentre<A>
extends AbstractLigand<A>
implements Centre<A> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(PlanarCentre.class);
    private final AbstractLigand<A> first;
    private final AbstractLigand<A> second;
    private final Set<A> atoms;

    public PlanarCentre(A first, A second, MutableDescriptor descriptor) {
        super(descriptor, 0);
        PlanarCentre self = this;
        this.first = new NonterminalLigand<A>(descriptor, first, second, 0);
        this.second = new NonterminalLigand<A>(descriptor, second, first, 0);
        this.atoms = Sets.newHashSet(first, second);
    }

    @Override
    public void setProvider(ConnectionProvider<A> provider) {
        super.setProvider(provider);
        this.first.setProvider(provider);
        this.second.setProvider(provider);
    }

    @Override
    public List<Ligand<A>> getLigands() {
        ArrayList<Ligand<A>> ligands = new ArrayList<Ligand<A>>(16);
        ligands.addAll(this.first.getLigands());
        ligands.addAll(this.second.getLigands());
        return ligands;
    }

    @Override
    public A getAtom() {
        throw new NoSuchMethodError("Centre does not have a single atom");
    }

    @Override
    public String toString() {
        if (this.first.getAtom() instanceof IAtom) {
            return ((IElement)this.first.getAtom()).getSymbol() + ((IChemObject)this.first.getAtom()).getProperty("number") + "=" + ((IElement)this.second.getAtom()).getSymbol() + ((IChemObject)this.second.getAtom()).getProperty("number");
        }
        return this.first.getAtom().toString() + "=" + this.second.getAtom().toString();
    }

    @Override
    public Boolean isParent(Object atom) {
        return this.atoms.contains(atom);
    }

    @Override
    public Set<A> getAtoms() {
        return this.atoms;
    }

    @Override
    public A getParent() {
        throw new UnsupportedOperationException("Can't get parent on a planar centre");
    }

    @Override
    public void setParent(A atom) {
        throw new UnsupportedOperationException("Can't set parent on a planar centre");
    }

    @Override
    public int perceiveAuxiliary(Collection<Centre<A>> centres, PriorityRule<A> rule, SignCalculator<A> calculator) {
        return 0;
    }

    @Override
    public Descriptor perceive(List<Ligand<A>> proximal, PriorityRule<A> rule, SignCalculator<A> calculator) {
        return General.UNKNOWN;
    }

    @Override
    public Descriptor perceive(PriorityRule<A> rule, SignCalculator<A> calculator) {
        boolean pseudo;
        List<Ligand<A>> firstLigands = this.first.getLigands();
        List<Ligand<A>> secondLigands = this.second.getLigands();
        if (firstLigands.isEmpty() || secondLigands.isEmpty()) {
            return General.NONE;
        }
        Priority firstPriority = rule.prioritise(firstLigands);
        Priority secondPriority = rule.prioritise(secondLigands);
        if (!firstPriority.isUnique().booleanValue() || !secondPriority.isUnique().booleanValue()) {
            return General.UNKNOWN;
        }
        int firstSign = calculator.getSign(firstLigands.iterator().next().getAtom(), this.first.getAtom(), this.second.getAtom());
        int secondSign = calculator.getSign(secondLigands.iterator().next().getAtom(), this.second.getAtom(), this.first.getAtom());
        if (firstSign == 0 || secondSign == 0) {
            return General.UNSPECIFIED;
        }
        boolean bl = pseudo = firstPriority.getType().equals((Object)Descriptor.Type.PSEUDO_ASYMMETRIC) && secondPriority.getType().equals((Object)Descriptor.Type.PSEUDO_ASYMMETRIC);
        return firstSign == secondSign ? (pseudo ? Planar.e : Planar.E) : (pseudo ? Planar.z : Planar.Z);
    }

    @Override
    public void dispose() {
        this.getProvider().dispose();
        this.setProvider(null);
    }
}

