/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.ligand;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Centre;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.Priority;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.SignCalculator;
import uk.ac.ebi.centres.descriptor.General;
import uk.ac.ebi.centres.descriptor.Tetrahedral;
import uk.ac.ebi.centres.ligand.AbstractLigand;

public class TetrahedralCentre<A>
extends AbstractLigand<A>
implements Centre<A> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(TetrahedralCentre.class);
    private final A atom;
    private A parent;

    public TetrahedralCentre(MutableDescriptor descriptor, A atom) {
        super(descriptor, 0);
        this.atom = atom;
        this.parent = atom;
    }

    @Override
    public A getAtom() {
        return this.atom;
    }

    @Override
    public void setParent(A atom) {
        this.parent = atom;
    }

    @Override
    public A getParent() {
        return this.parent;
    }

    @Override
    public Set<A> getAtoms() {
        return Collections.singleton(this.atom);
    }

    @Override
    public int perceiveAuxiliary(Collection<Centre<A>> centres, PriorityRule<A> rule, SignCalculator<A> calculator) {
        HashMap auxiliary = new HashMap(centres.size());
        this.getProvider().build();
        for (Centre centre : centres) {
            if (centre == this || centre.getAtoms().size() != 1) continue;
            for (Ligand ligand : this.getProvider().getLigands(centre.getAtom())) {
                this.getProvider().reroot(ligand);
                Descriptor descriptor = centre.perceive(this.getProvider().getLigands(ligand), rule, calculator);
                if (descriptor == General.UNKNOWN) continue;
                auxiliary.put(ligand, descriptor);
            }
        }
        for (Map.Entry entry : auxiliary.entrySet()) {
            ((Ligand)entry.getKey()).setAuxiliary((Descriptor)entry.getValue());
        }
        this.getProvider().reroot(this);
        return auxiliary.size();
    }

    @Override
    public Descriptor perceive(List<Ligand<A>> proximal, PriorityRule<A> rule, SignCalculator<A> calculator) {
        if (proximal.size() < 3) {
            return General.NONE;
        }
        Priority priority = rule.prioritise(proximal);
        if (priority.isUnique().booleanValue()) {
            if (proximal.size() < 4) {
                proximal.add(this);
            }
            int sign = calculator.getSign(proximal.get(0), proximal.get(1), proximal.get(2), proximal.get(3));
            boolean pseudo = priority.getType().equals((Object)Descriptor.Type.PSEUDO_ASYMMETRIC);
            return sign > 0 ? (pseudo ? Tetrahedral.s : Tetrahedral.S) : (sign < 0 ? (pseudo ? Tetrahedral.r : Tetrahedral.R) : General.UNSPECIFIED);
        }
        return General.UNKNOWN;
    }

    @Override
    public Descriptor perceive(PriorityRule<A> rule, SignCalculator<A> calculator) {
        return this.perceive(this.getLigands(), rule, calculator);
    }

    @Override
    public Boolean isParent(A atom) {
        return this.parent.equals(atom);
    }

    @Override
    public void dispose() {
        this.getProvider().dispose();
        this.setProvider(null);
    }
}

