/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority;

import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.priority.AbstractPriorityRule;
import uk.ac.ebi.centres.priority.access.AtomicNumberAccessor;

public class AtomicNumberRule<A>
extends AbstractPriorityRule<A> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(AtomicNumberRule.class);
    private final AtomicNumberAccessor<A> accessor;

    public AtomicNumberRule(AtomicNumberAccessor<A> accessor) {
        super(PriorityRule.Type.CONSTITUTIONAL);
        this.accessor = accessor;
    }

    @Override
    public int compare(Ligand<A> o1, Ligand<A> o2) {
        if (this.accessor == null || o1.getAtom() == null) {
            System.out.println(this.accessor + " 1 NULL");
        }
        if (this.accessor == null || o2.getAtom() == null) {
            System.out.println(this.accessor + " 2 NULL");
        }
        IAtom a = (IAtom)o1.getAtom();
        IAtom b = (IAtom)o2.getAtom();
        return this.getAtomicNumber(a) - this.getAtomicNumber(b);
    }

    public int getAtomicNumber(IAtom o) {
        if (o != null && !(o instanceof IPseudoAtom) && o.getAtomicNumber() == null) {
            try {
                int massNumber = Isotopes.getInstance().getMajorIsotope(o.getAtomicNumber()).getAtomicNumber();
                return massNumber;
            }
            catch (Exception e) {
                return 6;
            }
        }
        if (o instanceof IPseudoAtom) {
            return 6;
        }
        return 0;
    }
}

