/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority;

import com.google.common.collect.Lists;
import java.util.List;
import uk.ac.ebi.centres.Comparison;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.LigandComparison;
import uk.ac.ebi.centres.LigandSorter;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.priority.AbstractPriorityRule;
import uk.ac.ebi.centres.priority.InsertionSorter;

public final class CombinedRule<A>
extends AbstractPriorityRule<A> {
    private final List<PriorityRule<A>> rules;

    public CombinedRule() {
        super(PriorityRule.Type.COMBINED);
        this.rules = Lists.newArrayListWithExpectedSize(8);
    }

    public CombinedRule(PriorityRule<A> ... rules) {
        super(PriorityRule.Type.COMBINED);
        this.rules = Lists.newArrayListWithExpectedSize(rules.length);
        for (PriorityRule<A> rule : rules) {
            this.add(rule);
        }
    }

    public void add(PriorityRule<A> rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Provided priority rule wasnull!");
        }
        this.rules.add(rule);
        rule.setSorter(this.createSorter(this.rules));
    }

    public LigandSorter<A> createSorter(List<PriorityRule<A>> rules) {
        return new InsertionSorter<A>(rules, PriorityRule.Type.CONSTITUTIONAL);
    }

    @Override
    public int compare(Ligand<A> o1, Ligand<A> o2) {
        for (PriorityRule<A> rule : this.rules) {
            if (this.isHalted()) {
                return 0;
            }
            int value = rule.recursiveCompare(o1, o2);
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    @Override
    public Comparison compareLigands(Ligand<A> o1, Ligand<A> o2) {
        for (PriorityRule<A> rule : this.rules) {
            if (this.isHalted()) {
                return new LigandComparison(0, Descriptor.Type.NON_STEREOGENIC);
            }
            int value = rule.recursiveCompare(o1, o2);
            if (value == 0) continue;
            return new LigandComparison(value, rule.getType());
        }
        return new LigandComparison(0, Descriptor.Type.NON_STEREOGENIC);
    }

    @Override
    public void setHalt(boolean halt) {
        for (PriorityRule<A> rule : this.rules) {
            rule.setHalt(halt);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Combined rule:");
        for (PriorityRule<A> rule : this.rules) {
            builder.append(rule.toString()).append(", ");
        }
        return builder.toString();
    }
}

