/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ebi.centres.Comparison;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.LigandSorter;
import uk.ac.ebi.centres.Priority;
import uk.ac.ebi.centres.PriorityRule;

public class InsertionSorter<A>
implements LigandSorter<A> {
    private final List<PriorityRule<A>> rules = new ArrayList<PriorityRule<A>>(5);

    public InsertionSorter(PriorityRule<A> comparator) {
        this.rules.add(comparator);
    }

    public InsertionSorter(List<PriorityRule<A>> comparators, PriorityRule.Type restrict) {
        for (PriorityRule<A> rule : comparators) {
            if (!rule.getRuleType().equals((Object)restrict)) continue;
            this.rules.add(rule);
        }
    }

    public InsertionSorter(List<PriorityRule<A>> comparators) {
        this.rules.addAll(comparators);
    }

    @Override
    public Priority prioritise(List<Ligand<A>> ligands) {
        Boolean unique = Boolean.TRUE;
        Descriptor.Type type = Descriptor.Type.NON_STEREOGENIC;
        block0: for (int i = 0; i < ligands.size(); ++i) {
            for (int j = i; j > 0; --j) {
                Comparison comparison = this.compareLigands(ligands.get(j - 1), ligands.get(j));
                Descriptor.Type type2 = type = comparison.getType().ordinal() > type.ordinal() ? comparison.getType() : type;
                if (comparison.getOrder() >= 0) {
                    if (comparison.getOrder() != 0) continue block0;
                    unique = Boolean.FALSE;
                    continue block0;
                }
                this.swap(ligands, j, j - 1);
            }
        }
        return new Priority(unique, type);
    }

    public Comparison compareLigands(Ligand<A> first, Ligand<A> second) {
        for (PriorityRule<A> rule : this.rules) {
            Comparison comparison = rule.compareLigands(first, second);
            if (comparison.getOrder() == 0) continue;
            return comparison;
        }
        return new Comparison(){

            @Override
            public Integer getOrder() {
                return 0;
            }

            @Override
            public Descriptor.Type getType() {
                return Descriptor.Type.NON_STEREOGENIC;
            }
        };
    }

    public void swap(List list, int i, int j) {
        Object tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    @Override
    public List<List<Ligand<A>>> getGroups(List<Ligand<A>> sorted) {
        LinkedList groups = new LinkedList();
        sorted.stream().map(ligand -> {
            if (groups.isEmpty() || this.compareLigands((Ligand)((List)groups.getLast()).iterator().next(), (Ligand<A>)ligand).getOrder() != 0) {
                groups.add(new ArrayList());
            }
            return ligand;
        }).forEachOrdered(ligand -> ((List)groups.getLast()).add(ligand));
        return groups;
    }
}

